/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.componentcore.util.EARVirtualComponent;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.FacetedProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JavaEEProjectUtilities
extends ProjectUtilities
implements IJ2EEFacetConstants {
    protected static final IVirtualReference[] NO_REFERENCES = new IVirtualReference[0];
    public static final int FACET_VERSION = 0;
    public static final int DD_VERSION = 1;

    public static boolean isProjectOfType(IProject project, String typeID) {
        return JavaEEProjectUtilities.getProjectFacetVersion(project, typeID) != null;
    }

    public static IProjectFacetVersion getProjectFacetVersion(IProject project, String typeID) {
        return FacetedProjectUtilities.getProjectFacetVersion((IProject)project, (String)typeID);
    }

    private static boolean isProjectOfType(IFacetedProject facetedProject, String typeID) {
        return FacetedProjectUtilities.isProjectOfType((IFacetedProject)facetedProject, (String)typeID);
    }

    private static boolean isEARProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ear");
    }

    private static boolean isDynamicWebProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.web");
    }

    private static boolean isStaticWebProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "wst.web");
    }

    private static boolean isEJBProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ejb");
    }

    private static boolean isJCAProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.connector");
    }

    private static boolean isApplicationClientProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.appclient");
    }

    private static boolean isUtilityProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.utility");
    }

    public static boolean isEARProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ear");
    }

    public static boolean isDynamicWebComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 4);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.web");
    }

    public static boolean isDynamicWebProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.web");
    }

    public static boolean isWebFragmentProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.webfragment");
    }

    public static boolean isWebFragmentProject(IFacetedProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.webfragment");
    }

    public static boolean isWebFragmentProject(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 6);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.webfragment");
    }

    public static boolean isStaticWebProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "wst.web");
    }

    public static boolean isEJBComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 0);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.ejb");
    }

    public static boolean isEJBProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.ejb");
    }

    public static boolean isJCAComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 2);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.connector");
    }

    public static boolean isJCAProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.connector");
    }

    public static boolean isApplicationClientComponent(IVirtualComponent component) {
        if (component.isBinary()) {
            return JavaEEProjectUtilities.isBinaryType(component, 3);
        }
        return JavaEEProjectUtilities.isProjectOfType(component.getProject(), "jst.appclient");
    }

    public static boolean isApplicationClientProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.appclient");
    }

    public static boolean isUtilityProject(IProject project) {
        return JavaEEProjectUtilities.isProjectOfType(project, "jst.utility");
    }

    public static IProject[] getAllProjectsInWorkspaceOfType(String type) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (JavaEEProjectUtilities.isProjectOfType(projects[i], type)) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    private static boolean isBinaryType(IVirtualComponent aBinaryComponent, int quickPeekType) {
        JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(aBinaryComponent);
        int type = qp.getType();
        return quickPeekType == type;
    }

    private static String convertQuickpeekResult(int type) {
        switch (type) {
            case 3: {
                return "jst.appclient";
            }
            case 4: {
                return "jst.web";
            }
            case 0: {
                return "jst.ejb";
            }
            case 2: {
                return "jst.connector";
            }
            case 1: {
                return "jst.ear";
            }
            case 6: {
                return "jst.webfragment";
            }
        }
        return "jst.utility";
    }

    public static String getJ2EEComponentType(IVirtualComponent component) {
        if (component != null) {
            if (component.isBinary()) {
                JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(component);
                return JavaEEProjectUtilities.convertQuickpeekResult(qp.getType());
            }
            return JavaEEProjectUtilities.getJ2EEProjectType(component.getProject());
        }
        return "";
    }

    public static String getJ2EEFileType(IPath path) {
        if (path != null && path.toFile().exists() && path.toFile().isFile()) {
            JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(path);
            return JavaEEProjectUtilities.convertQuickpeekResult(qp.getType());
        }
        return null;
    }

    public static String getJ2EEProjectType(IProject project) {
        if (project != null && project.isAccessible()) {
            IFacetedProject facetedProject = null;
            try {
                facetedProject = ProjectFacetsManager.create((IProject)project);
            }
            catch (CoreException coreException) {
                return "";
            }
            if (JavaEEProjectUtilities.isApplicationClientProject(facetedProject)) {
                return "jst.appclient";
            }
            if (JavaEEProjectUtilities.isDynamicWebProject(facetedProject)) {
                return "jst.web";
            }
            if (JavaEEProjectUtilities.isEJBProject(facetedProject)) {
                return "jst.ejb";
            }
            if (JavaEEProjectUtilities.isEARProject(facetedProject)) {
                return "jst.ear";
            }
            if (JavaEEProjectUtilities.isJCAProject(facetedProject)) {
                return "jst.connector";
            }
            if (JavaEEProjectUtilities.isStaticWebProject(facetedProject)) {
                return "wst.web";
            }
            if (JavaEEProjectUtilities.isUtilityProject(facetedProject)) {
                return "jst.utility";
            }
            if (JavaEEProjectUtilities.isWebFragmentProject(facetedProject)) {
                return "jst.webfragment";
            }
        }
        return "";
    }

    public static boolean deploymentDescriptorExists(IProject project) {
        IVirtualFile ddFile = JavaEEProjectUtilities.getJavaEEDeploymentDescriptor(project);
        return ddFile != null;
    }

    public static JavaEEQuickPeek getDeploymentDescriptorQuickPeek(IProject project) {
        IVirtualFile ddFile = JavaEEProjectUtilities.getJavaEEDeploymentDescriptor(project);
        if (ddFile == null) {
            return null;
        }
        InputStream in = null;
        try {
            JavaEEQuickPeek quickPeek;
            in = ddFile.getUnderlyingFile().getContents();
            JavaEEQuickPeek javaEEQuickPeek = quickPeek = new JavaEEQuickPeek(in);
            return javaEEQuickPeek;
        }
        catch (CoreException e) {
            J2EEPlugin.logError(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    J2EEPlugin.logError(e);
                }
            }
        }
        return null;
    }

    private static IVirtualFile getJavaEEDeploymentDescriptor(IProject project) {
        IVirtualFile vFile;
        if (project == null) {
            throw new NullPointerException();
        }
        String ddURI = null;
        if (JavaEEProjectUtilities.isEARProject(project)) {
            ddURI = "META-INF/application.xml";
        } else if (JavaEEProjectUtilities.isEJBProject(project)) {
            ddURI = "META-INF/ejb-jar.xml";
        } else if (JavaEEProjectUtilities.isApplicationClientProject(project)) {
            ddURI = "META-INF/application-client.xml";
        } else if (JavaEEProjectUtilities.isJCAProject(project)) {
            ddURI = "META-INF/ra.xml";
        } else if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            ddURI = "WEB-INF/web.xml";
        } else if (JavaEEProjectUtilities.isWebFragmentProject(project)) {
            ddURI = "META-INF/web-fragment.xml";
        } else {
            throw new IllegalArgumentException("Project:" + project.getName() + " is not a Java EE Project");
        }
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        if (comp != null && (vFile = comp.getRootFolder().getFile((IPath)new Path(ddURI))).exists()) {
            return vFile;
        }
        return null;
    }

    public static String getJ2EEDDProjectVersion(IProject project) {
        IVirtualComponent comp;
        int type = -1;
        String ddURI = null;
        if (JavaEEProjectUtilities.isEARProject(project)) {
            type = 1;
            ddURI = "META-INF/application.xml";
        } else if (JavaEEProjectUtilities.isEJBProject(project)) {
            type = 0;
            ddURI = "META-INF/ejb-jar.xml";
        } else if (JavaEEProjectUtilities.isApplicationClientProject(project)) {
            type = 3;
            ddURI = "META-INF/application-client.xml";
        } else if (JavaEEProjectUtilities.isJCAProject(project)) {
            type = 2;
            ddURI = "META-INF/ra.xml";
        } else if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            type = 4;
            ddURI = "WEB-INF/web.xml";
        } else if (JavaEEProjectUtilities.isWebFragmentProject(project)) {
            type = 6;
            ddURI = "META-INF/web-fragment.xml";
        }
        if (type != -1 && (comp = ComponentCore.createComponent((IProject)project)) != null) {
            IVirtualFile vFile = comp.getRootFolder().getFile((IPath)new Path(ddURI));
            if (vFile.exists()) {
                InputStream in = null;
                try {
                    in = vFile.getUnderlyingFile().getContents();
                    JavaEEQuickPeek quickPeek = new JavaEEQuickPeek(in);
                    int vers = quickPeek.getVersion() == -1 ? JavaEEProjectUtilities.getLatestVersion(project) : quickPeek.getVersion();
                    String string = J2EEVersionUtil.convertVersionIntToString(vers);
                    return string;
                }
                catch (CoreException e) {
                    J2EEPlugin.logError(e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            J2EEPlugin.logError(e);
                        }
                    }
                }
            }
            return J2EEVersionUtil.convertVersionIntToString(JavaEEProjectUtilities.getLatestVersion(project));
        }
        return null;
    }

    private static int getLatestVersion(IProject project) {
        if (JavaEEProjectUtilities.isEARProject(project) || JavaEEProjectUtilities.isApplicationClientProject(project)) {
            return 60;
        }
        if (JavaEEProjectUtilities.isEJBProject(project)) {
            return 31;
        }
        if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            return 30;
        }
        if (JavaEEProjectUtilities.isWebFragmentProject(project)) {
            return 30;
        }
        return -1;
    }

    public static int getJ2EEVersion(IProject javaEEProject) {
        int retVal = 0;
        return retVal;
    }

    public static boolean isJEEComponent(IVirtualComponent component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (component.isBinary()) {
            JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(component);
            int javaEEVersion = qp.getJavaEEVersion();
            return javaEEVersion >= 50;
        }
        IProject project = component.getProject();
        IProjectFacetVersion facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.ear");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_12 && facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_13 && facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_14;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.appclient");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_12 && facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_13 && facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_14;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.ejb");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.EJB_11 && facetVersion != IJ2EEFacetConstants.EJB_20 && facetVersion != IJ2EEFacetConstants.EJB_21;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.web");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_22 && facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_23 && facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_24;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.connector");
        if (facetVersion != null) {
            return facetVersion != IJ2EEFacetConstants.JCA_10 && facetVersion != IJ2EEFacetConstants.JCA_15;
        }
        facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.webfragment");
        return facetVersion != null;
    }

    public static boolean isJEEComponent(IVirtualComponent component, int versionType) {
        if (component.isBinary()) {
            JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(component);
            int javaEEVersion = qp.getJavaEEVersion();
            return javaEEVersion >= 50;
        }
        IProject project = component.getProject();
        if (versionType == 0) {
            IProjectFacetVersion facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.ear");
            if (facetVersion != null) {
                return facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_12 && facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_13 && facetVersion != IJ2EEFacetConstants.ENTERPRISE_APPLICATION_14;
            }
            facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.appclient");
            if (facetVersion != null) {
                return facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_12 && facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_13 && facetVersion != IJ2EEFacetConstants.APPLICATION_CLIENT_14;
            }
            facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.ejb");
            if (facetVersion != null) {
                return facetVersion != IJ2EEFacetConstants.EJB_11 && facetVersion != IJ2EEFacetConstants.EJB_20 && facetVersion != IJ2EEFacetConstants.EJB_21;
            }
            facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.web");
            if (facetVersion != null) {
                return facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_22 && facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_23 && facetVersion != IJ2EEFacetConstants.DYNAMIC_WEB_24;
            }
            facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.connector");
            if (facetVersion != null) {
                return facetVersion != IJ2EEFacetConstants.JCA_10 && facetVersion != IJ2EEFacetConstants.JCA_15;
            }
            facetVersion = JavaEEProjectUtilities.getProjectFacetVersion(project, "jst.webfragment");
            return facetVersion != null;
        }
        String ddVersion = JavaEEProjectUtilities.getJ2EEDDProjectVersion(project);
        int j2eeLevel = 0;
        if (JavaEEProjectUtilities.isEARProject(project)) {
            j2eeLevel = J2EEVersionUtil.convertVersionStringToInt(ddVersion);
        } else if (JavaEEProjectUtilities.isDynamicWebProject(project)) {
            j2eeLevel = J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID(ddVersion);
        } else if (JavaEEProjectUtilities.isEJBProject(project)) {
            j2eeLevel = J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID(ddVersion);
        } else if (JavaEEProjectUtilities.isJCAProject(project)) {
            j2eeLevel = J2EEVersionUtil.convertConnectorVersionStringToJ2EEVersionID(ddVersion);
        } else if (JavaEEProjectUtilities.isApplicationClientProject(project)) {
            j2eeLevel = J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID(ddVersion);
        } else if (JavaEEProjectUtilities.isWebFragmentProject(project)) {
            j2eeLevel = J2EEVersionUtil.convertWebFragmentVersionStringToJ2EEVersionID(ddVersion);
        }
        return j2eeLevel >= 50;
    }

    public static boolean isLegacyJ2EEComponent(IVirtualComponent component) {
        return !JavaEEProjectUtilities.isJEEComponent(component);
    }

    public static boolean usesJavaEEComponent(IVirtualComponent component) {
        return component != null && (component instanceof J2EEModuleVirtualComponent || component instanceof EARVirtualComponent || component instanceof J2EEModuleVirtualArchiveComponent);
    }

    public static String getComponentURI(IVirtualComponent comp) {
        IModelProvider provider;
        String name = null;
        IProject[] earProjects = EarUtilities.getReferencingEARProjects(comp.getProject());
        if (earProjects.length > 0 && (provider = ModelProviderManager.getModelProvider(earProjects[0])) instanceof IEARModelProvider) {
            name = ((IEARModelProvider)provider).getModuleURI(comp);
        }
        if (name == null || name == "") {
            return VirtualReferenceUtilities.INSTANCE.getDefaultProjectArchiveName(comp);
        }
        return name;
    }
}

