/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.componentcore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyProvider;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyReceiver;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaLiteUtilities;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyEnablement;
import org.eclipse.jst.j2ee.internal.classpathdep.ClasspathDependencyVirtualComponent;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2EEModuleVirtualComponent
extends VirtualComponent
implements IComponentImplFactory,
IClasspathDependencyProvider,
IClasspathDependencyReceiver {
    public static String GET_JAVA_REFS = "GET_JAVA_REFS";
    public static String GET_FUZZY_EAR_REFS = "GET_FUZZY_EAR_REFS";
    private long depGraphModStamp;
    private IVirtualReference[] hardReferences = null;
    private IVirtualReference[] javaReferences = null;
    private IVirtualReference[] parentEarManifestReferences = null;
    private IVirtualReference[] fuzzyEarManifestReferences = null;

    public J2EEModuleVirtualComponent() {
    }

    public J2EEModuleVirtualComponent(IProject aProject, IPath aRuntimePath) {
        super(aProject, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject aProject) {
        return new J2EEModuleVirtualComponent(aProject, (IPath)new Path("/"));
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation, IPath aRuntimePath) {
        return new J2EEModuleVirtualArchiveComponent(aProject, archiveLocation, aRuntimePath);
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return new VirtualFolder(aProject, aRuntimePath);
    }

    public IVirtualReference[] getNonJavaReferences() {
        return this.getReferences(false, false);
    }

    protected IVirtualReference[] getHardReferences() {
        if (this.hardReferences == null || !this.checkIfStillValid()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("REQUESTED_REFERENCE_TYPE", "HARD_REFERENCES");
            this.hardReferences = super.getReferences(map);
        }
        return this.hardReferences;
    }

    protected static IVirtualReference[] getHardReferences(IVirtualComponent component) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("REQUESTED_REFERENCE_TYPE", "HARD_REFERENCES");
        return component.getReferences(map);
    }

    public IVirtualReference[] getJavaClasspathReferences() {
        this.javaReferences = this.getJavaClasspathReferences(this.getHardReferences());
        return this.javaReferences;
    }

    public IVirtualReference[] getReferences(Map<String, Object> options) {
        Object val = options.get("REQUESTED_REFERENCE_TYPE");
        if (val != null) {
            if ("HARD_REFERENCES".equals(val) || "NON_DERIVED_REFERENCES".equals(val) || "DISPLAYABLE_REFERENCES".equals(val)) {
                return this.getHardReferences();
            }
            if ("FLATTENABLE_REFERENCES".equals(val)) {
                return this.getNonManifestReferences();
            }
        }
        Boolean objGetJavaRefs = (Boolean)options.get(GET_JAVA_REFS);
        Boolean objGetFuzzyEarRefs = (Boolean)options.get(GET_FUZZY_EAR_REFS);
        boolean getJavaRefs = objGetJavaRefs != null ? objGetJavaRefs : true;
        boolean findFuzzyEARRefs = objGetFuzzyEarRefs != null ? objGetFuzzyEarRefs : false;
        IVirtualReference[] cachedReferences = this.getReferences(getJavaRefs, findFuzzyEARRefs);
        return cachedReferences;
    }

    public IVirtualReference[] getReferences() {
        return this.getReferences(true, false);
    }

    public IVirtualReference[] getReferences(boolean getJavaRefs, boolean findFuzzyEARRefs) {
        ArrayList<IVirtualReference> all = new ArrayList<IVirtualReference>();
        IVirtualReference[] hardRefs = this.getHardReferences();
        all.addAll(Arrays.asList(hardRefs));
        if (getJavaRefs) {
            all.addAll(Arrays.asList(this.getJavaClasspathReferences(hardRefs)));
        }
        this.cacheManifestReferences();
        all.addAll(Arrays.asList(this.parentEarManifestReferences));
        if (findFuzzyEARRefs) {
            all.addAll(Arrays.asList(this.fuzzyEarManifestReferences));
        }
        IVirtualReference[] retVal = all.toArray(new IVirtualReference[all.size()]);
        VirtualReferenceUtilities.INSTANCE.ensureReferencesHaveNames(retVal);
        return retVal;
    }

    public IVirtualReference[] getNonManifestReferences() {
        ArrayList<IVirtualReference> allRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] hardRefs = this.getHardReferences();
        allRefs.addAll(Arrays.asList(hardRefs));
        allRefs.addAll(Arrays.asList(this.getJavaClasspathReferences(hardRefs)));
        return allRefs.toArray(new IVirtualReference[allRefs.size()]);
    }

    @Deprecated
    public IVirtualReference[] getNonManifestReferences(boolean getJavaRefs) {
        ArrayList<IVirtualReference> allRefs = new ArrayList<IVirtualReference>();
        IVirtualReference[] hardRefs = this.getHardReferences();
        allRefs.addAll(Arrays.asList(hardRefs));
        if (getJavaRefs) {
            allRefs.addAll(Arrays.asList(this.getJavaClasspathReferences(hardRefs)));
        }
        return allRefs.toArray(new IVirtualReference[allRefs.size()]);
    }

    public static String[] getManifestClasspath(IVirtualComponent moduleComponent) {
        return ManifestUtilities.getManifestClasspath((IVirtualComponent)moduleComponent, (IPath)new Path("META-INF/MANIFEST.MF"));
    }

    public IVirtualReference[] getJavaClasspathReferences(IVirtualReference[] hardReferences) {
        boolean isWebApp = JavaEEProjectUtilities.isDynamicWebComponent((IVirtualComponent)this);
        if (!isWebApp && !ClasspathDependencyEnablement.isAllowClasspathComponentDependency()) {
            return new IVirtualReference[0];
        }
        IProject project = this.getProject();
        ArrayList<IVirtualReference> cpRefs = new ArrayList<IVirtualReference>();
        try {
            if (project == null || !project.isAccessible() || !project.hasNature(JavaCoreLite.NATURE_ID)) {
                return new IVirtualReference[0];
            }
            IJavaProjectLite javaProjectLite = JavaCoreLite.create((IProject)project);
            if (javaProjectLite == null) {
                return new IVirtualReference[0];
            }
            Map<IClasspathEntry, IClasspathAttribute> referencedEntries = ClasspathDependencyUtil.getComponentClasspathDependencies(javaProjectLite, isWebApp);
            if (referencedEntries.isEmpty()) {
                return new IVirtualReference[0];
            }
            IVirtualReference[] innerHardReferences = hardReferences == null ? this.getHardReferences() : hardReferences;
            IPath[] hardRefPaths = new IPath[innerHardReferences.length];
            int j = 0;
            while (j < innerHardReferences.length) {
                IVirtualComponent comp = innerHardReferences[j].getReferencedComponent();
                if (comp.isBinary()) {
                    hardRefPaths[j] = (IPath)comp.getAdapter(IPath.class);
                }
                ++j;
            }
            IContainer[] mappedClassFolders = null;
            for (IClasspathEntry entry : referencedEntries.keySet()) {
                IClasspathAttribute attrib = referencedEntries.get(entry);
                boolean isClassFolder = ClasspathDependencyUtil.isClassFolderEntry(entry);
                IPath runtimePath = ClasspathDependencyUtil.getRuntimePath(attrib, isWebApp, isClassFolder);
                boolean add = true;
                IPath entryLocation = ClasspathDependencyUtil.getEntryLocation(entry);
                if (entryLocation == null) {
                    add = false;
                } else if (!isClassFolder) {
                    int j2 = 0;
                    while (j2 < hardRefPaths.length) {
                        if (entryLocation.equals((Object)hardRefPaths[j2])) {
                            add = false;
                            break;
                        }
                        ++j2;
                    }
                } else {
                    if (mappedClassFolders == null) {
                        List containers = JavaLiteUtilities.getJavaOutputContainers((IVirtualComponent)this);
                        mappedClassFolders = containers.toArray(new IContainer[containers.size()]);
                    }
                    int j3 = 0;
                    while (j3 < mappedClassFolders.length) {
                        if (entryLocation.equals((Object)mappedClassFolders[j3].getFullPath())) {
                            add = false;
                            break;
                        }
                        ++j3;
                    }
                }
                if (!add || entryLocation == null) continue;
                String componentPath = null;
                ClasspathDependencyVirtualComponent entryComponent = null;
                componentPath = "cpe/" + entryLocation.toPortableString();
                entryComponent = new ClasspathDependencyVirtualComponent(project, componentPath, isClassFolder);
                IVirtualReference entryReference = ComponentCore.createReference((IVirtualComponent)this, (IVirtualComponent)entryComponent, (IPath)runtimePath);
                ((VirtualReference)entryReference).setDerived(true);
                entryReference.setArchiveName(ClasspathDependencyUtil.getArchiveName(entry));
                cpRefs.add(entryReference);
            }
        }
        catch (CoreException jme) {
            J2EEPlugin.logError(jme);
        }
        return cpRefs.toArray(new IVirtualReference[cpRefs.size()]);
    }

    private void cacheManifestReferences() {
        if (this.parentEarManifestReferences == null || this.fuzzyEarManifestReferences == null) {
            IVirtualReference[][] refs = J2EEModuleVirtualComponent.calculateManifestReferences((IVirtualComponent)this, true);
            this.parentEarManifestReferences = refs[0];
            this.fuzzyEarManifestReferences = refs[1];
        }
    }

    private static IVirtualReference[][] calculateManifestReferences(IVirtualComponent moduleComponent, boolean checkFuzzyRefs) {
        String[] manifestClasspath = J2EEModuleVirtualComponent.getManifestClasspath(moduleComponent);
        IProject[] earProjects = EarUtilities.getReferencingEARProjects(moduleComponent.getProject());
        if (manifestClasspath == null || manifestClasspath.length == 0 || earProjects.length == 0) {
            return new IVirtualReference[][]{new IVirtualReference[0], new IVirtualReference[0]};
        }
        boolean[] foundRefAlready = new boolean[manifestClasspath.length];
        int i = 0;
        while (i < foundRefAlready.length) {
            foundRefAlready[i] = false;
            ++i;
        }
        IProject firstEar = earProjects[earProjects.length - 1];
        ArrayList<IVirtualReference> tmp = J2EEModuleVirtualComponent.cacheOneEarProjectManifestRefs(moduleComponent, firstEar, manifestClasspath, foundRefAlready);
        IVirtualReference[] parentEarManifestReferences = tmp.toArray(new IVirtualReference[tmp.size()]);
        ArrayList<IVirtualReference> dynamicReferences = new ArrayList<IVirtualReference>();
        if (checkFuzzyRefs && earProjects.length > 1) {
            int earIndex = earProjects.length - 2;
            while (earIndex > -1) {
                tmp = J2EEModuleVirtualComponent.cacheOneEarProjectManifestRefs(moduleComponent, firstEar, manifestClasspath, foundRefAlready);
                dynamicReferences.addAll(tmp);
                --earIndex;
            }
        }
        IVirtualReference[] fuzzyEarManifestReferences = dynamicReferences.toArray(new IVirtualReference[dynamicReferences.size()]);
        return new IVirtualReference[][]{parentEarManifestReferences, fuzzyEarManifestReferences};
    }

    protected static ArrayList<IVirtualReference> cacheOneEarProjectManifestRefs(IVirtualComponent moduleComponent, IProject earProject, String[] manifestClasspath, boolean[] foundRefAlready) {
        ArrayList<IVirtualReference> dynamicReferences = new ArrayList<IVirtualReference>();
        IVirtualReference[] hardRefs = J2EEModuleVirtualComponent.getHardReferences(moduleComponent);
        IVirtualReference foundRef = null;
        String earArchiveURI = null;
        boolean simplePath = false;
        IVirtualReference[] earRefs = null;
        IVirtualComponent tempEARComponent = ComponentCore.createComponent((IProject)earProject);
        IVirtualReference[] tempEarRefs = tempEARComponent.getReferences();
        int j = 0;
        while (j < tempEarRefs.length && earRefs == null) {
            if (tempEarRefs[j].getReferencedComponent().equals(moduleComponent)) {
                earRefs = tempEarRefs;
                foundRef = tempEarRefs[j];
                earArchiveURI = foundRef.getArchiveName();
                simplePath = earArchiveURI != null ? earArchiveURI.lastIndexOf("/") == -1 : true;
            }
            ++j;
        }
        if (earRefs != null) {
            int manifestIndex = 0;
            while (manifestIndex < manifestClasspath.length) {
                boolean found = false;
                if (foundRefAlready == null || !foundRefAlready[manifestIndex]) {
                    int j2 = 0;
                    while (j2 < earRefs.length && !found) {
                        String archiveName;
                        if (foundRef != earRefs[j2] && (archiveName = earRefs[j2].getArchiveName()) != null) {
                            boolean shouldAdd = false;
                            String manifestEntryString = manifestClasspath[manifestIndex];
                            if (manifestEntryString != null) {
                                Path manifestPath = new Path(manifestEntryString);
                                manifestEntryString = manifestPath.toPortableString();
                            }
                            if (simplePath && manifestEntryString != null && manifestEntryString.lastIndexOf("/") == -1) {
                                shouldAdd = archiveName.equals(manifestEntryString);
                            } else {
                                String earRelativeURI = ArchiveUtil.deriveEARRelativeURI((String)manifestEntryString, (String)earArchiveURI);
                                if (earRelativeURI != null) {
                                    IPath earRefPath = earRefs[j2].getRuntimePath().makeRelative();
                                    shouldAdd = earRelativeURI.equals(earRefPath.append(archiveName).toString());
                                }
                            }
                            if (shouldAdd) {
                                if (foundRefAlready != null) {
                                    foundRefAlready[manifestIndex] = true;
                                }
                                found = true;
                                boolean shouldInclude = true;
                                IVirtualComponent dynamicComponent = earRefs[j2].getReferencedComponent();
                                if (hardRefs != null) {
                                    int k = 0;
                                    while (k < hardRefs.length && shouldInclude) {
                                        if (hardRefs[k].getReferencedComponent().equals(dynamicComponent)) {
                                            shouldInclude = false;
                                        }
                                        ++k;
                                    }
                                }
                                if (shouldInclude) {
                                    IVirtualReference dynamicReference = ComponentCore.createReference((IVirtualComponent)moduleComponent, (IVirtualComponent)dynamicComponent);
                                    ((VirtualReference)dynamicReference).setDerived(true);
                                    dynamicReferences.add(dynamicReference);
                                }
                            }
                        }
                        ++j2;
                    }
                }
                ++manifestIndex;
            }
        }
        return dynamicReferences;
    }

    public static List getManifestReferences(IVirtualComponent moduleComponent, IVirtualReference[] hardReferences) {
        return J2EEModuleVirtualComponent.getManifestReferences(moduleComponent, hardReferences, false);
    }

    public static List getManifestReferences(IVirtualComponent moduleComponent, IVirtualReference[] hardReferences, boolean findFuzzyEARRefs) {
        IVirtualReference[][] refs = J2EEModuleVirtualComponent.calculateManifestReferences(moduleComponent, findFuzzyEARRefs);
        ArrayList<IVirtualReference> tmp = new ArrayList<IVirtualReference>();
        tmp.addAll(Arrays.asList(refs[0]));
        if (findFuzzyEARRefs) {
            tmp.addAll(Arrays.asList(refs[1]));
        }
        return tmp;
    }

    private boolean checkIfStillValid() {
        boolean valid;
        boolean bl = valid = IDependencyGraph.INSTANCE.getModStamp() == this.depGraphModStamp;
        if (!valid) {
            this.clearCache();
        }
        return valid;
    }

    protected void clearCache() {
        super.clearCache();
        this.depGraphModStamp = IDependencyGraph.INSTANCE.getModStamp();
        this.hardReferences = null;
        this.javaReferences = null;
        this.parentEarManifestReferences = null;
        this.fuzzyEarManifestReferences = null;
    }

    public boolean canReceiveClasspathDependencies() {
        return J2EEProjectUtilities.isDynamicWebProject(this.getProject());
    }

    public IPath getClasspathFolderPath(IClasspathDependencyComponent component) {
        if (J2EEProjectUtilities.isDynamicWebProject(this.getProject())) {
            return new Path("WEB-INF/lib").makeAbsolute();
        }
        return new Path("/");
    }
}

