/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.swtutils.SWTUtils;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs.ThresholdValueTabFunctions;
import org.eclipse.ebam.emf.SbiDomainTransactions;
import org.eclipse.ebam.emf.SbiThresholdValueTransactions;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.ebam.model.entities.SbiThresholdValue;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdValueTabItem
extends CTabItem {
    private ThresholdsDetailComposite thresholdsDetailComposite;
    private Table thresValueTable = null;
    public static final int POSITION = 0;
    public static final int LABEL = 1;
    public final ThresholdValueTabFunctions functions;
    private Text labelText;
    private Spinner thValueSpinner;
    private Combo severityCombo;
    private Spinner minSpinner;
    private Spinner maxSpinner;
    private Button minClosedCheck;
    private Button maxClosedCheck;
    private Label colorLabel;
    Button buttonAdd;
    Button buttonSaveValue;
    Button buttonErase;
    Button buttonUp;
    Button buttonDown;
    public static final int tabIndex = 1;
    private static Logger logger = LoggerFactory.getLogger(ThresholdValueTabItem.class);

    public ThresholdValueTabItem(CTabFolder parent, int style, ThresholdsDetailComposite alComposite) {
        super(parent, style);
        this.thresholdsDetailComposite = alComposite;
        this.functions = new ThresholdValueTabFunctions(this);
    }

    public void drawComp(CTabFolder folder) throws WizardException {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        detailComposite.setLayout((Layout)gridLayout);
        Label titleLabel = new Label(detailComposite, 1);
        titleLabel.setText(" Threshold Values List: ");
        Color color = new Color((Device)detailComposite.getShell().getDisplay(), new RGB(0, 0, 255));
        titleLabel.setForeground(color);
        GridData gTitleName = new GridData(64);
        gTitleName.horizontalSpan = 4;
        titleLabel.setLayoutData((Object)gTitleName);
        this.thresValueTable = new Table(detailComposite, 68100);
        this.thresValueTable.setLinesVisible(true);
        this.thresValueTable.setHeaderVisible(true);
        GridData g = new GridData(1808);
        g.horizontalSpan = 4;
        this.thresValueTable.setLayoutData((Object)g);
        String[] titles = new String[]{"       Position       ", "            Label           "};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.thresValueTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        i = 0;
        while (i < titles.length) {
            this.thresValueTable.getColumn(i).pack();
            ++i;
        }
        this.thresValueTable.redraw();
        this.thresValueTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int selectedIndex = ThresholdValueTabItem.this.thresValueTable.getSelectionIndex();
                    TableItem tableItem = ThresholdValueTabItem.this.thresValueTable.getItem(selectedIndex);
                    ThresholdValueTabItem.this.thresholdsDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.MODIFYING_VAL);
                    ThresholdValueTabItem.this.functions.addThresholdValueSelection(tableItem);
                    ThresholdValueTabItem.this.functions.enableValueDetail(tableItem);
                }
                catch (Exception exception) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)ThresholdValueTabItem.this.thresValueTable.getShell(), (String)"Error", (String)"Error in preparing page for selected Threshold value");
                }
            }
        });
        this.buttonUp = new Button(detailComposite, 8);
        this.buttonUp.setToolTipText("Move up");
        GridData upData = new GridData(32);
        upData.horizontalSpan = 2;
        this.buttonUp.setLayoutData((Object)upData);
        Image upImage = ImageDescriptors.getUpicon().createImage();
        this.buttonUp.setImage(upImage);
        this.buttonUp.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    Integer index = ThresholdValueTabItem.this.thresValueTable.getSelectionIndex();
                    ThresholdValueTabItem.this.functions.moveUpItem(index);
                    ThresholdValueTabItem.this.buttonErase.setEnabled(false);
                }
                catch (Exception exception) {
                    logger.error("Exception in moving up the value");
                    MessageDialog.openError((Shell)ThresholdValueTabItem.this.thresValueTable.getShell(), (String)"Error", (String)"Error in moving up the value");
                }
            }
        });
        this.buttonUp.setEnabled(false);
        this.buttonDown = new Button(detailComposite, 8);
        this.buttonDown.setToolTipText("Move down");
        GridData downData = new GridData(128);
        downData.horizontalSpan = 2;
        this.buttonDown.setLayoutData((Object)downData);
        Image downImage = ImageDescriptors.getDownicon().createImage();
        this.buttonDown.setImage(downImage);
        this.buttonDown.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    Integer index = ThresholdValueTabItem.this.thresValueTable.getSelectionIndex();
                    ThresholdValueTabItem.this.functions.moveDownItem(index);
                    ThresholdValueTabItem.this.buttonErase.setEnabled(false);
                }
                catch (Exception exception) {
                    logger.error("Exception in moving down the value");
                    MessageDialog.openError((Shell)ThresholdValueTabItem.this.thresValueTable.getShell(), (String)"Error", (String)"Error in moving down the value");
                }
            }
        });
        this.buttonDown.setEnabled(false);
        titleLabel = new Label(detailComposite, 1);
        titleLabel.setText("Threshold Values Details: ");
        titleLabel.setForeground(color);
        GridData gDetTitle = new GridData(32);
        gDetTitle.horizontalSpan = 1;
        titleLabel.setLayoutData((Object)gDetTitle);
        this.buttonAdd = new Button(detailComposite, 8);
        this.buttonAdd.setToolTipText("Add a threshold value");
        this.buttonAdd.setLayoutData((Object)new GridData(64));
        Image addImage = ImageDescriptors.getAddIcon().createImage();
        this.buttonAdd.setImage(addImage);
        this.buttonAdd.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Integer thresholdId = ThresholdValueTabItem.this.thresholdsDetailComposite.getListSelectedThresholdId();
                ThresholdValueTabItem.this.thresholdsDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.INSERTING_VAL);
                try {
                    ThresholdValueTabItem.this.functions.addAddButtonPush(thresholdId);
                    ThresholdValueTabItem.this.functions.enableValueDetail(null);
                }
                catch (Exception e) {
                    new WizardException(e, "error while saving new Threshold value");
                }
            }
        });
        this.buttonErase = new Button(detailComposite, 8);
        this.buttonErase.setToolTipText("Erase selected threshold value");
        this.buttonErase.setLayoutData((Object)new GridData(64));
        Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
        this.buttonErase.setImage(eraseImage);
        this.buttonErase.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ThresholdValueTabItem.this.thresholdsDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                    ThresholdValueTabItem.this.functions.eraseThresholdValuePush();
                }
                catch (WizardException wizardException) {
                    logger.error("database connection exception");
                    MessageDialog.openError((Shell)ThresholdValueTabItem.this.thresValueTable.getShell(), (String)"Error", (String)"Error in removing threshold value,\ncheck it is not associated to an existing alarm");
                }
            }
        });
        this.buttonErase.setEnabled(false);
        this.buttonSaveValue = new Button(detailComposite, 8);
        this.buttonSaveValue.setToolTipText("Save new Value");
        this.buttonSaveValue.setLayoutData((Object)new GridData(64));
        Image saveImage = ImageDescriptors.getSaveIcon().createImage();
        this.buttonSaveValue.setImage(saveImage);
        this.buttonSaveValue.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Integer thresholdId = ThresholdValueTabItem.this.thresholdsDetailComposite.getListSelectedThresholdId();
                try {
                    ThresholdValueTabItem.this.functions.saveValueButtonPush(thresholdId);
                    ThresholdValueTabItem.this.functions.disableValueDetail();
                    ThresholdValueTabItem.this.thresholdsDetailComposite.getStatusLabel().setText(ThresholdsDetailComposite.EMPTY);
                }
                catch (Exception e) {
                    new WizardException(e, "error while saving new Threshold value");
                }
            }
        });
        this.buttonSaveValue.setVisible(false);
        GridData gridLabel = SWTUtils.setGridLayoutData(768, 1);
        SWTUtils.drawLabel(detailComposite, "Label", 0, null);
        this.labelText = SWTUtils.drawText(detailComposite, 2048, gridLabel);
        SWTUtils.drawLabel(detailComposite, "Value", 0, null);
        this.thValueSpinner = SWTUtils.drawSpinner(detailComposite, 2048, gridLabel, -100000, 100000, 2);
        SWTUtils.drawLabel(detailComposite, "Min Closed", 0, null);
        this.minClosedCheck = SWTUtils.drawButton(detailComposite, 32, "Min Closed", gridLabel);
        SWTUtils.drawLabel(detailComposite, "Min", 0, null);
        this.minSpinner = SWTUtils.drawSpinner(detailComposite, 2048, gridLabel, -100000, 100000, 2);
        SWTUtils.drawLabel(detailComposite, "Max Closed", 0, null);
        this.maxClosedCheck = SWTUtils.drawButton(detailComposite, 32, "Max Closed", gridLabel);
        SWTUtils.drawLabel(detailComposite, "Max", 0, null);
        this.maxSpinner = SWTUtils.drawSpinner(detailComposite, 2048, gridLabel, -100000, 100000, 2);
        SWTUtils.drawLabel(detailComposite, "Severity", 0, null);
        this.severityCombo = SWTUtils.drawCombo(detailComposite, 2048, gridLabel);
        try {
            List severities = new SbiDomainTransactions().getDomainByDomainCd("SEVERITY");
            for (SbiDomain object : severities) {
                this.severityCombo.add(object.getValueCd());
            }
        }
        catch (Exception exception) {
            logger.error("Error in loading severties domains");
        }
        SWTUtils.drawLabel(detailComposite, "Color", 0, null);
        Composite innerSection = new Composite(detailComposite, 0);
        GridLayout colorGd = new GridLayout();
        colorGd.numColumns = 2;
        colorGd.marginHeight = 0;
        colorGd.marginBottom = 0;
        innerSection.setLayout((Layout)colorGd);
        this.colorLabel = new Label(innerSection, 2048);
        this.colorLabel.setText("          ");
        RGB rgb = null;
        rgb = new RGB(0, 255, 0);
        Color colorL = new Color((Device)detailComposite.getDisplay(), rgb);
        this.colorLabel.setBackground(color);
        String newHexadecimal = SWTUtils.convertRGBToHexadecimal(rgb);
        this.colorLabel.setData((Object)newHexadecimal);
        Button button = new Button(innerSection, 8);
        button.setText("Color...");
        Shell parentShell = detailComposite.getShell();
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Shell centerShell = new Shell(parentShell, 8);
                centerShell.setLocation((parentShell.getSize().x - 222) / 2, (parentShell.getSize().y - 306) / 2);
                ColorDialog colorDg = new ColorDialog(centerShell, 65536);
                colorDg.setRGB(ThresholdValueTabItem.this.colorLabel.getBackground().getRGB());
                RGB rgb = colorDg.open();
                if (rgb != null) {
                    colorL.dispose();
                    Color newColor = new Color((Device)parentShell.getDisplay(), rgb);
                    ThresholdValueTabItem.this.colorLabel.setBackground(newColor);
                    String newHexadecimal = SWTUtils.convertRGBToHexadecimal(rgb);
                    ThresholdValueTabItem.this.colorLabel.setData((Object)newHexadecimal);
                }
                centerShell.dispose();
            }
        });
        this.functions.disableValueDetail();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    public void fillEmptyValues() {
    }

    public void recoverSavingInformations(SbiThreshold sbiThreshold) throws WizardException {
    }

    public void fillThresholdValues(SbiThreshold sbiThreshold) throws Exception {
        List thValues = new SbiThresholdValueTransactions().getOrderedSbiThresholdValueList(Integer.valueOf(sbiThreshold.getThresholdId()));
        this.thresValueTable.removeAll();
        for (SbiThresholdValue sbiThresholdValue : thValues) {
            TableItem item = new TableItem(this.thresValueTable, 0);
            item.setText(0, Integer.valueOf(sbiThresholdValue.getPosition()).toString());
            item.setText(1, sbiThresholdValue.getLabel());
            HashMap<String, Integer> info = new HashMap<String, Integer>();
            info.put("id", sbiThresholdValue.getIdThresholdValue());
            info.put("position", sbiThresholdValue.getPosition());
            item.setData(info);
        }
        this.thresValueTable.setSelection(-1);
        this.buttonErase.setEnabled(false);
        this.functions.disableValueDetail();
        logger.debug("OUT");
    }

    public void disableItems() {
        this.thresValueTable.setEnabled(false);
        this.buttonAdd.setEnabled(false);
        this.buttonSaveValue.setEnabled(false);
        this.functions.disableValueDetail();
        this.buttonErase.setEnabled(false);
    }

    public void enableItems() {
        this.thresValueTable.setEnabled(true);
        this.buttonAdd.setEnabled(true);
        this.buttonSaveValue.setEnabled(true);
    }

    public ThresholdsDetailComposite getThresholdsDetailComposite() {
        return this.thresholdsDetailComposite;
    }

    public void setThresholdsDetailComposite(ThresholdsDetailComposite thresholdsDetailComposite) {
        this.thresholdsDetailComposite = thresholdsDetailComposite;
    }

    public Table getThresValueTable() {
        return this.thresValueTable;
    }

    public void setThresValueTable(Table thresValueTable) {
        this.thresValueTable = thresValueTable;
    }

    public Text getLabelText() {
        return this.labelText;
    }

    public void setLabelText(Text labelText) {
        this.labelText = labelText;
    }

    public Spinner getThValueSpinner() {
        return this.thValueSpinner;
    }

    public void setThValueSpinner(Spinner thValueSpinner) {
        this.thValueSpinner = thValueSpinner;
    }

    public Combo getSeverityCombo() {
        return this.severityCombo;
    }

    public void setSeverityCombo(Combo severityCombo) {
        this.severityCombo = severityCombo;
    }

    public Spinner getMinSpinner() {
        return this.minSpinner;
    }

    public void setMinSpinner(Spinner minSpinner) {
        this.minSpinner = minSpinner;
    }

    public Spinner getMaxSpinner() {
        return this.maxSpinner;
    }

    public void setMaxSpinner(Spinner maxSpinner) {
        this.maxSpinner = maxSpinner;
    }

    public Button getButtonAdd() {
        return this.buttonAdd;
    }

    public void setButtonAdd(Button buttonAdd) {
        this.buttonAdd = buttonAdd;
    }

    public Label getColorLabel() {
        return this.colorLabel;
    }

    public void setColorLabel(Label colorLabel) {
        this.colorLabel = colorLabel;
    }

    public Button getMinClosedCheck() {
        return this.minClosedCheck;
    }

    public void setMinClosedCheck(Button minClosedCheck) {
        this.minClosedCheck = minClosedCheck;
    }

    public Button getMaxClosedCheck() {
        return this.maxClosedCheck;
    }

    public void setMaxClosedCheck(Button maxClosedCheck) {
        this.maxClosedCheck = maxClosedCheck;
    }

    public Button getButtonSaveValue() {
        return this.buttonSaveValue;
    }

    public void setButtonSaveValue(Button buttonSaveValue) {
        this.buttonSaveValue = buttonSaveValue;
    }

    public Button getButtonErase() {
        return this.buttonErase;
    }

    public void setButtonErase(Button buttonErase) {
        this.buttonErase = buttonErase;
    }

    public ThresholdValueTabFunctions getFunctions() {
        return this.functions;
    }

    public Button getButtonUp() {
        return this.buttonUp;
    }

    public void setButtonUp(Button buttonUp) {
        this.buttonUp = buttonUp;
    }

    public Button getButtonDown() {
        return this.buttonDown;
    }

    public void setButtonDown(Button buttonDown) {
        this.buttonDown = buttonDown;
    }
}

