/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.thresholdwidgets;

import org.eclipse.ebam.designers.exception.WizardException;
import org.eclipse.ebam.designers.swtutils.ColorConstants;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdWizardPage;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.ThresholdsListComposite;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs.ThresholdDetailTabItem;
import org.eclipse.ebam.designers.wizards.pages.thresholdwidgets.detailtabs.ThresholdValueTabItem;
import org.eclipse.ebam.emf.SbiThresholdTransactions;
import org.eclipse.ebam.model.entities.SbiThreshold;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdsDetailComposite
extends Composite {
    private ThresholdWizardPage thresholdWizardPage = null;
    private ThresholdDetailTabItem detailTabItem = null;
    private ThresholdValueTabItem thresholdValueTabItem = null;
    private CTabFolder tabFolder = null;
    private Label statusLabel = null;
    public static String INSERTING = "INSERT A NEW THRESHOLD (SAVE BEFORE ADDING VALUES)";
    public static String MODIFYING = "MODIFY SELECTED THRESHOLD";
    public static String INSERTING_VAL = "INSERT A NEW THRESHOLD VALUE";
    public static String MODIFYING_VAL = "MODIFY SELECTED THRESHOLD VALUE";
    public static String EMPTY = "                                                                                                       ";
    private static Logger logger = LoggerFactory.getLogger(ThresholdsDetailComposite.class);

    public ThresholdsDetailComposite(Composite parent, int style, ThresholdWizardPage page) {
        super(parent, style);
        this.thresholdWizardPage = page;
    }

    public void drawComp() {
        logger.debug("IN");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.statusLabel = new Label((Composite)this, 0);
        this.statusLabel.setForeground(new Color((Device)this.getDisplay(), ColorConstants.statusLabelColor));
        this.statusLabel.setText(EMPTY);
        GridData grid = new GridData(64);
        grid.horizontalSpan = 2;
        this.statusLabel.setLayoutData((Object)grid);
        this.tabFolder = new CTabFolder((Composite)this, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setEnabled(false);
        try {
            this.detailTabItem = new ThresholdDetailTabItem(this.tabFolder, 0, this);
            this.detailTabItem.setText("Detail");
            this.detailTabItem.drawComp(this.tabFolder);
            this.thresholdValueTabItem = new ThresholdValueTabItem(this.tabFolder, 0, this);
            this.thresholdValueTabItem.setText("Threshold values");
            this.thresholdValueTabItem.drawComp(this.tabFolder);
        }
        catch (WizardException wizardException) {
            logger.error("Error in preparing threshold detail");
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error in preparing threshold detail");
        }
        logger.debug("OUT");
    }

    public void saveButtonPush() throws WizardException {
        logger.debug("IN");
        Table thresholdsTable = this.getThresholdWizardPage().getListComposite().getThresholdsTable();
        int index = thresholdsTable.getSelectionIndex();
        SbiThreshold sbiThreshold = null;
        if (index == -1) {
            sbiThreshold = new SbiThreshold();
        } else {
            TableItem item = thresholdsTable.getItem(index);
            Integer id = (Integer)item.getData();
            try {
                sbiThreshold = new SbiThresholdTransactions().getSbiThresholdById(id);
            }
            catch (Exception e) {
                logger.error("error in getting sbiThreshold with id " + id, (Throwable)e);
                throw new WizardException(e, "error in getting sbiThreshold with id " + id);
            }
        }
        ThresholdDetailTabItem thresholdDetailTabItem = (ThresholdDetailTabItem)this.tabFolder.getItem(0);
        thresholdDetailTabItem.recoverSavingInformations(sbiThreshold);
        ThresholdValueTabItem thresholdValueTabItem = (ThresholdValueTabItem)this.tabFolder.getItem(1);
        thresholdValueTabItem.recoverSavingInformations(sbiThreshold);
        SbiThresholdTransactions sbiTh = new SbiThresholdTransactions();
        try {
            if (index == -1) {
                sbiTh.createNewSbiThreshold(sbiThreshold);
                TableItem tableItem = new TableItem(thresholdsTable, 0);
                tableItem.setText(0, sbiThreshold.getCode());
                tableItem.setText(1, sbiThreshold.getName());
                tableItem.setText(2, sbiThreshold.getSbiDomain().getValueNm());
                tableItem.setData((Object)sbiThreshold.getThresholdId());
            } else {
                sbiTh.mergeSbiThreshold(sbiThreshold);
                TableItem item = thresholdsTable.getItem(index);
                item.setText(0, sbiThreshold.getCode());
                item.setText(1, sbiThreshold.getName());
                item.setText(2, sbiThreshold.getSbiDomain().getValueNm());
            }
        }
        catch (Exception e1) {
            logger.error("Error in inserting o updating threshold ", (Throwable)e1);
            throw new WizardException(e1, "Error in inserting or updating threshold");
        }
        thresholdsTable.setSelection(-1);
        this.afterSaveButtonPush(this.tabFolder);
        logger.debug("OUT");
    }

    public void afterSaveButtonPush(CTabFolder tabFolder) {
        logger.debug("IN");
        ThresholdsListComposite listComp = this.getThresholdWizardPage().getListComposite();
        listComp.buttonErase.setEnabled(false);
        listComp.getThresholdsTable().setSelection(-1);
        tabFolder.setSelection(0);
        tabFolder.setEnabled(false);
        logger.debug("OUT");
    }

    public Integer getListSelectedThresholdId() {
        logger.debug("IN");
        ThresholdsListComposite listComp = this.getThresholdWizardPage().getListComposite();
        int selectedIndex = listComp.getThresholdsTable().getSelectionIndex();
        if (selectedIndex == -1) {
            return null;
        }
        TableItem item = listComp.getThresholdsTable().getItem(selectedIndex);
        if (item == null) {
            return null;
        }
        Object o = item.getData();
        if (o == null) {
            return null;
        }
        Integer id = (Integer)o;
        logger.debug("OUT");
        return id;
    }

    public ThresholdWizardPage getThresholdWizardPage() {
        return this.thresholdWizardPage;
    }

    public void setThresholdWizardPage(ThresholdWizardPage ThresholdWizardPage2) {
        this.thresholdWizardPage = ThresholdWizardPage2;
    }

    public ThresholdDetailTabItem getDetailTabItem() {
        return this.detailTabItem;
    }

    public void setDetailTabItem(ThresholdDetailTabItem detailTabItem) {
        this.detailTabItem = detailTabItem;
    }

    public ThresholdValueTabItem getThresholdValueTabItem() {
        return this.thresholdValueTabItem;
    }

    public void setThresholdValueTabItem(ThresholdValueTabItem thresholdValueTabItem) {
        this.thresholdValueTabItem = thresholdValueTabItem;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Label getStatusLabel() {
        return this.statusLabel;
    }

    public void setStatusLabel(Label statusLabel) {
        this.statusLabel = statusLabel;
    }

    public void enableSaveButton(boolean enable) {
        ThresholdDetailTabItem thresholdDetailTabItem = (ThresholdDetailTabItem)this.tabFolder.getItem(0);
        thresholdDetailTabItem.getButtonSave().setEnabled(enable);
    }
}

