/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.alarmwidgets.detailtabs;

import java.util.List;
import org.eclipse.ebam.designers.wizards.pages.alarmwidgets.AlarmsDetailComposite;
import org.eclipse.ebam.emf.EbamEventTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlarmEventsTabItem
extends CTabItem {
    Table eventsTable = null;
    AlarmsDetailComposite alarmsDetailComposite = null;
    List<org.eclipse.ebam.model.entities.Event> events = null;
    public static final int tabIndex = 3;
    public static final int NAME = 0;
    public static final int EXPRESSION = 1;
    public static final int HANDLER_CLASS = 2;
    private static Logger logger = LoggerFactory.getLogger(AlarmEventsTabItem.class);

    public AlarmEventsTabItem(CTabFolder parent, int style, AlarmsDetailComposite alarmsDetailComposite1) {
        super(parent, style);
        this.alarmsDetailComposite = alarmsDetailComposite1;
    }

    public void drawComp(CTabFolder folder) {
        logger.debug("IN");
        Composite detailComposite = new Composite((Composite)folder, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        detailComposite.setLayout((Layout)gridLayout);
        this.eventsTable = new Table(detailComposite, 68132);
        this.eventsTable.setLinesVisible(true);
        this.eventsTable.setHeaderVisible(true);
        GridData g = new GridData(1808);
        this.eventsTable.setLayoutData((Object)g);
        this.eventsTable.addListener(13, new Listener(){

            public void handleEvent(Event eventSwt) {
                AlarmEventsTabItem.this.addEventsSelection(eventSwt);
            }
        });
        String[] titles = new String[]{"       Name      ", "       Expression    ", "      Handler  class   "};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.eventsTable, 0);
            column.setText(titles[i]);
            ++i;
        }
        List<org.eclipse.ebam.model.entities.Event> events = this.retrieveEvents();
        int i2 = 0;
        while (i2 < events.size()) {
            org.eclipse.ebam.model.entities.Event ev = events.get(i2);
            TableItem item = new TableItem(this.eventsTable, 0);
            item.setText(0, ev.getName() != null ? ev.getName() : "");
            item.setText(1, ev.getExpression() != null ? ev.getExpression() : "");
            item.setText(2, ev.getHandlerClass() != null ? ev.getHandlerClass() : "");
            Double idD = ev.getEventId();
            Integer id = idD.intValue();
            item.setData((Object)id);
            ++i2;
        }
        i2 = 0;
        while (i2 < titles.length) {
            this.eventsTable.getColumn(i2).pack();
            ++i2;
        }
        this.eventsTable.redraw();
        this.setControl((Control)detailComposite);
        logger.debug("OUT");
    }

    private List<org.eclipse.ebam.model.entities.Event> retrieveEvents() {
        logger.debug("IN");
        EbamEventTransactions ebamEventTransactions = new EbamEventTransactions();
        try {
            this.events = ebamEventTransactions.getEbamEventList();
        }
        catch (Exception exception) {
            logger.error("error in retrieving events");
            return null;
        }
        logger.debug("OUT");
        return this.events;
    }

    public void fillAlarmValues(SbiAlarm sbiAlarm) {
        logger.debug("IN");
        org.eclipse.ebam.model.entities.Event event = sbiAlarm.getEvent();
        if (event == null) {
            return;
        }
        Integer idToCheck = Double.valueOf(event.getEventId()).intValue();
        TableItem[] items = this.eventsTable.getItems();
        boolean found = false;
        int i = 0;
        while (i < items.length && !found) {
            TableItem item = items[i];
            Integer id = (Integer)item.getData();
            if (idToCheck.equals(id)) {
                item.setChecked(true);
                found = true;
            } else {
                item.setChecked(false);
            }
            ++i;
        }
        this.eventsTable.redraw();
        logger.debug("OUT");
    }

    public void addEventsSelection(Event event) {
        TableItem item = (TableItem)event.item;
        Integer id = (Integer)item.getData();
        TableItem[] items = this.eventsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem itemIter = items[i];
            Integer idIter = (Integer)itemIter.getData();
            if (idIter.intValue() != id.intValue()) {
                itemIter.setChecked(false);
            }
            ++i;
        }
    }

    public void recoverSavingInformations(SbiAlarm sbiAlarm) {
        logger.debug("IN");
        TableItem[] items = this.eventsTable.getItems();
        TableItem checked = null;
        try {
            int i = 0;
            while (i < items.length && checked == null) {
                TableItem item = items[i];
                if (item.getChecked()) {
                    checked = item;
                }
                ++i;
            }
            if (checked == null) {
                sbiAlarm.setEvent(null);
            } else {
                Integer checkedId = (Integer)checked.getData();
                org.eclipse.ebam.model.entities.Event eventChecked = new EbamEventTransactions().getEbamEventById(checkedId);
                sbiAlarm.setEvent(eventChecked);
            }
        }
        catch (Exception exception) {
            logger.error("error in saving Event association");
        }
        logger.debug("OUT");
    }

    public void disableFields() {
        this.eventsTable.setEnabled(false);
    }

    public void enableFields() {
        this.eventsTable.setEnabled(true);
    }

    public Table getEventsTable() {
        return this.eventsTable;
    }

    public void setEventsTable(Table contactsTable) {
        this.eventsTable = contactsTable;
    }

    public AlarmsDetailComposite getAlarmsDetailComposite() {
        return this.alarmsDetailComposite;
    }

    public void setAlarmsDetailComposite(AlarmsDetailComposite alarmsDetailComposite) {
        this.alarmsDetailComposite = alarmsDetailComposite;
    }

    public void fillEmptyValues() {
        TableItem[] items = this.eventsTable.getItems();
        int i = 0;
        while (i < items.length) {
            TableItem type = items[i];
            type.setChecked(false);
            ++i;
        }
    }
}

