/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.CheckActivityJob;
import org.eclipse.mylyn.internal.monitor.ui.IActivityManagerCallback;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractUserActivityMonitor;
import org.eclipse.mylyn.monitor.ui.IActivityContextManager;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityContextManager
implements IActivityContextManager {
    private final Set<IUserAttentionListener> attentionListeners = new CopyOnWriteArraySet<IUserAttentionListener>();
    private final CheckActivityJob checkJob;
    private volatile String lastInteractionOrigin;
    private IWorkingSet[] workingSets;
    private final List<AbstractUserActivityMonitor> activityMonitors;
    public static final String ACTIVITY_TIMEOUT = "org.eclipse.mylyn.monitor.ui.activity.timeout";
    public static final String ACTIVITY_TIMEOUT_ENABLED = "org.eclipse.mylyn.monitor.ui.activity.timeout.enabled";
    private final IPropertyChangeListener WORKING_SET_CHANGE_LISTENER = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("workingSetContentChange".equals(event.getProperty())) {
                ActivityContextManager.this.updateWorkingSetSelection();
            }
        }
    };

    public ActivityContextManager(List<AbstractUserActivityMonitor> monitors) {
        this.activityMonitors = new CopyOnWriteArrayList<AbstractUserActivityMonitor>(monitors);
        this.checkJob = new CheckActivityJob(new IActivityManagerCallback(){

            public void addMonitoredActivityTime(long localStartTime, long currentTime) {
                ActivityContextManager.this.addMonitoredActivityTime(localStartTime, currentTime);
            }

            public void inactive() {
                ActivityContextManager.this.fireInactive();
            }

            public long getLastEventTime() {
                return ActivityContextManager.this.getLastInteractionTime();
            }

            public void active() {
                ActivityContextManager.this.fireActive();
            }
        });
        this.checkJob.setSystem(true);
        this.checkJob.setPriority(10);
    }

    void init(List<AbstractUserActivityMonitor> monitors) {
        this.activityMonitors.addAll(monitors);
    }

    protected void updateWorkingSetSelection() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null) {
                    IWorkbenchPage page = window.getActivePage();
                    ActivityContextManager.this.workingSets = page.getWorkingSets();
                }
            }
        });
    }

    public void start() {
        for (final AbstractUserActivityMonitor monitor : this.activityMonitors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    ActivityContextManager.this.disableFailedMonitor(monitor, e);
                }

                public void run() throws Exception {
                    monitor.start();
                }
            });
        }
        this.updateWorkingSetSelection();
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.WORKING_SET_CHANGE_LISTENER);
        this.checkJob.reschedule();
    }

    public void stop() {
        this.checkJob.cancel();
        for (final AbstractUserActivityMonitor monitor : this.activityMonitors) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    ActivityContextManager.this.disableFailedMonitor(monitor, e);
                }

                public void run() throws Exception {
                    monitor.stop();
                }
            });
        }
        if (Platform.isRunning()) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.WORKING_SET_CHANGE_LISTENER);
        }
    }

    public void addListener(IUserAttentionListener listener) {
        this.attentionListeners.add(listener);
    }

    public void removeListener(IUserAttentionListener listener) {
        this.attentionListeners.remove(listener);
    }

    private void addMonitoredActivityTime(long start, long end) {
        if (end > 0L && start > 0L && end > start) {
            String handle;
            String origin = this.lastInteractionOrigin;
            if (origin == null) {
                origin = "org.eclipse.ui.workbench";
            }
            if ((handle = this.getStructureHandle()) == null) {
                if (this.workingSets != null && this.workingSets.length > 0) {
                    IWorkingSet[] iWorkingSetArray = this.workingSets;
                    int n = this.workingSets.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkingSet workingSet = iWorkingSetArray[n2];
                        String workingSetName = workingSet.getName();
                        this.processWorkbenchEvent(origin, "workingset", workingSetName, start, end);
                        ++n2;
                    }
                } else {
                    this.processWorkbenchEvent(origin, "workingset", "none", start, end);
                }
            } else {
                this.processWorkbenchEvent(origin, "timing", handle, start, end);
            }
        }
    }

    private void processWorkbenchEvent(String origin, String structureKind, String handle, long start, long end) {
        ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, structureKind, handle, origin, null, "added", 1.0f, new Date(start), new Date(end)));
    }

    public void addActivityTime(String handle, long start, long end) {
        if (handle != null) {
            ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", handle, "user", null, "added", 1.0f, new Date(start), new Date(end)));
        }
    }

    @Override
    public void removeActivityTime(String handle, long start, long end) {
        if (handle != null) {
            ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, "timing", handle, "user", null, "removed", 1.0f, new Date(start), new Date(end)));
        }
    }

    private void fireInactive() {
        for (IUserAttentionListener attentionListener : this.attentionListeners) {
            attentionListener.userAttentionLost();
        }
    }

    private void fireActive() {
        for (IUserAttentionListener attentionListener : this.attentionListeners) {
            attentionListener.userAttentionGained();
        }
    }

    public long getLastInteractionTime() {
        for (final AbstractUserActivityMonitor monitor : this.activityMonitors) {
            final boolean[] success = new boolean[1];
            final long[] result = new long[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    ActivityContextManager.this.disableFailedMonitor(monitor, e);
                }

                public void run() throws Exception {
                    if (monitor.isEnabled()) {
                        result[0] = monitor.getLastInteractionTime();
                        ActivityContextManager.this.lastInteractionOrigin = monitor.getOriginId();
                        success[0] = true;
                    }
                }
            });
            if (!success[0]) continue;
            return result[0];
        }
        return -1L;
    }

    private void disableFailedMonitor(AbstractUserActivityMonitor monitor, Throwable e) {
        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.core", NLS.bind((String)"Activity monitor ''{0}'' was disabled due to a failure", monitor.getClass()), e));
        this.activityMonitors.remove(monitor);
    }

    @Override
    public void setInactivityTimeout(int inactivityTimeout) {
        this.checkJob.setInactivityTimeout(inactivityTimeout);
    }

    @Override
    public int getInactivityTimeout() {
        return this.checkJob.getInactivityTimeout();
    }

    public String getStructureHandle() {
        if (ContextCore.getContextManager().getActiveContext().getHandleIdentifier() != null) {
            return ContextCore.getContextManager().getActiveContext().getHandleIdentifier();
        }
        return null;
    }
}

