/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.template;

import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.template.ASTAttribute;
import org.eclipse.birt.core.template.ASTEbody_content;
import org.eclipse.birt.core.template.ASTImage;
import org.eclipse.birt.core.template.ASTTemplate;
import org.eclipse.birt.core.template.ASTText;
import org.eclipse.birt.core.template.ASTValueOf;
import org.eclipse.birt.core.template.ASTViewTimeValueOf;
import org.eclipse.birt.core.template.Node;
import org.eclipse.birt.core.template.Parser;
import org.eclipse.birt.core.template.ParserVisitor;
import org.eclipse.birt.core.template.SimpleNode;
import org.eclipse.birt.core.template.TextTemplate;

public class TemplateParser {
    protected static Logger logger = Logger.getLogger(TemplateParser.class.getName());

    public TextTemplate parse(String text) {
        if (text == null || text.trim().equals("")) {
            return null;
        }
        try {
            ASTTemplate templateNode = new Parser().parse(new StringReader(text));
            TextTemplate template = new TextTemplate();
            new ASTVisitor(template).visit(templateNode, null);
            return template;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
            return null;
        }
    }

    protected class ASTVisitor
    implements ParserVisitor {
        TextTemplate template;

        ASTVisitor(TextTemplate template) {
            this.template = template;
        }

        public Object visit(SimpleNode node, Object data) {
            return data;
        }

        public Object visit(ASTAttribute node, Object data) {
            if (data instanceof TextTemplate.ImageNode) {
                TextTemplate.ImageNode image = (TextTemplate.ImageNode)data;
                image.setAttribute(node.getName(), this.getAttributeValue(node.getValue()));
            } else if (data instanceof TextTemplate.ValueNode) {
                TextTemplate.ValueNode value = (TextTemplate.ValueNode)data;
                if ("format".equalsIgnoreCase(node.getName())) {
                    value.format = this.getAttributeValue(node.getValue());
                } else if ("format-expr".equalsIgnoreCase(node.getName())) {
                    value.formatExpression = this.getAttributeValue(node.getValue());
                }
            } else if (data instanceof TextTemplate.TextNode) {
                StringBuffer attribute = new StringBuffer();
                attribute.append(" " + node.getName() + ":" + node.getValue() + " ");
                return attribute.toString();
            }
            return data;
        }

        public Object visit(ASTValueOf node, Object data) {
            TextTemplate.ValueNode value = new TextTemplate.ValueNode();
            node.childrenAccept(this, value);
            this.template.nodes.add(value);
            return data;
        }

        public Object visit(ASTViewTimeValueOf node, Object data) {
            TextTemplate.ExpressionValueNode value = new TextTemplate.ExpressionValueNode();
            node.childrenAccept(this, value);
            this.template.nodes.add(value);
            return data;
        }

        public Object visit(ASTImage node, Object data) {
            TextTemplate.ImageNode image = new TextTemplate.ImageNode();
            node.childrenAccept(this, image);
            this.template.nodes.add(image);
            return data;
        }

        public Object visit(ASTText node, Object data) {
            TextTemplate.TextNode text = new TextTemplate.TextNode();
            text.content = node.getContent();
            this.template.nodes.add(text);
            return data;
        }

        public Object visit(ASTTemplate node, Object data) {
            return node.childrenAccept(this, data);
        }

        public Object visit(ASTEbody_content node, Object data) {
            if (data instanceof TextTemplate.ImageNode) {
                TextTemplate.ImageNode image = (TextTemplate.ImageNode)data;
                String expr = this.getText(node);
                if (expr != null && expr.length() > 0) {
                    image.setExpr(expr);
                }
            } else if (data instanceof TextTemplate.ValueNode) {
                TextTemplate.ValueNode value = (TextTemplate.ValueNode)data;
                value.value = this.getText(node);
            } else {
                return this.getText(node);
            }
            return data;
        }

        protected String getText(ASTEbody_content node) {
            if (node == null || node.children == null) {
                return null;
            }
            StringBuffer text = new StringBuffer();
            int n = 0;
            while (n < node.children.length) {
                Node obj = node.children[n];
                if (obj instanceof ASTText) {
                    text.append(((ASTText)obj).getContent());
                }
                ++n;
            }
            return text.toString();
        }

        private String getAttributeValue(String value) {
            int length;
            if (value != null && (length = value.length()) > 2 && (value.charAt(0) == '\"' || value.charAt(0) == '\'')) {
                value = value.substring(1, length - 1);
            }
            return value;
        }
    }
}

