/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.IOException;
import org.eclipse.birt.core.archive.compound.v3.DataBlock;
import org.eclipse.birt.core.archive.compound.v3.Ext2Entry;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.Ext2Node;
import org.eclipse.birt.core.archive.compound.v3.FatBlockList;

public class Ext2File {
    static final int BLOCK_SIZE = 4096;
    static final int BLOCK_SIZE_BITS = 12;
    static final int BLOCK_OFFSET_MASK = 4095;
    private Ext2FileSystem fs;
    private Ext2Entry entry;
    private Ext2Node node;
    private long position;
    private FatBlockList blocks;
    private boolean enableCache;
    private int cachedBlockId;
    private DataBlock cachedBlock;

    Ext2File(Ext2FileSystem fs, int inode, boolean enableCache) throws IOException {
        this(fs, null, fs.getNode(inode), enableCache);
    }

    Ext2File(Ext2FileSystem fs, Ext2Entry entry, Ext2Node node) throws IOException {
        this(fs, entry, node, true);
    }

    Ext2File(Ext2FileSystem fs, Ext2Entry entry, Ext2Node node, boolean enableCache) throws IOException {
        this.fs = fs;
        this.entry = entry;
        this.node = node;
        this.blocks = new FatBlockList(fs, node);
        this.fs.registerOpenedFile(this);
        this.enableCache = enableCache;
        this.cachedBlockId = -1;
        this.cachedBlock = DataBlock.READ_ONLY_BLOCK;
    }

    public Ext2Entry getEntry() {
        return this.entry;
    }

    public String getName() {
        if (this.entry != null) {
            return this.entry.getName();
        }
        return null;
    }

    public void close() throws IOException {
        if (this.fs == null) {
            return;
        }
        try {
            if (this.cachedBlock != DataBlock.READ_ONLY_BLOCK) {
                this.fs.unloadBlock(this.cachedBlock);
            }
            this.cachedBlockId = -1;
            this.cachedBlock = DataBlock.READ_ONLY_BLOCK;
            this.blocks.clear();
        }
        finally {
            this.fs.unregisterOpenedFile(this);
            this.fs = null;
        }
    }

    public long length() throws IOException {
        return this.node.getLength();
    }

    public void setLength(long length) throws IOException {
        if (this.fs == null) {
            throw new IOException("The archive file has been closed.");
        }
        if (this.fs.isReadOnly()) {
            throw new IOException("the file is opened in read only mode");
        }
        this.node.setLength(length);
        if (this.position >= length) {
            this.position = length;
        }
    }

    public void seek(long position) throws IOException {
        this.position = position;
    }

    public long getPointer() throws IOException {
        return this.position;
    }

    public int read(byte[] buffer, int off, int size) throws IOException {
        if (this.fs == null) {
            throw new IOException("The archive file has been closed.");
        }
        assert (buffer != null);
        assert (off >= 0);
        assert (off + size <= buffer.length);
        if (size == 0) {
            return 0;
        }
        if (this.enableCache) {
            return this.read_with_cache(buffer, off, size);
        }
        return this.read_without_cache(buffer, off, size);
    }

    private int read_without_cache(byte[] buffer, int off, int size) throws IOException {
        long length = this.node.getLength();
        if (this.position + (long)size > length && (size = (int)(length - this.position)) <= 0) {
            return -1;
        }
        int blockId = (int)(this.position >> 12);
        int blockOff = (int)(this.position & 0xFFFL);
        int blockSize = 4096 - blockOff;
        int fileBlockId = this.getDataBlock(blockId);
        if (size <= blockSize) {
            this.fs.readBlock(fileBlockId, blockOff, buffer, off, size);
        } else {
            this.fs.readBlock(fileBlockId, blockOff, buffer, off, blockSize);
            off += blockSize;
            int remainSize = size - blockSize;
            int wholeBlocks = remainSize >> 12;
            int i = 0;
            while (i < wholeBlocks) {
                if ((fileBlockId = this.getDataBlock(++blockId)) != -1) {
                    this.fs.readBlock(fileBlockId, 0, buffer, off, 4096);
                }
                off += 4096;
                ++i;
            }
            if ((remainSize &= 0xFFF) > 0 && (fileBlockId = this.getDataBlock(++blockId)) != -1) {
                this.fs.readBlock(fileBlockId, 0, buffer, off, remainSize);
            }
        }
        this.position += (long)size;
        return size;
    }

    private int read_with_cache(byte[] buffer, int off, int size) throws IOException {
        long length = this.node.getLength();
        if (this.position + (long)size > length && (size = (int)(length - this.position)) <= 0) {
            return -1;
        }
        int blockId = (int)(this.position >> 12);
        int blockOff = (int)(this.position & 0xFFFL);
        int blockSize = 4096 - blockOff;
        DataBlock block = this.loadDataBlock(blockId);
        if (size <= blockSize) {
            block.read(blockOff, buffer, off, size);
        } else {
            block.read(blockOff, buffer, off, blockSize);
            off += blockSize;
            int remainSize = size - blockSize;
            int wholeBlocks = remainSize >> 12;
            int i = 0;
            while (i < wholeBlocks) {
                block = this.loadDataBlock(++blockId);
                block.read(0, buffer, off, 4096);
                off += 4096;
                ++i;
            }
            if ((remainSize &= 0xFFF) > 0) {
                block = this.loadDataBlock(++blockId);
                block.read(0, buffer, off, remainSize);
            }
        }
        this.position += (long)size;
        return size;
    }

    public void write(byte[] buffer, int off, int size) throws IOException {
        if (this.fs == null) {
            throw new IOException("The archive file has been closed.");
        }
        if (this.fs.isReadOnly()) {
            throw new IOException("the file is opened in read only mode");
        }
        assert (buffer != null);
        assert (off >= 0);
        assert (off + size <= buffer.length);
        if (size == 0) {
            return;
        }
        if (this.enableCache) {
            this.write_with_cache(buffer, off, size);
        } else {
            this.write_without_cache(buffer, off, size);
        }
    }

    private void write_without_cache(byte[] buffer, int off, int size) throws IOException {
        int blockId = (int)(this.position >> 12);
        int blockOff = (int)(this.position & 0xFFFL);
        int blockSize = 4096 - blockOff;
        int fileBlockId = this.getDataBlock(blockId);
        if (size <= blockSize) {
            this.fs.writeBlock(fileBlockId, blockOff, buffer, off, size);
        } else {
            this.fs.writeBlock(fileBlockId, blockOff, buffer, off, blockSize);
            off += blockSize;
            int remainSize = size - blockSize;
            int wholeBlocks = remainSize >> 12;
            int i = 0;
            while (i < wholeBlocks) {
                fileBlockId = this.getDataBlock(++blockId);
                this.fs.writeBlock(fileBlockId, 0, buffer, off, 4096);
                off += 4096;
                ++i;
            }
            if ((remainSize &= 0xFFF) > 0) {
                fileBlockId = this.getDataBlock(++blockId);
                this.fs.writeBlock(fileBlockId, 0, buffer, off, remainSize);
            }
        }
        this.position += (long)size;
        if (this.position > this.node.getLength()) {
            this.node.setLength(this.position);
        }
    }

    private void write_with_cache(byte[] buffer, int off, int size) throws IOException {
        int blockId = (int)(this.position >> 12);
        int blockOff = (int)(this.position & 0xFFFL);
        int blockSize = 4096 - blockOff;
        DataBlock block = this.loadDataBlock(blockId);
        if (size <= blockSize) {
            block.write(blockOff, buffer, off, size);
        } else {
            block.write(blockOff, buffer, off, blockSize);
            off += blockSize;
            int remainSize = size - blockSize;
            int wholeBlocks = remainSize >> 12;
            int i = 0;
            while (i < wholeBlocks) {
                block = this.loadDataBlock(++blockId);
                block.write(0, buffer, off, 4096);
                off += 4096;
                ++i;
            }
            if ((remainSize &= 0xFFF) > 0) {
                block = this.loadDataBlock(++blockId);
                block.write(0, buffer, off, remainSize);
            }
        }
        this.position += (long)size;
        if (this.position > this.node.getLength()) {
            this.node.setLength(this.position);
        }
    }

    private DataBlock loadDataBlock(int blockId) throws IOException {
        if (this.cachedBlockId == blockId) {
            return this.cachedBlock;
        }
        if (this.cachedBlock != DataBlock.READ_ONLY_BLOCK) {
            this.fs.unloadBlock(this.cachedBlock);
        }
        this.cachedBlockId = blockId;
        int fileBlockId = this.blocks.getFileBlock(blockId);
        if (fileBlockId != -1) {
            this.cachedBlock = this.fs.loadDataBlock(fileBlockId);
            return this.cachedBlock;
        }
        if (this.fs.isReadOnly()) {
            this.cachedBlock = DataBlock.READ_ONLY_BLOCK;
            return this.cachedBlock;
        }
        this.cachedBlock = this.fs.createDataBlock();
        this.node.setBlockCount(this.node.getBlockCount() + 1);
        this.blocks.setFileBlock(blockId, this.cachedBlock.getBlockId());
        return this.cachedBlock;
    }

    private int getDataBlock(int blockId) throws IOException {
        int fileBlockId = this.blocks.getFileBlock(blockId);
        if (fileBlockId != -1) {
            return fileBlockId;
        }
        if (this.fs.isReadOnly()) {
            return -1;
        }
        fileBlockId = this.fs.allocFreeBlock();
        this.node.setBlockCount(this.node.getBlockCount() + 1);
        this.blocks.setFileBlock(blockId, fileBlockId);
        return fileBlockId;
    }
}

