/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.metamodel;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.wst.css.core.internal.metamodel.CSSProfile;
import org.eclipse.wst.css.core.internal.metamodelimpl.RegistryReader;

public class CSSProfileRegistry {
    private static CSSProfileRegistry fInstance = null;
    private Map fProfiles = new HashMap();

    public static synchronized CSSProfileRegistry getInstance() {
        if (fInstance == null) {
            fInstance = new CSSProfileRegistry();
        }
        return fInstance;
    }

    public Iterator getProfiles() {
        ArrayList values = new ArrayList(this.fProfiles.values());
        Collections.sort(values, new ProfileNameComparator());
        return Collections.unmodifiableCollection(values).iterator();
    }

    public CSSProfile getProfile(String profileID) {
        return (CSSProfile)this.fProfiles.get(profileID);
    }

    public CSSProfile getDefaultProfile() {
        Iterator i = this.getProfiles();
        while (i.hasNext()) {
            CSSProfile profile = (CSSProfile)i.next();
            if (!profile.isDefault()) continue;
            return profile;
        }
        return null;
    }

    private CSSProfileRegistry() {
        Iterator i = new RegistryReader().enumProfiles();
        while (i.hasNext()) {
            Object profile = i.next();
            if (!(profile instanceof CSSProfile)) continue;
            this.fProfiles.put(((CSSProfile)profile).getProfileID(), profile);
        }
    }

    static class ProfileNameComparator
    implements Comparator {
        static Collator delegate = Collator.getInstance();

        ProfileNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CSSProfile && o2 instanceof CSSProfile && ((CSSProfile)o1).getProfileName() != null && ((CSSProfile)o2).getProfileName() != null) {
                return delegate.compare(((CSSProfile)o1).getProfileName(), ((CSSProfile)o2).getProfileName());
            }
            return 0;
        }
    }
}

