/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.parameter;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.report.context.ScalarParameterBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.parameter.ScalarParameterFragment;
import org.eclipse.birt.report.service.api.IViewerReportDesignHandle;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.utility.ParameterUtility;

public class ComboBoxParameterFragment
extends ScalarParameterFragment {
    public ComboBoxParameterFragment(ParameterDefinition parameter) {
        super(parameter);
    }

    protected void prepareParameterBean(HttpServletRequest request, IViewerReportService service, ScalarParameterBean parameterBean, Locale locale, TimeZone timeZone) throws ReportServiceException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        Collection selectionList = null;
        ParameterDefinition paramDef = parameterBean.getParameter();
        if (paramDef.getGroup() != null && paramDef.getGroup().cascade()) {
            HashMap paramValues = attrBean.getParameters();
            selectionList = this.getParameterSelectionListForCascadingGroup(attrBean.getReportDesignHandle(request), service, paramValues, options);
            parameterBean.setCascade(true);
        } else {
            selectionList = service.getParameterSelectionList(attrBean.getReportDesignHandle(request), options, this.parameter.getName());
            parameterBean.setCascade(false);
        }
        ParameterUtility.makeSelectionList(selectionList, parameterBean, locale, timeZone, true);
    }

    private Collection getParameterSelectionListForCascadingGroup(IViewerReportDesignHandle design, IViewerReportService service, Map paramValues, InputOptions options) throws ReportServiceException {
        ParameterGroupDefinition group = this.parameter.getGroup();
        int index = group.getParameters().indexOf(this.parameter);
        Object[] groupKeys = new Object[index];
        for (int i = 0; i < index; ++i) {
            ParameterDefinition def = (ParameterDefinition)group.getParameters().get(i);
            groupKeys[i] = paramValues.get(def.getName());
        }
        return service.getSelectionListForCascadingGroup(design, group.getName(), groupKeys, options);
    }
}

