/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.test;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.JavaMofReflectionCommand;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.selection.BooleanSelection;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class WebServiceClientTestArrivalCommand
extends AbstractDataModelOperation {
    public static final String DEFAULT_WEB_MODULE_ROOT = "WebContent";
    public static final String DEFAULT_SAMPLE_WEB_PROJECT_EXT = "Sample";
    public static String SAMPLE_DIR = "sample";
    private String clientProject;
    private String clientProjectEAR;
    private String clientP;
    private String clientC;
    private IProject clientIProject;
    private String folder;
    private String jspFolder;
    private BooleanSelection[] methods;
    private String proxyBean;
    private String sampleProject;
    private String sampleP;
    private String sampleC;
    private String sampleProjectEAR;
    public static final String DEFAULT_SAMPLE_EAR_PROJECT_EXT = "EAR";

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        if (this.proxyBean == null) {
            IStatusHandler sHandler = env.getStatusHandler();
            IStatus errorStatus = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_JTS_PROXY_NOT_COMPILED);
            sHandler.reportError(errorStatus);
            return errorStatus;
        }
        IStatus status = Status.OK_STATUS;
        this.sampleProjectAndEarSetup(env);
        IPath webcontentPath = null;
        if (J2EEUtils.isWebComponent((IProject)this.clientIProject)) {
            webcontentPath = J2EEUtils.getWebContentPath((IProject)this.clientIProject);
        }
        StringBuffer sb = new StringBuffer();
        if (webcontentPath != null) {
            String path = webcontentPath.toString();
            sb.append(path).append("/");
        } else {
            sb.append("/").append(this.sampleC).append("/").append(DEFAULT_WEB_MODULE_ROOT).append("/");
        }
        this.folder = String.valueOf(SAMPLE_DIR) + this.getBean();
        sb.append(this.folder);
        this.jspFolder = sb.toString();
        JavaMofReflectionCommand javamofcommand = new JavaMofReflectionCommand();
        javamofcommand.setProxyBean(this.proxyBean);
        javamofcommand.setClientProject(this.clientP);
        javamofcommand.setEnvironment(env);
        try {
            IStatus mofStatus = javamofcommand.execute(monitor, null);
            if (mofStatus.getSeverity() == 4) {
                return mofStatus;
            }
        }
        catch (Exception exception) {
            IStatusHandler sHandler = env.getStatusHandler();
            IStatus errorStatus = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_JTS_PROXY_NOT_COMPILED);
            sHandler.reportError(errorStatus);
            return errorStatus;
        }
        JavaHelpers javaHelpers = javamofcommand.getJavaClass();
        if (javaHelpers == null) {
            return status;
        }
        JavaClass javaClass = null;
        if (!(javaHelpers instanceof JavaClass)) {
            return status;
        }
        javaClass = (JavaClass)javaHelpers;
        List methodList = javaClass.getPublicMethods();
        BooleanSelection[] tempMethods = new BooleanSelection[methodList.size()];
        ListIterator listIterator = methodList.listIterator();
        int j = 0;
        while (listIterator.hasNext()) {
            Method method = (Method)listIterator.next();
            if (method.isConstructor()) continue;
            tempMethods[j] = new BooleanSelection(method.getMethodElementSignature(), true);
            ++j;
        }
        this.methods = tempMethods;
        return status;
    }

    private void sampleProjectAndEarSetup(IEnvironment env) {
        if (this.clientProject == null) {
            return;
        }
        int index = this.clientProject.indexOf("/");
        this.clientP = this.clientProject.substring(0, index);
        this.clientC = this.clientProject.substring(index + 1);
        this.clientIProject = ProjectUtilities.getProject((String)this.clientP);
        if (J2EEUtils.isWebComponent((IProject)this.clientIProject)) {
            this.sampleProject = this.clientProject;
            this.sampleP = this.clientP;
            this.sampleC = this.clientC;
        } else {
            this.sampleP = String.valueOf(this.clientP) + DEFAULT_SAMPLE_WEB_PROJECT_EXT;
            this.sampleC = String.valueOf(this.clientC) + DEFAULT_SAMPLE_WEB_PROJECT_EXT;
            this.sampleProject = String.valueOf(this.sampleP) + "/" + this.sampleC;
            String sampleTemp = this.sampleP;
            boolean nameFound = false;
            int i = 1;
            while (!nameFound) {
                IProject sampleIProject = ProjectUtilities.getProject((String)sampleTemp);
                if (sampleIProject.exists() && !J2EEProjectUtilities.isDynamicWebProject((IProject)sampleIProject)) {
                    sampleTemp = String.valueOf(this.sampleP) + Integer.toString(i);
                    this.sampleProject = String.valueOf(sampleTemp) + "/" + this.sampleC;
                } else {
                    nameFound = true;
                }
                ++i;
            }
            this.sampleP = sampleTemp;
        }
        this.sampleProjectEAR = this.clientProjectEAR;
        if (this.sampleProjectEAR == null || this.sampleProjectEAR.length() == 0) {
            this.sampleProjectEAR = String.valueOf(this.sampleP) + DEFAULT_SAMPLE_EAR_PROJECT_EXT + "/" + this.sampleC + DEFAULT_SAMPLE_EAR_PROJECT_EXT;
        }
    }

    private String getBean() {
        int index = this.proxyBean.lastIndexOf(".");
        String end = "";
        if (index != -1) {
            end = this.proxyBean.substring(index + 1);
        }
        String bean = end.substring(0, end.length());
        return bean;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getJspFolder() {
        return this.jspFolder;
    }

    public BooleanSelection[] getMethods() {
        return this.methods;
    }

    public String getSampleProject() {
        return this.sampleProject;
    }

    public void setClientProject(String clientProject) {
        this.clientProject = clientProject;
    }

    public void setClientProjectEAR(String clientProjectEAR) {
        this.clientProjectEAR = clientProjectEAR;
    }

    public void setProxyBean(String proxyBean) {
        this.proxyBean = proxyBean;
    }

    public String getSampleProjectEAR() {
        return this.sampleProjectEAR;
    }
}

