/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.db;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.enablement.jdt.classpath.DriverClasspathContainer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jpt.db.ConnectionProfileFactory;
import org.eclipse.jpt.db.internal.DTPConnectionProfileFactory;
import org.osgi.framework.BundleContext;

public class JptDbPlugin
extends Plugin {
    private DTPConnectionProfileFactory connectionProfileFactory;
    private static JptDbPlugin INSTANCE;

    public static JptDbPlugin instance() {
        return INSTANCE;
    }

    public JptDbPlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.connectionProfileFactory = DTPConnectionProfileFactory.instance();
        this.connectionProfileFactory.start();
    }

    public void stop(BundleContext context) throws Exception {
        this.connectionProfileFactory.stop();
        this.connectionProfileFactory = null;
        INSTANCE = null;
        super.stop(context);
    }

    public ConnectionProfileFactory getConnectionProfileFactory() {
        return this.connectionProfileFactory;
    }

    public IClasspathContainer buildDriverClasspathContainerFor(String driverName) {
        return new DriverClasspathContainer(driverName);
    }
}

