/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.preview;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ImageViewer
extends Canvas {
    protected Point origin = new Point(0, 0);
    protected Image image;
    protected ImageData[] imageDatas;
    protected Image[] images;
    protected int current;
    private int repeatCount;
    private Runnable animationTimer;
    private Color bg = this.getBackground();
    private Display display = this.getDisplay();

    public ImageViewer(Composite parent, int style) {
        super(parent, style);
        this.addListeners();
    }

    public void setImage(ImageData imageData) {
        this.checkWidget();
        this.stopAnimationTimer();
        this.image = new Image((Device)this.display, imageData);
        this.imageDatas = null;
        this.images = null;
        this.redraw();
    }

    public void setImages(ImageData[] imageDatas, int repeatCount) {
        this.checkWidget();
        this.image = null;
        this.imageDatas = imageDatas;
        this.repeatCount = repeatCount;
        this.convertImageDatasToImages();
        this.startAnimationTimer();
        this.redraw();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Image image = this.getCurrentImage();
        if (image != null) {
            Rectangle rect = image.getBounds();
            Rectangle trim = this.computeTrim(0, 0, rect.width, rect.height);
            return new Point(trim.width, trim.height);
        }
        return new Point(wHint, hHint);
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                this.images[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    protected void paint(Event e) {
        int marginHeight;
        Image image = this.getCurrentImage();
        if (image == null) {
            return;
        }
        GC gc = e.gc;
        gc.drawImage(image, this.origin.x, this.origin.y);
        gc.setBackground(this.bg);
        Rectangle rect = image.getBounds();
        Rectangle client = this.getClientArea();
        int marginWidth = client.width - rect.width;
        if (marginWidth > 0) {
            gc.fillRectangle(rect.width, 0, marginWidth, client.height);
        }
        if ((marginHeight = client.height - rect.height) > 0) {
            gc.fillRectangle(0, rect.height, client.width, marginHeight);
        }
    }

    void addListeners() {
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                ImageViewer.this.resize();
            }
        });
        this.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                ImageViewer.this.paint(e);
            }
        });
    }

    void resize() {
        Image image = this.getCurrentImage();
        if (image == null) {
            return;
        }
        Rectangle rect = image.getBounds();
        Rectangle client = this.getClientArea();
        int cfr_ignored_0 = rect.width;
        int cfr_ignored_1 = client.width;
        int cfr_ignored_2 = rect.height;
        int cfr_ignored_3 = client.height;
        this.redraw();
    }

    void convertImageDatasToImages() {
        this.images = new Image[this.imageDatas.length];
        int width = this.imageDatas[0].width;
        int height = this.imageDatas[0].height;
        int transition = 2;
        int i = 0;
        while (i < this.imageDatas.length) {
            ImageData id = this.imageDatas[i];
            this.images[i] = new Image((Device)this.display, width, height);
            GC gc = new GC((Drawable)this.images[i]);
            switch (transition) {
                case 0: 
                case 1: {
                    gc.drawImage(this.images[i - 1], 0, 0);
                    break;
                }
                case 3: {
                    gc.drawImage(this.images[i - 2], 0, 0);
                    break;
                }
                default: {
                    gc.setBackground(this.bg);
                    gc.fillRectangle(0, 0, width, height);
                }
            }
            Image img = new Image((Device)this.display, id);
            gc.drawImage(img, 0, 0, id.width, id.height, id.x, id.y, id.width, id.height);
            img.dispose();
            gc.dispose();
            transition = id.disposalMethod;
            if (i == 0 && transition == 3) {
                transition = 1;
            }
            ++i;
        }
    }

    Image getCurrentImage() {
        if (this.image != null) {
            return this.image;
        }
        if (this.images == null) {
            return null;
        }
        return this.images[this.current];
    }

    void startAnimationTimer() {
        if (this.images == null || this.images.length < 2) {
            return;
        }
        final int delay = this.imageDatas[this.current].delayTime * 10;
        this.animationTimer = new Runnable(){

            public void run() {
                if (ImageViewer.this.isDisposed()) {
                    return;
                }
                ImageViewer.this.current = (ImageViewer.this.current + 1) % ImageViewer.this.images.length;
                ImageViewer.this.redraw();
                if (ImageViewer.this.current + 1 == ImageViewer.this.images.length && ImageViewer.this.repeatCount != 0) {
                    ImageViewer imageViewer = ImageViewer.this;
                    int n = imageViewer.repeatCount - 1;
                    imageViewer.repeatCount = n;
                    if (n <= 0) {
                        return;
                    }
                }
                ImageViewer.this.display.timerExec(delay, (Runnable)this);
            }
        };
        this.display.timerExec(delay, this.animationTimer);
    }

    void stopAnimationTimer() {
        if (this.animationTimer != null) {
            this.display.timerExec(-1, this.animationTimer);
        }
    }
}

