/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.actions;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.actions.ActionMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportDialog
extends Dialog {
    static final String SETTINGS_SECTION = "org.eclipse.pde.api.tools.ui.api.exportsession";
    static final String REPORT_PATH_STATE = "org.eclipse.pde.api.tools.ui.api.exportsession.reportpath";
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private Text text;
    private Text errorMessageText;
    private String errorMessage;

    public ExportDialog(Shell shell, String title) {
        this(shell, title, ActionMessages.ExportDialogDescription, "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText != null && newText.length() > 0) {
                    if (!newText.endsWith(".html") & !newText.endsWith(".xml")) {
                        return ActionMessages.ExportDialogErrorMessage;
                    }
                    return null;
                }
                return ActionMessages.ExportDialogErrorMessage;
            }
        });
    }

    public ExportDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
        this.initialize();
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        if (this.message != null) {
            Label label = new Label(comp, 64);
            label.setText(this.message);
            data = new GridData(1796);
            data.horizontalSpan = 2;
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.text = new Text(comp, this.getInputTextStyle());
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDialog.this.validateInput();
            }
        });
        Button browseButton = SWTFactory.createPushButton(comp, ActionMessages.Browse, null, 131072);
        data = new GridData(16384, 0x1000000, false, false);
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file;
                FileDialog dialog = new FileDialog(ExportDialog.this.getShell());
                dialog.setText(ActionMessages.SelectFileName);
                String loctext = ExportDialog.this.getValue().trim();
                if (loctext.length() > 0 && (file = new File(loctext).getParentFile()) != null && file.exists()) {
                    dialog.setFilterPath(file.getAbsolutePath());
                }
                String newPath = dialog.open();
                ExportDialog.this.getText().setText(newPath);
            }
        });
        this.errorMessageText = new Text(comp, 72);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.errorMessageText.setLayoutData((Object)layoutData);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        ExportDialog.applyDialogFont((Control)comp);
        this.initialize();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_COMPARE_EXPORT_DIALOG);
        return parent;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Text getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }

    protected void okPressed() {
        this.saveWidgetState();
        super.okPressed();
    }

    private void restoreTextSelection(String id, IDialogSettings settings) {
        String restoredValue = settings.get(id);
        if (restoredValue != null) {
            this.getText().setText(restoredValue);
        }
    }

    void saveWidgetState() {
        IDialogSettings rootsettings = ApiUIPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = rootsettings.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = rootsettings.addNewSection(SETTINGS_SECTION);
        }
        settings.put(REPORT_PATH_STATE, this.getValue());
    }

    void initialize() {
        IDialogSettings settings = ApiUIPlugin.getDefault().getDialogSettings().getSection(SETTINGS_SECTION);
        if (settings != null) {
            this.restoreTextSelection(REPORT_PATH_STATE, settings);
        }
    }
}

