/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.IProjectChangeListener;
import org.eclipse.wst.validation.internal.Misc;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class EventManager
implements IResourceChangeListener {
    private static EventManager _inst;
    private boolean _shutdown;
    private IResourceDeltaVisitor _postAutoBuildVisitor;
    private boolean _isActive;
    private Set<IProjectChangeListener> _listeners = new CopyOnWriteArraySet<IProjectChangeListener>();

    private EventManager() {
    }

    public static EventManager getManager() {
        if (_inst == null) {
            _inst = new EventManager();
        }
        return _inst;
    }

    public void addProjectChangeListener(IProjectChangeListener listener) {
        Tracing.log("EventManager-03: add listener: ", listener);
        this._listeners.add(listener);
    }

    public void removeProjectChangeListener(IProjectChangeListener listener) {
        this._listeners.remove(listener);
    }

    private void signal(IProject project, int type) {
        if (Tracing.isLogging()) {
            String name = "Null";
            if (project != null) {
                name = project.getName();
            }
            Tracing.log("EventManager-02: signal project: " + name + ", IProjectChangeListener type: " + type);
        }
        for (IProjectChangeListener pcl : this._listeners) {
            try {
                pcl.projectChanged(project, type);
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
    }

    public void opening(IProject project) {
        if (project == null || !ValidationPlugin.isActivated()) {
            return;
        }
        this.signal(project, 1);
    }

    public void closing(IProject project) {
        block8: {
            if (project == null || !ValidationPlugin.isActivated()) {
                return;
            }
            this.signal(project, 2);
            try {
                ValidatorMetaData[] vmds;
                boolean isMigrated = ConfigurationManager.getManager().isMigrated(project);
                if (!isMigrated) break block8;
                ValidatorMetaData[] validatorMetaDataArray = vmds = ConfigurationManager.getManager().getProjectConfiguration(project).getValidators();
                int n = vmds.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMetaData vmd = validatorMetaDataArray[n2];
                    if (vmd.isActive()) {
                        IWorkbenchContext helper = null;
                        try {
                            helper = vmd.getHelper(project);
                            helper.closing();
                        }
                        catch (InstantiationException e) {
                            ValidationRegistryReader.getReader().disableValidator(vmd);
                            ValidationPlugin.getPlugin().handleException(e);
                        }
                        catch (Exception e) {
                            ValidationPlugin.getPlugin().handleException(e);
                        }
                    }
                    ++n2;
                }
                ConfigurationManager.getManager().closing(project);
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
                if (e.getTargetException() == null) break block8;
                ValidationPlugin.getPlugin().handleException(e.getTargetException());
            }
        }
    }

    public void deleting(IProject project) {
        block8: {
            if (project == null) {
                return;
            }
            this.signal(project, 4);
            try {
                ValidatorMetaData[] vmds;
                boolean isMigrated = ConfigurationManager.getManager().isMigrated(project);
                if (!isMigrated) break block8;
                ValidatorMetaData[] validatorMetaDataArray = vmds = ConfigurationManager.getManager().getProjectConfiguration(project).getValidators();
                int n = vmds.length;
                int n2 = 0;
                while (n2 < n) {
                    ValidatorMetaData vmd = validatorMetaDataArray[n2];
                    if (vmd.isActive()) {
                        IWorkbenchContext helper = null;
                        try {
                            helper = vmd.getHelper(project);
                            helper.deleting();
                        }
                        catch (InstantiationException e) {
                            ValidationRegistryReader.getReader().disableValidator(vmd);
                            ValidationPlugin.getPlugin().handleException(e);
                        }
                        catch (Exception e) {
                            ValidationPlugin.getPlugin().handleException(e);
                        }
                    }
                    ++n2;
                }
            }
            catch (InvocationTargetException e) {
                ValidationPlugin.getPlugin().handleException(e);
                if (e.getTargetException() == null) break block8;
                ValidationPlugin.getPlugin().handleException(e.getTargetException());
            }
        }
    }

    private void postAutoChange(IResourceDelta delta) {
        if (this._postAutoBuildVisitor == null) {
            this._postAutoBuildVisitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta subdelta) throws CoreException {
                    if (subdelta == null) {
                        return false;
                    }
                    IResource resource = subdelta.getResource();
                    if (resource instanceof IWorkspaceRoot) {
                        return true;
                    }
                    if (resource instanceof IProject) {
                        IProject project = (IProject)resource;
                        if ((subdelta.getFlags() & 0x80000) == 524288) {
                            EventManager.this.signal(project, 8);
                            return false;
                        }
                        if ((subdelta.getFlags() & 0x4000) == 16384) {
                            if (project.isOpen()) {
                                EventManager.this.opening(project);
                            }
                            return false;
                        }
                        if ((subdelta.getFlags() & 1) == 1) {
                            EventManager.this.signal(project, 16);
                            return false;
                        }
                    }
                    return false;
                }
            };
        }
        try {
            delta.accept(this._postAutoBuildVisitor, true);
        }
        catch (CoreException exc) {
            ValidationPlugin.getPlugin().handleException(exc);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this._shutdown && !this.isActive()) {
            return;
        }
        if (Tracing.isLogging()) {
            Tracing.log("Eventmanager-01: IResourceChangeEvent type=" + Misc.resourceChangeEventType(event.getType()) + ", resource=" + event.getResource() + ", source=" + event.getSource() + ", delta=" + event.getDelta());
        }
        if (event.getSource() instanceof IWorkspace) {
            boolean isProject = event.getResource() instanceof IProject;
            if (event.getType() == 4 && isProject) {
                this.deleting((IProject)event.getResource());
            } else if (event.getType() == 2 && isProject) {
                this.closing((IProject)event.getResource());
            } else if (event.getType() == 16) {
                this.postAutoChange(event.getDelta());
            }
        }
    }

    public void shutdown() {
        try {
            this._shutdown = true;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot workspaceRoot = workspace.getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            ProjectConfiguration prjp = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                block10: {
                    IProject project = iProjectArray[n2];
                    if (project.isOpen()) {
                        try {
                            ValidatorMetaData[] vmdList;
                            boolean isMigrated = ConfigurationManager.getManager().isMigrated(project);
                            if (!isMigrated || (vmdList = (prjp = ConfigurationManager.getManager().getProjectConfiguration(project)).getEnabledValidators()) == null) break block10;
                            int j = 0;
                            while (j < vmdList.length) {
                                IWorkbenchContext helper;
                                ValidatorMetaData vmd = vmdList[j];
                                if (vmd.isActive() && (helper = vmd.getHelper(project)) != null) {
                                    try {
                                        helper.shutdown();
                                    }
                                    catch (Exception exception) {}
                                }
                                ++j;
                            }
                        }
                        catch (InvocationTargetException e) {
                            ValidationPlugin.getPlugin().handleException(e);
                            if (e.getTargetException() == null) break block10;
                            ValidationPlugin.getPlugin().handleException(e.getTargetException());
                        }
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public boolean isActive() {
        return this._isActive;
    }

    public void setActive(boolean b) {
        this._isActive = b;
    }

    public static boolean isHeadless() {
        return false;
    }
}

