/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.factory;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.util.Date;
import org.eclipse.birt.chart.internal.factory.IDateFormatWrapper;

public class DateFormatWrapperFactory {
    private DateFormatWrapperFactory() {
    }

    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit) {
        return DateFormatWrapperFactory.getPreferredDateFormat(iUnit, ULocale.getDefault());
    }

    public static final IDateFormatWrapper getPreferredDateFormat(int iUnit, ULocale locale) {
        IDateFormatWrapper df = null;
        switch (iUnit) {
            case 1: {
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat("yyyy", locale));
                break;
            }
            case 2: 
            case 6: {
                df = new MonthDateFormat(locale);
                break;
            }
            case 3: 
            case 5: {
                df = new CommonDateFormatWrapper(DateFormat.getDateInstance((int)1, (ULocale)locale));
                break;
            }
            case 11: {
                df = new HourDateFormat(locale);
                break;
            }
            case 12: 
            case 13: {
                df = new CommonDateFormatWrapper((DateFormat)new SimpleDateFormat("HH:mm:ss", locale));
            }
        }
        return df;
    }

    static class CommonDateFormatWrapper
    implements IDateFormatWrapper {
        private DateFormat formater;

        public CommonDateFormatWrapper(DateFormat formater) {
            this.formater = formater;
        }

        public String format(Date date) {
            return this.formater.format(date);
        }
    }

    static class HourDateFormat
    implements IDateFormatWrapper {
        private ULocale locale;

        public HourDateFormat(ULocale locale) {
            this.locale = locale;
        }

        public String format(Date date) {
            return String.valueOf(DateFormat.getDateInstance((int)1, (ULocale)this.locale).format(date)) + "\n" + new SimpleDateFormat("HH:mm", this.locale).format(date);
        }
    }

    static class MonthDateFormat
    implements IDateFormatWrapper {
        private ULocale locale;

        public MonthDateFormat(ULocale locale) {
            this.locale = locale;
        }

        public String format(Date date) {
            StringBuffer str = new StringBuffer();
            FieldPosition pos = new FieldPosition(3);
            DateFormat df = DateFormat.getDateInstance((int)1, (ULocale)this.locale);
            df.format(date, str, pos);
            int endIndex = pos.getEndIndex() >= str.length() ? pos.getEndIndex() : pos.getEndIndex() + (str.charAt(pos.getEndIndex()) == ',' ? 2 : 1);
            if (endIndex >= str.length()) {
                return str.substring(0, pos.getBeginIndex()).trim();
            }
            return String.valueOf(str.substring(0, pos.getBeginIndex())) + str.substring(endIndex);
        }
    }
}

