/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.Engine3D;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.computation.Rectangle;
import org.eclipse.birt.chart.computation.UserDataSetHints;
import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxisLabelTextProvider;
import org.eclipse.birt.chart.computation.withaxes.AxisTickCoordinates;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.SeriesRenderingHints3D;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.Text3DRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.DataPoint;
import org.eclipse.birt.chart.model.attribute.DataPointComponent;
import org.eclipse.birt.chart.model.attribute.DataPointComponentType;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.NumberUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public class PlotWith3DAxes
extends PlotWithAxes {
    private final double SPACE_THRESHOLD = 5.0 * this.dPointToPixel;
    private Engine3D engine;
    private Bounds cachedAdjustedBounds;
    protected double dZAxisPlotSpacing = 0.0;

    public PlotWith3DAxes(IDisplayServer _ids, ChartWithAxes _cwa, RunTimeContext _rtc) throws IllegalArgumentException, ChartException {
        super(_ids, _rtc, _cwa);
        if (_cwa.isTransposed()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 15, "exception.no.transposed.3D.chart", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        this.buildAxes();
    }

    private PlotWith3DAxes getPWA3D() {
        return this;
    }

    public Bounds getAdjustedPlotBounds(boolean refresh) throws ChartException {
        if (!refresh && this.cachedAdjustedBounds != null) {
            return this.cachedAdjustedBounds;
        }
        Bounds bo = goFactory.adjusteBounds(this.getPlotBounds(), this.getPlotInsets());
        Label la = goFactory.copyOf(this.aax.getPrimaryBase().getLabel());
        la.getCaption().setValue("X");
        double h = this.cComp.computeHeight(this.ids, la);
        la = goFactory.copyOf(this.aax.getAncillaryBase().getLabel());
        la.getCaption().setValue("X");
        h = Math.max(h, this.cComp.computeHeight(this.ids, la));
        la = goFactory.copyOf(this.aax.getPrimaryOrthogonal().getLabel());
        la.getCaption().setValue("X");
        double w = this.cComp.computeWidth(this.ids, la);
        bo.adjust(goFactory.createInsets(0.0, 0.0, h, w));
        this.cachedAdjustedBounds = bo;
        return bo;
    }

    public final Location getPanningOffset() throws ChartException {
        Bounds bo = this.getAdjustedPlotBounds(false);
        double xOff = bo.getLeft();
        double yOff = bo.getTop();
        return goFactory.createLocation(xOff, yOff);
    }

    public final Engine3D get3DEngine() {
        if (this.engine == null) {
            Vector lightDirection = new Vector(-1.0, 1.0, -1.0, false);
            Bounds bo = goFactory.adjusteBounds(this.getPlotBounds(), this.getPlotInsets());
            double width = bo.getWidth();
            double height = bo.getHeight();
            this.engine = new Engine3D(this.getModel().getRotation(), lightDirection, width, height, 500.0 * this.dPointToPixel, 1500.0 * this.dPointToPixel, 10.0 * this.dPointToPixel, 10000.0 * this.dPointToPixel, 100.0);
        }
        return this.engine;
    }

    /*
     * Unable to fully structure code
     */
    private double detectZoomScale(Engine3D engine, double xdz, double xOff, double yOff, double width, double height) {
        zlen = 1.0 * this.dPointToPixel;
        xlen = xdz * this.dPointToPixel;
        ylen = (xdz + 1.0) * this.dPointToPixel / 2.0;
        vertexList = new ArrayList<Location3D>();
        bbl = PlotWith3DAxes.goFactory.createLocation3D(-xlen / 2.0, -ylen / 2.0, -zlen / 2.0);
        bbr = PlotWith3DAxes.goFactory.createLocation3D(xlen / 2.0, -ylen / 2.0, -zlen / 2.0);
        bfl = PlotWith3DAxes.goFactory.createLocation3D(-xlen / 2.0, -ylen / 2.0, zlen / 2.0);
        bfr = PlotWith3DAxes.goFactory.createLocation3D(xlen / 2.0, -ylen / 2.0, zlen / 2.0);
        tbl = PlotWith3DAxes.goFactory.createLocation3D(-xlen / 2.0, ylen / 2.0, -zlen / 2.0);
        tbr = PlotWith3DAxes.goFactory.createLocation3D(xlen / 2.0, ylen / 2.0, -zlen / 2.0);
        tfl = PlotWith3DAxes.goFactory.createLocation3D(-xlen / 2.0, ylen / 2.0, zlen / 2.0);
        tfr = PlotWith3DAxes.goFactory.createLocation3D(xlen / 2.0, ylen / 2.0, zlen / 2.0);
        vertexList.add(bbl);
        vertexList.add(bbr);
        vertexList.add(bfl);
        vertexList.add(bfr);
        vertexList.add(tbl);
        vertexList.add(tbr);
        vertexList.add(tfl);
        vertexList.add(tfr);
        event = new Text3DRenderEvent(this);
        maxLeft = 1.7976931348623157E308;
        maxRight = -1.7976931348623157E308;
        maxTop = 1.7976931348623157E308;
        maxBottom = -1.7976931348623157E308;
        for (Location3D p3d : vertexList) {
            event.setLocation3D(PlotWith3DAxes.goFactory.createLocation3D(p3d.getX(), p3d.getY(), p3d.getZ()));
            if (engine.processEvent(event, xOff, yOff) == null) continue;
            p2d = event.getLocation();
            x = p2d.getX();
            y = p2d.getY();
            if (x < maxLeft) {
                maxLeft = x;
            }
            if (x > maxRight) {
                maxRight = x;
            }
            if (y < maxTop) {
                maxTop = y;
            }
            if (!(y > maxBottom)) continue;
            maxBottom = y;
        }
        vSpace = maxTop - yOff;
        hSpace = maxLeft - xOff;
        if (yOff + height - maxBottom < maxTop - yOff) {
            vSpace = yOff + height - maxBottom;
        }
        if (xOff + width - maxRight < maxLeft - xOff) {
            hSpace = xOff + width - maxRight;
        }
        minSpace = Math.min(hSpace, vSpace);
        lastMinspace = 0.0;
        fit = hSpace > 0.0 && vSpace > 0.0;
        scale = lastScale = 1.0;
        iterateStarted = false;
        if (fit) ** GOTO lbl107
        return 1.0;
lbl-1000:
        // 1 sources

        {
            if (fit && !iterateStarted) {
                scale = lastScale * 2.0;
            } else {
                if (ChartUtil.mathEqual(scale, lastScale)) break;
                scale = (lastScale + scale) / 2.0;
            }
            maxLeft = 1.7976931348623157E308;
            maxRight = -1.7976931348623157E308;
            maxTop = 1.7976931348623157E308;
            maxBottom = -1.7976931348623157E308;
            forceBreak = false;
            for (Location3D p3d : vertexList) {
                event.setLocation3D(PlotWith3DAxes.goFactory.createLocation3D(p3d.getX() * scale, p3d.getY() * scale, p3d.getZ() * scale));
                if (engine.processEvent(event, xOff, yOff) != null) {
                    p2d = event.getLocation();
                    x = p2d.getX();
                    y = p2d.getY();
                    if (x < maxLeft) {
                        maxLeft = x;
                    }
                    if (x > maxRight) {
                        maxRight = x;
                    }
                    if (y < maxTop) {
                        maxTop = y;
                    }
                    if (!(y > maxBottom)) continue;
                    maxBottom = y;
                    continue;
                }
                fit = false;
                forceBreak = true;
                break;
            }
            if (!forceBreak) {
                vSpace = maxTop - yOff;
                hSpace = maxLeft - xOff;
                if (yOff + height - maxBottom < maxTop - yOff) {
                    vSpace = yOff + height - maxBottom;
                }
                if (xOff + width - maxRight < maxLeft - xOff) {
                    hSpace = xOff + width - maxRight;
                }
                v0 = fit = vSpace > 0.0 && hSpace > 0.0;
            }
            if (fit) {
                lastMinspace = minSpace;
                minSpace = Math.min(hSpace, vSpace);
                nextScale = 2.0 * scale - lastScale;
                lastScale = scale;
                scale = nextScale;
                continue;
            }
            if (iterateStarted) continue;
            iterateStarted = true;
lbl107:
            // 4 sources

            ** while (ChartUtil.mathGT((double)Math.abs((double)(minSpace - lastMinspace)), (double)0.0) && (fit && minSpace > this.SPACE_THRESHOLD || !fit))
        }
lbl108:
        // 2 sources

        return lastScale;
    }

    private double computeAxisZoomFactor(Engine3D engine, double start, double end, Location3D startVertext, Location3D endVertext, double xOff, double yOff) {
        Text3DRenderEvent event = new Text3DRenderEvent(this);
        event.setLocation3D(startVertext);
        if (engine.processEvent(event, xOff, yOff) != null) {
            Location p2d = event.getLocation();
            double x1 = p2d.getX();
            double y1 = p2d.getY();
            event.setLocation3D(endVertext);
            if (engine.processEvent(event, xOff, yOff) != null) {
                p2d = event.getLocation();
                double x2 = p2d.getX();
                double y2 = p2d.getY();
                return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1)) / (end - start);
            }
        }
        return 1.0;
    }

    public void compute(Bounds bo) throws ChartException, IllegalArgumentException {
        this.boPlot = bo = goFactory.scaleBounds(bo, this.dPointToPixel);
        this.boPlotBackground = goFactory.copyOf(bo);
        this.iDimension = PlotWith3DAxes.getDimension(this.cm.getDimension());
        assert (this.iDimension == 2);
        this.dXAxisPlotSpacing = (double)this.cm.getPlot().getHorizontalSpacing() * this.dPointToPixel;
        this.dYAxisPlotSpacing = (double)this.cm.getPlot().getVerticalSpacing() * this.dPointToPixel;
        this.dZAxisPlotSpacing = this.dXAxisPlotSpacing;
        PWA3DComputeContext context = new PWA3DComputeContext();
        this.initAxesDatasets(context);
        Bounds adjustedBounds = this.getAdjustedPlotBounds(true);
        this.computeWithAdjBound(context, adjustedBounds);
        this.readjustBounds(context, adjustedBounds, bo);
        this.computeWithAdjBound(context, adjustedBounds);
    }

    private void initAxesDatasets(PWA3DComputeContext context) throws ChartException {
        Object oaData = null;
        int iPrimaryAxisType = context.iPrimaryAxisType;
        if (iPrimaryAxisType == 16 || context.oaxPrimaryBase.isCategoryScale()) {
            oaData = this.getTypedDataSet(context.axPrimaryBase, iPrimaryAxisType, 0);
        } else if ((iPrimaryAxisType & 1) == 1) {
            oaData = this.getMinMax(context.axPrimaryBase, iPrimaryAxisType);
        } else if ((iPrimaryAxisType & 8) == 8) {
            oaData = this.getMinMax(context.axPrimaryBase, iPrimaryAxisType);
        }
        context.dsiPrimaryBase = oaData instanceof DataSetIterator ? oaData : new DataSetIterator(oaData, iPrimaryAxisType);
        oaData = null;
        int iAncillaryAxisType = context.iAncillaryAxisType;
        if (iAncillaryAxisType == 16 || context.oaxAncillaryBase.isCategoryScale()) {
            oaData = this.getAncillaryDataSet(context.axAncillaryBase, context.axPrimaryOrthogonal, iAncillaryAxisType);
        } else if ((iAncillaryAxisType & 1) == 1) {
            oaData = this.getMinMax(context.axAncillaryBase, iAncillaryAxisType);
        } else if ((iAncillaryAxisType & 8) == 8) {
            oaData = this.getMinMax(context.axAncillaryBase, iAncillaryAxisType);
        }
        context.dsiAncillary = oaData instanceof DataSetIterator ? (DataSetIterator)oaData : new DataSetIterator(oaData, iAncillaryAxisType);
        oaData = null;
        int iOrthogonalAxisType = context.iOrthogonalAxisType;
        if ((iOrthogonalAxisType & 1) != 1 && (iOrthogonalAxisType & 8) != 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 0, "exception.orthogonal.axis.numerical.datetime", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        context.dsiOrthogonal = new DataSetIterator(this.getMinMax(context.axPrimaryOrthogonal, iOrthogonalAxisType), iOrthogonalAxisType);
    }

    private void computeWithAdjBound(PWA3DComputeContext context, Bounds adjustedBounds) throws ChartException {
        double dXDZ = (double)context.dsiPrimaryBase.size() * 1.0 / (double)context.dsiAncillary.size();
        double xOffset = adjustedBounds.getLeft();
        double yOffset = adjustedBounds.getTop();
        double zoomScale = this.detectZoomScale(this.get3DEngine(), dXDZ, xOffset, yOffset, adjustedBounds.getWidth(), adjustedBounds.getHeight());
        double dWZ = zoomScale * this.dPointToPixel;
        double dW = dXDZ * zoomScale * this.dPointToPixel;
        double dH = (dW + dWZ) / 2.0;
        double dX = -dW / 2.0;
        double dY = -dH / 2.0;
        double dZ = -dWZ / 2.0;
        context.dX = dX;
        context.dY = dY;
        context.dZ = dZ;
        Location panningOffset = this.getPanningOffset();
        double xZoom = this.computeAxisZoomFactor(this.get3DEngine(), dX, dX + dW, goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX + dW, dY, dZ), panningOffset.getX(), panningOffset.getY());
        double yZoom = this.computeAxisZoomFactor(this.get3DEngine(), dY, dY + dH, goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX, dY + dH, dZ), panningOffset.getX(), panningOffset.getY());
        double zZoom = this.computeAxisZoomFactor(this.get3DEngine(), dZ, dZ + dWZ, goFactory.createLocation3D(dX, dY, dZ), goFactory.createLocation3D(dX, dY, dZ + dWZ), panningOffset.getX(), panningOffset.getY());
        AutoScale scPrimaryBase = null;
        double dStart = dX;
        double dEnd = dX + dW;
        scPrimaryBase = AutoScale.computeScale(this.ids, context.oaxPrimaryBase, context.dsiPrimaryBase, context.iPrimaryAxisType, dStart, dEnd, this.rtc, 1, xZoom, 0, this);
        context.oaxPrimaryBase.set(scPrimaryBase);
        AutoScale scAncillaryBase = null;
        dStart = dZ;
        dEnd = dZ + dWZ;
        scAncillaryBase = AutoScale.computeScale(this.ids, context.oaxAncillaryBase, context.dsiAncillary, context.iAncillaryAxisType, dStart, dEnd, this.rtc, 1, zZoom, 0, this);
        context.oaxAncillaryBase.set(scAncillaryBase);
        AutoScale scPrimaryOrthogonal = null;
        dStart = dY;
        dEnd = dY + dH;
        scPrimaryOrthogonal = AutoScale.computeScale(this.ids, context.oaxPrimaryOrthogonal, context.dsiOrthogonal, context.iOrthogonalAxisType, dStart, dEnd, this.rtc, 1, yZoom, 0, this);
        context.oaxPrimaryOrthogonal.set(scPrimaryOrthogonal);
        this.setupFullDataSets(context);
        context.oaxPrimaryBase.getScale().resetShifts();
        context.oaxAncillaryBase.getScale().resetShifts();
        context.oaxPrimaryOrthogonal.getScale().resetShifts();
        this.setAxisCoordinatesForAll(context);
    }

    private double computeYAxisTitleThickness() throws ChartException {
        OneAxis axxPV = this.aax.getPrimaryOrthogonal();
        Label laYAxisTitle = axxPV.getTitle();
        double dYAxisTitleThickness = 0.0;
        if (laYAxisTitle.isVisible()) {
            dYAxisTitleThickness = this.cComp.computeLabelSize(this.ids, laYAxisTitle, ChartUtil.computeHeightOfOrthogonalAxisTitle(this.getModel(), this.getDisplayServer()), null).getWidth();
        }
        return dYAxisTitleThickness;
    }

    private double computeXAxisTitleThickness() throws ChartException {
        OneAxis axxPB = this.aax.getPrimaryBase();
        Label laXAxisTitle = axxPB.getTitle();
        double dXAxisTitleThickness = 0.0;
        if (laXAxisTitle.isVisible()) {
            dXAxisTitleThickness = this.cComp.computeLabelSize(this.ids, laXAxisTitle, ChartUtil.computeHeightOfOrthogonalAxisTitle(this.getModel(), this.getDisplayServer()), null).getHeight();
        }
        return dXAxisTitleThickness;
    }

    private void readjustBounds(PWA3DComputeContext context, Bounds adjustedBounds, Bounds bo) throws ChartException {
        Rectangle rectl = this.getBoundsOfAllAxisLabels();
        if (rectl == null) {
            return;
        }
        rectl.union(this.get3DGraphicBoudingRect());
        double new_top = adjustedBounds.getTop();
        double new_height = adjustedBounds.getHeight();
        double new_left = adjustedBounds.getLeft();
        double new_width = adjustedBounds.getWidth();
        double dYAxisTitleThickness = this.computeYAxisTitleThickness();
        double dXAxisTitleThickness = this.computeXAxisTitleThickness();
        double rect_width = rectl.width + 2.0 * dYAxisTitleThickness + 5.0;
        if (bo.getWidth() < rect_width) {
            new_left += bo.getLeft() - rectl.x + dYAxisTitleThickness;
            new_width += bo.getWidth() - rect_width;
        } else {
            new_left += bo.getLeft() - (rect_width - bo.getWidth()) / 2.0 - rectl.x;
        }
        double rect_height = rectl.height + dXAxisTitleThickness + 5.0;
        if (bo.getHeight() < rect_height) {
            new_top += bo.getTop() - rectl.y;
            new_height += bo.getHeight() - rect_height;
        } else {
            new_top += bo.getTop() - (rect_height - bo.getHeight()) / 2.0 - rectl.y;
        }
        adjustedBounds.setLeft(new_left);
        adjustedBounds.setTop(new_top);
        adjustedBounds.setWidth(new_width);
        adjustedBounds.setHeight(new_height);
    }

    private void setupFullDataSets(PWA3DComputeContext context) throws ChartException {
        context.oaxPrimaryOrthogonal.getScale().setData(this.getTypedDataSet(context.axPrimaryOrthogonal, context.iOrthogonalAxisType, 0));
        if (context.iAncillaryAxisType != 16) {
            context.oaxAncillaryBase.getScale().setData(this.getTypedDataSet(context.axAncillaryBase, context.iAncillaryAxisType, 0));
        }
        if (context.iPrimaryAxisType != 16) {
            context.oaxPrimaryBase.getScale().setData(this.getTypedDataSet(context.axPrimaryBase, context.iPrimaryAxisType, 0));
        }
    }

    private void setAxisCoordinatesForAll(PWA3DComputeContext context) {
        double dYAxisLocationOnX = context.dX;
        double dYAxisLocationOnZ = context.dZ;
        double dXAxisLocation = context.dY;
        double dZAxisLocation = context.dY;
        OneAxis axPH = this.aax.getPrimaryBase();
        OneAxis axPV = this.aax.getPrimaryOrthogonal();
        OneAxis axAB = this.aax.getAncillaryBase();
        axPH.setAxisCoordinate(dXAxisLocation);
        axPV.setAxisCoordinate(dYAxisLocationOnX);
        axAB.setAxisCoordinate(dZAxisLocation);
        axPH.setAxisCoordinate3D(goFactory.createLocation3D(0.0, dXAxisLocation, dYAxisLocationOnZ));
        axPV.setAxisCoordinate3D(goFactory.createLocation3D(dYAxisLocationOnX, 0.0, dYAxisLocationOnZ));
        axAB.setAxisCoordinate3D(goFactory.createLocation3D(dYAxisLocationOnX, dZAxisLocation, 0.0));
    }

    protected final DataSetIterator getAncillaryDataSet(Axis ax, Axis orthogonalAxis, int iType) throws ChartException, IllegalArgumentException {
        Series[] sea = ax.getRuntimeSeries();
        Series[] osea = orthogonalAxis.getRuntimeSeries();
        if (sea.length == 0 || osea.length == 0) {
            if ((iType & 1) == 1) {
                return new DataSetIterator(new Double[]{new Double(1.0), new Double(2.0)});
            }
            if ((iType & 8) == 8) {
                return new DataSetIterator(new Calendar[]{new CDateTime(), new CDateTime()});
            }
            if ((iType & 0x10) == 16) {
                ArrayList<String> data = new ArrayList<String>();
                if (osea.length > 0) {
                    int i = osea.length - 1;
                    while (i >= 0) {
                        data.add(String.valueOf(osea[i].getSeriesIdentifier()));
                        --i;
                    }
                } else {
                    data.add("A");
                }
                return new DataSetIterator(data.toArray(new String[data.size()]));
            }
        }
        DataSetIterator dsi = this.getTypedDataSet(sea[0], iType);
        ArrayList<Object> data = new ArrayList<Object>();
        int i = 0;
        while (i < osea.length) {
            if (dsi.hasNext()) {
                data.add(dsi.next());
            } else if ((iType & 1) == 1) {
                data.add(new Double(0.0));
            } else if ((iType & 8) == 8) {
                data.add((Object)new CDateTime());
            } else if ((iType & 0x10) == 16) {
                data.add(osea[i].getSeriesIdentifier());
            }
            ++i;
        }
        if ((iType & 1) == 1) {
            return new DataSetIterator(NumberDataSetImpl.create(data));
        }
        if ((iType & 8) == 8) {
            return new DataSetIterator(DateTimeDataSetImpl.create(data));
        }
        if ((iType & 0x10) == 16) {
            return new DataSetIterator(TextDataSetImpl.create(data));
        }
        return null;
    }

    protected Object getMinMax(Axis ax, int iType) throws ChartException, IllegalArgumentException {
        Series[] sea = ax.getRuntimeSeries();
        int iSeriesCount = sea.length;
        Object oMin = null;
        Object oMax = null;
        PluginSettings ps = PluginSettings.instance();
        IDataSetProcessor iDSP = null;
        int i = 0;
        while (i < iSeriesCount) {
            if (sea[i].isStacked()) {
                throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.unstackable.is.stacked"), sea[i]));
            }
            iDSP = ps.getDataSetProcessor(sea[i].getClass());
            DataSet ds = sea[i].getDataSet();
            Object oV1 = iDSP.getMinimum(ds);
            Object oV2 = iDSP.getMaximum(ds);
            if ((iType & 1) == 1) {
                if (oV1 != null) {
                    if (oMin == null) {
                        oMin = oV1;
                    } else if (NumberUtil.isBigNumber(oV1)) {
                        oMin = ((BigNumber)oMin).min((BigNumber)oV1);
                    } else {
                        double dV1 = PlotWith3DAxes.asDouble(oV1);
                        if (Math.min(PlotWith3DAxes.asDouble(oMin), dV1) == dV1) {
                            oMin = oV1;
                        }
                    }
                }
                if (oV2 != null) {
                    if (oMax == null) {
                        oMax = oV2;
                    } else if (NumberUtil.isBigNumber(oV2)) {
                        oMax = ((BigNumber)oMax).max((BigNumber)oV2);
                    } else {
                        double dV2 = PlotWith3DAxes.asDouble(oV2);
                        if (Math.max(PlotWith3DAxes.asDouble(oMax), dV2) == dV2) {
                            oMax = oV2;
                        }
                    }
                }
            } else if ((iType & 8) == 8) {
                if (oV1 != null) {
                    if (oMin == null) {
                        oMin = oV1;
                    } else {
                        CDateTime cdtMin;
                        CDateTime cdtV1 = PlotWith3DAxes.asDateTime(oV1);
                        if (cdtV1.before((Object)(cdtMin = PlotWith3DAxes.asDateTime(oMin)))) {
                            oMin = cdtV1;
                        }
                    }
                }
                if (oV2 != null) {
                    if (oMax == null) {
                        oMax = oV2;
                    } else {
                        CDateTime cdtMax;
                        CDateTime cdtV2 = PlotWith3DAxes.asDateTime(oV2);
                        if (cdtV2.after((Object)(cdtMax = PlotWith3DAxes.asDateTime(oMax)))) {
                            oMax = cdtV2;
                        }
                    }
                }
            }
            ++i;
        }
        if (ax.isPercent()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.no.stack.percent.3D.chart"), ax));
        }
        if (oMin == null && oMax == null) {
            if (iType == 8) {
                int year = Calendar.getInstance().get(1);
                oMin = new CDateTime(year, 1, 1);
                oMax = new CDateTime(year, 12, 31);
            } else if ((iType & 1) == 1) {
                if ((iType & 0x20) == 32) {
                    oMin = new Double(0.0);
                    oMax = new Double(99.99);
                } else if ((iType & 4) == 4) {
                    oMin = new Double(1.0);
                    oMax = new Double(999.0);
                } else {
                    oMin = new Double(-0.9);
                    oMax = new Double(0.9);
                }
            }
        }
        if (iType == 8) {
            try {
                return new Calendar[]{PlotWith3DAxes.asDateTime(oMin), PlotWith3DAxes.asDateTime(oMax)};
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        if ((iType & 1) == 1) {
            try {
                if (NumberUtil.isBigNumber(oMin) || NumberUtil.isBigNumber(oMax)) {
                    return new BigNumber[]{(BigNumber)oMin, (BigNumber)oMax};
                }
                return new double[]{PlotWith3DAxes.asDouble(oMin), PlotWith3DAxes.asDouble(oMax)};
            }
            catch (ClassCastException classCastException) {
                throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
        return null;
    }

    public ISeriesRenderingHints getSeriesRenderingHints(SeriesDefinition sdOrthogonal, Series seOrthogonal) throws ChartException, IllegalArgumentException {
        if (seOrthogonal == null || seOrthogonal.getClass() == SeriesImpl.class) {
            return null;
        }
        OneAxis oaxOrthogonal = this.findOrthogonalAxis(seOrthogonal);
        if (oaxOrthogonal == null) {
            throw new ChartException("org.eclipse.birt.chart.engine", 6, "exception.axis.series.link.broken", new Object[]{seOrthogonal}, Messages.getResourceBundle(this.rtc.getULocale()));
        }
        OneAxis oaxBase = this.aax.getPrimaryBase();
        SeriesDefinition sdBase = (SeriesDefinition)oaxBase.getModelAxis().getSeriesDefinitions().get(0);
        OneAxis oaxAncillaryBase = this.aax.getAncillaryBase();
        AutoScale scBase = oaxBase.getScale();
        AutoScale scOrthogonal = oaxOrthogonal.getScale();
        AutoScale scAncillary = oaxAncillaryBase.getScale();
        int iXTickCount = scBase.getTickCount();
        int iZTickCount = scAncillary.getTickCount();
        double dXUnitSize = scBase.getUnitSize();
        double dZUnitSize = scAncillary.getUnitSize();
        boolean bZCategoryTextStyle = scAncillary.isCategoryScale() || scAncillary.getType() == 16;
        AxisTickCoordinates daXTickCoordinates = scBase.getTickCordinates();
        AxisTickCoordinates daZTickCoordinates = scAncillary.getTickCordinates();
        Object oDataBase = null;
        DataSetIterator dsiDataBase = scBase.getData();
        DataSetIterator dsiDataOrthogonal = this.getTypedDataSet(seOrthogonal, oaxOrthogonal.getScale().getType());
        DataSetIterator dsiDataAncillary = scAncillary.getData();
        double dOrthogonalZero = 0.0;
        dOrthogonalZero = (scOrthogonal.getType() & 1) == 1 ? PlotWith3DAxes.getLocation(scOrthogonal, 0.0) : (oaxOrthogonal.isTickBwtweenCategories() ? scOrthogonal.getStart() : scOrthogonal.getStart() + scOrthogonal.getStartShift());
        double dAncillaryZero = 0.0;
        dAncillaryZero = (scAncillary.getType() & 1) == 1 ? PlotWith3DAxes.getLocation(scAncillary, 0.0) : (oaxAncillaryBase.isTickBwtweenCategories() ? scAncillary.getStart() : scAncillary.getStart() + scAncillary.getStartShift());
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double dXLength = 0.0;
        double dZLength = 0.0;
        int iBaseCount = dsiDataBase.size();
        int iOrthogonalCount = dsiDataOrthogonal.size();
        DataPointHints[] dpa = null;
        int seriesIndex = 0;
        Series[] rss = oaxOrthogonal.getModelAxis().getRuntimeSeries();
        int i = 0;
        while (i < rss.length) {
            if (rss[i] == seOrthogonal) {
                seriesIndex = i;
                break;
            }
            ++i;
        }
        Object oDataAncillary = null;
        int i2 = 0;
        while (i2 < seriesIndex) {
            if (dsiDataAncillary.hasNext()) {
                dsiDataAncillary.next();
            }
            ++i2;
        }
        if (dsiDataAncillary.hasNext()) {
            oDataAncillary = dsiDataAncillary.next();
        }
        if (iBaseCount != iOrthogonalCount) {
            logger.log(1, Messages.getString("exception.base.orthogonal.inconsistent.count", new Object[]{iBaseCount, iOrthogonalCount}, this.rtc.getULocale()));
        } else {
            dpa = new DataPointHints[iBaseCount];
            boolean bScatter = oaxBase.getScale().getType() != 16 && !oaxBase.isCategoryScale();
            FormatSpecifier fsSDAncillary = null;
            if (oaxAncillaryBase.getModelAxis().getSeriesDefinitions().size() > 0) {
                fsSDAncillary = ((SeriesDefinition)oaxAncillaryBase.getModelAxis().getSeriesDefinitions().get(0)).getFormatSpecifier();
            }
            DataPoint dp = seOrthogonal.getDataPoint();
            EList<DataPointComponent> el = dp.getComponents();
            FormatSpecifier fsBase = null;
            FormatSpecifier fsOrthogonal = null;
            FormatSpecifier fsSeries = null;
            FormatSpecifier fsPercentile = null;
            int i3 = 0;
            while (i3 < el.size()) {
                DataPointComponent dpc = (DataPointComponent)el.get(i3);
                DataPointComponentType dpct = dpc.getType();
                if (dpct == DataPointComponentType.BASE_VALUE_LITERAL) {
                    fsBase = dpc.getFormatSpecifier();
                    if (fsBase == null) {
                        fsBase = sdBase.getFormatSpecifier();
                    }
                } else if (dpct == DataPointComponentType.ORTHOGONAL_VALUE_LITERAL) {
                    fsOrthogonal = dpc.getFormatSpecifier();
                    if (fsOrthogonal == null && seOrthogonal.eContainer() instanceof SeriesDefinition) {
                        fsOrthogonal = ((SeriesDefinition)seOrthogonal.eContainer()).getFormatSpecifier();
                    }
                } else if (dpct == DataPointComponentType.SERIES_VALUE_LITERAL) {
                    fsSeries = dpc.getFormatSpecifier();
                    if (fsSeries == null) {
                        fsSeries = fsSDAncillary;
                    }
                } else if (dpct == DataPointComponentType.PERCENTILE_ORTHOGONAL_VALUE_LITERAL) {
                    fsPercentile = dpc.getFormatSpecifier();
                }
                ++i3;
            }
            dsiDataBase.reset();
            dsiDataOrthogonal.reset();
            UserDataSetHints udsh = new UserDataSetHints(seOrthogonal.getDataSets(), this.getModel().isReverseCategory());
            udsh.reset();
            double total = 0.0;
            boolean isZeroValue = true;
            int i4 = 0;
            while (i4 < iOrthogonalCount) {
                Object v = dsiDataOrthogonal.next();
                if (v instanceof Number) {
                    if (((Number)v).doubleValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((Number)v).doubleValue();
                } else if (v instanceof NumberDataElement) {
                    if (((NumberDataElement)v).getValue() != 0.0) {
                        isZeroValue = false;
                    }
                    total += ((NumberDataElement)v).getValue();
                }
                ++i4;
            }
            dsiDataOrthogonal.reset();
            i4 = 0;
            while (i4 < iBaseCount) {
                oDataBase = dsiDataBase.next();
                Object oDataOrthogonal = dsiDataOrthogonal.next();
                if (!bScatter) {
                    if (this.aax.areAxesSwapped()) {
                        dY = daXTickCoordinates.getStart() + dXUnitSize * (double)i4;
                        if (bZCategoryTextStyle) {
                            dZ = daZTickCoordinates.getEnd() - dZUnitSize * (double)(seriesIndex + 1);
                            if (!scAncillary.isTickBetweenCategories()) {
                                dZ -= dZUnitSize / 2.0;
                            }
                        } else {
                            try {
                                dZ = PlotWith3DAxes.getLocation(scAncillary, oDataAncillary);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                dZ = dAncillaryZero;
                            }
                            catch (ChartException chartException) {
                                dZ = dAncillaryZero;
                            }
                        }
                        try {
                            dX = PlotWith3DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dX = dOrthogonalZero;
                        }
                        catch (ChartException chartException) {
                            dX = dOrthogonalZero;
                        }
                    } else {
                        dX = daXTickCoordinates.getStart() + dXUnitSize * (double)i4;
                        if (!oaxBase.isTickBwtweenCategories()) {
                            dX += dXUnitSize / 2.0;
                        }
                        if (bZCategoryTextStyle) {
                            dZ = daZTickCoordinates.getEnd() - dZUnitSize * (double)(seriesIndex + 1);
                            if (!scAncillary.isTickBetweenCategories()) {
                                dZ -= dZUnitSize / 2.0;
                            }
                        } else {
                            try {
                                dZ = PlotWith3DAxes.getLocation(scAncillary, oDataAncillary);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                dZ = dAncillaryZero;
                            }
                            catch (ChartException chartException) {
                                dZ = dAncillaryZero;
                            }
                        }
                        try {
                            dY = PlotWith3DAxes.getLocation(scOrthogonal, oDataOrthogonal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            dY = dOrthogonalZero;
                        }
                        catch (ChartException chartException) {
                            dY = dOrthogonalZero;
                        }
                    }
                } else {
                    throw new ChartException("org.eclipse.birt.chart.engine", 15, "exception.scatter.3D.not.supported", Messages.getResourceBundle(this.rtc.getULocale()));
                }
                Location3D lo3d = goFactory.createLocation3D(dX, dY, dZ);
                dXLength = i4 < iXTickCount - 1 ? daXTickCoordinates.getCoordinate(i4 + 1) - daXTickCoordinates.getCoordinate(i4) : 0.0;
                dZLength = seriesIndex < iZTickCount - 1 ? daZTickCoordinates.getCoordinate(seriesIndex + 1) - daZTickCoordinates.getCoordinate(seriesIndex) : 0.0;
                Double percentileValue = null;
                if (total != 0.0) {
                    if (oDataOrthogonal instanceof Number) {
                        percentileValue = new Double(((Number)oDataOrthogonal).doubleValue() / total);
                    } else if (oDataOrthogonal instanceof NumberDataElement) {
                        percentileValue = new Double(((NumberDataElement)oDataOrthogonal).getValue() / total);
                    }
                } else if (isZeroValue) {
                    percentileValue = new Double(1.0 / (double)iOrthogonalCount);
                }
                dpa[i4] = new DataPointHints(oDataBase, oDataOrthogonal, oDataAncillary, (Object)percentileValue, seOrthogonal.getDataPoint(), fsBase, fsOrthogonal, fsSeries, fsPercentile, i4, (Location)lo3d, new double[]{dXLength, dZLength}, this.rtc);
                udsh.next(dpa[i4]);
                ++i4;
            }
        }
        return new SeriesRenderingHints3D(this, oaxBase.getAxisCoordinate(), oaxAncillaryBase.getAxisCoordinate(), scOrthogonal.getStart(), dOrthogonalZero, scOrthogonal.getEnd() - scOrthogonal.getStart(), daXTickCoordinates, daZTickCoordinates, dpa, scBase, scOrthogonal, scAncillary, dsiDataBase, dsiDataOrthogonal, dsiDataAncillary);
    }

    void buildAxes() throws IllegalArgumentException, ChartException {
        Axis[] axa = this.getModel().getPrimaryBaseAxes();
        Axis axPrimaryBase = axa[0];
        this.validateAxis(axPrimaryBase);
        Axis axPrimaryOrthogonal = this.getModel().getPrimaryOrthogonalAxis(axPrimaryBase);
        this.validateAxis(axPrimaryOrthogonal);
        Axis axAncillaryBase = this.getModel().getAncillaryBaseAxis(axPrimaryBase);
        this.validateAxis(axAncillaryBase);
        if (axPrimaryBase.getAssociatedAxes().size() > 1) {
            throw new ChartException("org.eclipse.birt.chart.engine", 15, "exception.multi.orthogonal.3D.not.supported", Messages.getResourceBundle(this.rtc.getULocale()));
        }
        this.aax = new AllAxes(null);
        this.insCA = this.aax.getInsets();
        this.aax.swapAxes(this.getModel().isTransposed());
        OneAxis oaxPrimaryBase = new OneAxis(axPrimaryBase, 5);
        oaxPrimaryBase.set(this.getOrientation(1), this.transposeLabelPosition(1, PlotWith3DAxes.getLabelPosition(axPrimaryBase.getLabelPosition())), this.transposeLabelPosition(1, PlotWith3DAxes.getLabelPosition(axPrimaryBase.getTitlePosition())), axPrimaryBase.isCategoryAxis(), axPrimaryBase.getScale().isTickBetweenCategories());
        oaxPrimaryBase.setGridProperties(axPrimaryBase.getMajorGrid().getLineAttributes(), axPrimaryBase.getMinorGrid().getLineAttributes(), axPrimaryBase.getMajorGrid().getTickAttributes(), axPrimaryBase.getMinorGrid().getTickAttributes(), this.transposeTickStyle(1, PlotWith3DAxes.getTickStyle(axPrimaryBase, 0)), this.transposeTickStyle(1, PlotWith3DAxes.getTickStyle(axPrimaryBase, 1)), axPrimaryBase.getScale().getMinorGridsPerUnit());
        oaxPrimaryBase.set(axPrimaryBase.getLabel(), axPrimaryBase.getTitle());
        oaxPrimaryBase.set(PlotWith3DAxes.getIntersection(axPrimaryBase));
        oaxPrimaryBase.set(axPrimaryBase.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryBase);
        OneAxis oaxPrimaryOrthogonal = new OneAxis(axPrimaryOrthogonal, 9);
        oaxPrimaryOrthogonal.set(this.getOrientation(2), this.transposeLabelPosition(2, PlotWith3DAxes.getLabelPosition(axPrimaryOrthogonal.getLabelPosition())), this.transposeLabelPosition(2, PlotWith3DAxes.getLabelPosition(axPrimaryOrthogonal.getTitlePosition())), axPrimaryOrthogonal.isCategoryAxis(), axPrimaryOrthogonal.getScale().isTickBetweenCategories());
        oaxPrimaryOrthogonal.setGridProperties(axPrimaryOrthogonal.getMajorGrid().getLineAttributes(), axPrimaryOrthogonal.getMinorGrid().getLineAttributes(), axPrimaryOrthogonal.getMajorGrid().getTickAttributes(), axPrimaryOrthogonal.getMinorGrid().getTickAttributes(), this.transposeTickStyle(2, PlotWith3DAxes.getTickStyle(axPrimaryOrthogonal, 0)), this.transposeTickStyle(2, PlotWith3DAxes.getTickStyle(axPrimaryOrthogonal, 1)), axPrimaryOrthogonal.getScale().getMinorGridsPerUnit());
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLabel(), axPrimaryOrthogonal.getTitle());
        oaxPrimaryOrthogonal.set(PlotWith3DAxes.getIntersection(axPrimaryOrthogonal));
        oaxPrimaryOrthogonal.set(axPrimaryOrthogonal.getLineAttributes());
        this.aax.definePrimary(oaxPrimaryOrthogonal);
        OneAxis oaxAncillaryBase = new OneAxis(axAncillaryBase, 17);
        oaxAncillaryBase.set(0, PlotWith3DAxes.getLabelPosition(axAncillaryBase.getLabelPosition()), PlotWith3DAxes.getLabelPosition(axAncillaryBase.getTitlePosition()), axAncillaryBase.isCategoryAxis(), axAncillaryBase.getScale().isTickBetweenCategories());
        oaxAncillaryBase.setGridProperties(axAncillaryBase.getMajorGrid().getLineAttributes(), axAncillaryBase.getMinorGrid().getLineAttributes(), axAncillaryBase.getMajorGrid().getTickAttributes(), axAncillaryBase.getMinorGrid().getTickAttributes(), PlotWith3DAxes.getTickStyle(axAncillaryBase, 0), PlotWith3DAxes.getTickStyle(axAncillaryBase, 1), axAncillaryBase.getScale().getMinorGridsPerUnit());
        oaxAncillaryBase.set(axAncillaryBase.getLabel(), axAncillaryBase.getTitle());
        oaxAncillaryBase.set(PlotWith3DAxes.getIntersection(axAncillaryBase));
        oaxAncillaryBase.set(axAncillaryBase.getLineAttributes());
        this.aax.defineAncillaryBase(oaxAncillaryBase);
    }

    private Location3D[] get3DGraphicVeteces() {
        Location3D[] loa = new Location3D[8];
        AutoScale scPrimaryBase = this.aax.getPrimaryBase().getScale();
        AutoScale scPrimaryOrthogonal = this.aax.getPrimaryOrthogonal().getScale();
        AutoScale scAncillaryBase = this.aax.getAncillaryBase().getScale();
        double x0 = scPrimaryBase.getStart();
        double y0 = scPrimaryOrthogonal.getStart();
        double z0 = scAncillaryBase.getStart();
        double x1 = scPrimaryBase.getEnd();
        double y1 = scPrimaryOrthogonal.getEnd();
        double z1 = scAncillaryBase.getEnd();
        loa[0] = goFactory.createLocation3D(x0, y0, z0);
        loa[1] = goFactory.createLocation3D(x0, y0, z1);
        loa[2] = goFactory.createLocation3D(x0, y1, z0);
        loa[3] = goFactory.createLocation3D(x0, y1, z1);
        loa[4] = goFactory.createLocation3D(x1, y0, z0);
        loa[5] = goFactory.createLocation3D(x1, y0, z1);
        loa[6] = goFactory.createLocation3D(x1, y1, z0);
        loa[7] = goFactory.createLocation3D(x1, y1, z1);
        return loa;
    }

    public Rectangle get3DGraphicBoudingRect() throws ChartException {
        Text3DRenderEvent event = new Text3DRenderEvent(this);
        Location3D[] loa3D = this.get3DGraphicVeteces();
        Location loOff = this.getPanningOffset();
        double x_min = Double.MAX_VALUE;
        double x_max = -1.7976931348623157E308;
        double y_min = Double.MAX_VALUE;
        double y_max = -1.7976931348623157E308;
        int i = 0;
        while (i < loa3D.length) {
            event.setLocation3D(loa3D[i]);
            this.engine.processEvent_noclip(event, loOff.getX(), loOff.getY());
            Location lo = event.getLocation();
            x_min = Math.min(x_min, lo.getX());
            x_max = Math.max(x_max, lo.getX());
            y_min = Math.min(y_min, lo.getY());
            y_max = Math.max(y_max, lo.getY());
            ++i;
        }
        return new Rectangle(x_min, y_min, x_max - x_min, y_max - y_min);
    }

    public Rectangle getAxisLabelBoundingRectXZ(OneAxis oax) throws ChartException {
        HAxisLabelCanvasLocationProvider lProvider = new HAxisLabelCanvasLocationProvider(this.getPWA3D(), oax);
        AutoScale sc = oax.getScale();
        boolean bTextAxis = (sc.getType() & 0x10) == 16 || sc.isCategoryScale();
        AxisTickCoordinates da = oax.getScale().getTickCordinates();
        int length = bTextAxis ? da.size() - 1 : da.size();
        int iLabelLocation = oax.getLabelPosition();
        Label la = goFactory.copyOf(oax.getLabel());
        AxisLabelTextProvider textProvider = AxisLabelTextProvider.create(oax);
        Rectangle rect = null;
        int i = 0;
        while (i < length) {
            if (sc.isTickLabelVisible(i)) {
                Location[] lo = ((AxisLabelCanvasLocationProvider)lProvider).getLocation(i);
                String str = textProvider.getLabelText(i);
                la.getCaption().setValue(str);
                BoundingBox bb = this.cComp.computeBox(this.ids, iLabelLocation, la, lo[0].getX(), lo[0].getY());
                if (rect == null) {
                    rect = new Rectangle(bb);
                } else {
                    rect.union(new Rectangle(bb));
                }
            }
            ++i;
        }
        return rect;
    }

    public Rectangle[] getAxisLabelBoundingRectY(OneAxis oax) throws ChartException {
        VAxisLabelCanvasLocationProvider lProvider = new VAxisLabelCanvasLocationProvider(this.getPWA3D(), oax);
        AutoScale sc = oax.getScale();
        boolean bTextAxis = (sc.getType() & 0x10) == 16 || sc.isCategoryScale();
        AxisTickCoordinates da = oax.getScale().getTickCordinates();
        int length = bTextAxis ? da.size() - 1 : da.size();
        Label la = goFactory.copyOf(oax.getLabel());
        AxisLabelTextProvider textProvider = AxisLabelTextProvider.create(oax);
        Rectangle[] rect = new Rectangle[2];
        int i = 0;
        while (i < length) {
            if (sc.isTickLabelVisible(i)) {
                Location[] lo = ((AxisLabelCanvasLocationProvider)lProvider).getLocation(i);
                String str = textProvider.getLabelText(i);
                la.getCaption().setValue(str);
                BoundingBox bb0 = this.cComp.computeBox(this.ids, 1, la, lo[0].getX(), lo[0].getY());
                BoundingBox bb1 = this.cComp.computeBox(this.ids, 2, la, lo[1].getX(), lo[1].getY());
                if (rect[0] == null) {
                    rect[0] = new Rectangle(bb0);
                    rect[1] = new Rectangle(bb1);
                } else {
                    rect[0].union(new Rectangle(bb0));
                    rect[1].union(new Rectangle(bb1));
                }
            }
            ++i;
        }
        return rect;
    }

    public Rectangle getBoundsOfAllAxisLabels() throws ChartException {
        Rectangle rect_x = this.getAxisLabelBoundingRectXZ(this.aax.getPrimaryBase());
        Rectangle rect_z = this.getAxisLabelBoundingRectXZ(this.aax.getAncillaryBase());
        Rectangle rect = Rectangle.union(rect_x, rect_z);
        Rectangle[] rect_y = this.getAxisLabelBoundingRectY(this.aax.getPrimaryOrthogonal());
        rect = Rectangle.union(rect, rect_y[0]);
        rect = Rectangle.union(rect, rect_y[1]);
        return rect;
    }

    public Rectangle[] getAllAxisLabelBounds() throws ChartException {
        Rectangle[] rects = new Rectangle[4];
        rects[0] = this.getAxisLabelBoundingRectXZ(this.aax.getPrimaryBase());
        rects[1] = this.getAxisLabelBoundingRectXZ(this.aax.getAncillaryBase());
        Rectangle[] rect_y = this.getAxisLabelBoundingRectY(this.aax.getPrimaryOrthogonal());
        rects[2] = rect_y[0];
        rects[3] = rect_y[1];
        return rects;
    }

    static /* synthetic */ IGObjectFactory access$0() {
        return goFactory;
    }

    private static abstract class AxisLabelCanvasLocationProvider {
        protected PlotWith3DAxes pwa3D;
        protected Engine3D engine;
        protected OneAxis oax;
        protected AutoScale sc;
        protected AxisTickCoordinates da;
        protected int iMajorTickStyle;
        protected double dXEnd;
        protected double dZEnd;
        protected double dTick1;
        protected double dTick2;
        protected double dOffset;
        protected Location loOff;
        protected Text3DRenderEvent event = new Text3DRenderEvent(this);
        protected Location3D lo3d = PlotWith3DAxes.access$0().createLocation3D(0.0, 0.0, 0.0);

        protected AxisLabelCanvasLocationProvider(PlotWith3DAxes pwa3D, OneAxis oax) throws ChartException {
            this.pwa3D = pwa3D;
            this.engine = pwa3D.get3DEngine();
            this.oax = oax;
            this.sc = oax.getScale();
            this.da = this.sc.getTickCordinates();
            this.iMajorTickStyle = oax.getGrid().getTickStyle(0);
            boolean bTextAxis = (this.sc.getType() & 0x10) == 16 || this.sc.isCategoryScale();
            boolean bTickBetweenCategories = oax.getModelAxis().getScale().isTickBetweenCategories();
            int iDirection = this.sc.getDirection() != 1 ? -1 : 1;
            this.dOffset = bTextAxis && bTickBetweenCategories ? (double)iDirection * this.sc.getUnitSize() / 2.0 : 0.0;
            this.loOff = pwa3D.getPanningOffset();
            this.dXEnd = pwa3D.getAxes().getPrimaryBase().getScale().getEnd();
            this.dZEnd = pwa3D.getAxes().getAncillaryBase().getScale().getEnd();
        }

        public abstract Location[] getLocation(int var1);
    }

    private static class HAxisLabelCanvasLocationProvider
    extends AxisLabelCanvasLocationProvider {
        private double y;

        public HAxisLabelCanvasLocationProvider(PlotWith3DAxes pwa3D, OneAxis oax) throws ChartException {
            super(pwa3D, oax);
            double y_ax = oax.getAxisCoordinate3D().getY();
            this.dTick1 = (this.iMajorTickStyle & 1) == 1 ? y_ax + pwa3D.getTickSize() : y_ax;
            this.dTick2 = (this.iMajorTickStyle & 2) == 2 ? y_ax - pwa3D.getTickSize() : y_ax;
            this.y = oax.getLabelPosition() == 4 ? this.dTick1 + 1.0 : this.dTick2 - 1.0;
        }

        public Location[] getLocation(int index) {
            Location[] los = new Location[1];
            if (this.oax.getAxisType() == 5) {
                int x = (int)this.da.getCoordinate(index);
                this.lo3d.set((double)x + this.dOffset, this.y - this.pwa3D.getVerticalSpacingInPixels(), this.dZEnd + this.pwa3D.getVerticalSpacingInPixels());
            } else {
                int z = (int)this.da.getCoordinate(index);
                this.lo3d.set(this.dXEnd + this.pwa3D.getVerticalSpacingInPixels(), this.y - this.pwa3D.getVerticalSpacingInPixels(), (double)z + this.dOffset);
            }
            this.event.setLocation3D(this.lo3d);
            this.engine.processEvent_noclip(this.event, this.loOff.getX(), this.loOff.getY());
            los[0] = this.event.getLocation();
            return los;
        }
    }

    private class PWA3DComputeContext {
        final Axis[] axa;
        final Axis axPrimaryBase;
        final Axis axPrimaryOrthogonal;
        final Axis axAncillaryBase;
        int iPrimaryAxisType;
        int iAncillaryAxisType;
        int iOrthogonalAxisType;
        OneAxis oaxPrimaryBase;
        OneAxis oaxPrimaryOrthogonal;
        OneAxis oaxAncillaryBase;
        DataSetIterator dsiPrimaryBase;
        DataSetIterator dsiOrthogonal;
        DataSetIterator dsiAncillary;
        double dX;
        double dY;
        double dZ;

        private PWA3DComputeContext() {
            this.axa = PlotWith3DAxes.this.getModel().getPrimaryBaseAxes();
            this.axPrimaryBase = this.axa[0];
            this.axPrimaryOrthogonal = PlotWith3DAxes.this.getModel().getPrimaryOrthogonalAxis(this.axPrimaryBase);
            this.axAncillaryBase = PlotWith3DAxes.this.getModel().getAncillaryBaseAxis(this.axPrimaryBase);
            this.iPrimaryAxisType = PlotWith3DAxes.getAxisType(this.axPrimaryBase);
            this.iAncillaryAxisType = PlotWith3DAxes.getAxisType(this.axAncillaryBase);
            this.iOrthogonalAxisType = PlotWith3DAxes.getAxisType(this.axPrimaryOrthogonal);
            this.oaxPrimaryBase = PlotWith3DAxes.this.aax.getPrimaryBase();
            this.oaxPrimaryOrthogonal = PlotWith3DAxes.this.aax.getPrimaryOrthogonal();
            this.oaxAncillaryBase = PlotWith3DAxes.this.aax.getAncillaryBase();
        }
    }

    private static class VAxisLabelCanvasLocationProvider
    extends AxisLabelCanvasLocationProvider {
        private double x;
        private double z_ax;

        public VAxisLabelCanvasLocationProvider(PlotWith3DAxes pwa3D, OneAxis oax) throws ChartException {
            super(pwa3D, oax);
            this.z_ax = oax.getAxisCoordinate3D().getZ();
            double x_ax = oax.getAxisCoordinate3D().getX();
            this.dTick1 = (this.iMajorTickStyle & 1) == 1 ? x_ax - pwa3D.getTickSize() : x_ax;
            this.dTick2 = (this.iMajorTickStyle & 2) == 2 ? x_ax + pwa3D.getTickSize() : x_ax;
            this.x = oax.getLabelPosition() == 1 ? this.dTick1 - 1.0 : this.dTick2 + 1.0;
        }

        public Location[] getLocation(int index) {
            int y = (int)this.da.getCoordinate(index);
            double sx = this.x;
            double sx2 = this.dXEnd;
            Location[] los = new Location[2];
            this.lo3d.set(sx - this.pwa3D.getHorizontalSpacingInPixels(), (double)y + this.dOffset, this.dZEnd + this.pwa3D.getHorizontalSpacingInPixels());
            this.event.setLocation3D(this.lo3d);
            this.engine.processEvent_noclip(this.event, this.loOff.getX(), this.loOff.getY());
            los[0] = this.event.getLocation();
            this.lo3d.set(sx2 + this.pwa3D.getHorizontalSpacingInPixels(), (double)y + this.dOffset, this.z_ax - this.pwa3D.getHorizontalSpacingInPixels());
            this.event.setLocation3D(this.lo3d);
            this.engine.processEvent_noclip(this.event, this.loOff.getX(), this.loOff.getY());
            los[1] = this.event.getLocation();
            return los;
        }
    }
}

