/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.cnf;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.cnf.ServerContentProvider;
import org.eclipse.wst.server.ui.internal.cnf.ServerDecorator;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.osgi.framework.Bundle;

public class ServerLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            if (ms.module == null) {
                return "";
            }
            int size = ms.module.length;
            String name = ms.module[size - 1].getName();
            return name;
        }
        if (element instanceof IServer) {
            IServer server = (IServer)element;
            return this.notNull(server.getName());
        }
        if (element == ServerContentProvider.INITIALIZING) {
            return Messages.viewInitializing;
        }
        if (element instanceof IWorkspaceRoot) {
            return Platform.getResourceString((Bundle)ServerUIPlugin.getInstance().getBundle(), (String)"%viewServers");
        }
        return "";
    }

    public Image getImage(Object element) {
        IServer server;
        Image image = null;
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            ILabelProvider labelProvider = ServerUICore.getLabelProvider();
            image = labelProvider.getImage((Object)ms.module[ms.module.length - 1]);
            labelProvider.dispose();
        } else if (element instanceof IServer && (server = (IServer)element).getServerType() != null && (image = ServerDecorator.getServerStateImage(server)) == null) {
            image = ImageResource.getImage(server.getServerType().getId());
        }
        return image;
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        if (element instanceof IServer && property.equalsIgnoreCase("ICON")) {
            return true;
        }
        return true;
    }
}

