/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;

public class FnAdjustTimeToTimeZone
extends Function {
    private static Collection _expected_args = null;
    private static final XSDayTimeDuration minDuration = new XSDayTimeDuration(0, 14, 0, 0.0, true);
    private static final XSDayTimeDuration maxDuration = new XSDayTimeDuration(0, 14, 0, 0.0, false);

    public FnAdjustTimeToTimeZone() {
        super(new QName("adjust-time-to-timezone"), 1, 2);
    }

    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnAdjustTimeToTimeZone.adjustTime(args, this.dynamic_context());
    }

    public static ResultSequence adjustTime(Collection args, DynamicContext dc) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnAdjustTimeToTimeZone.expectedArgs());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argiter = cargs.iterator();
        ResultSequence arg1 = (ResultSequence)argiter.next();
        if (arg1.empty()) {
            return rs;
        }
        ResultSequence arg2 = ResultSequenceFactory.create_new();
        if (argiter.hasNext()) {
            arg2 = (ResultSequence)argiter.next();
        }
        XSTime time = (XSTime)arg1.first();
        XSDayTimeDuration timezone = null;
        if (arg2.empty()) {
            if (time.timezoned()) {
                XSTime localized = new XSTime(time.calendar(), null);
                rs.add(localized);
                return rs;
            }
            return arg1;
        }
        XMLGregorianCalendar xmlCalendar = null;
        try {
            xmlCalendar = time.tz() != null ? DatatypeFactory.newInstance().newXMLGregorianCalendar((GregorianCalendar)time.normalizeCalendar(time.calendar(), time.tz())) : DatatypeFactory.newInstance().newXMLGregorianCalendarTime(time.hour(), time.minute(), (int)time.second(), 0);
            timezone = (XSDayTimeDuration)arg2.first();
            if (timezone.lt(minDuration, dc) || timezone.gt(maxDuration, dc)) {
                throw DynamicError.invalidTimezone();
            }
            if (time.tz() == null) {
                rs.add(new XSTime(time.calendar(), timezone));
                return rs;
            }
            Duration duration = DatatypeFactory.newInstance().newDuration(timezone.string_value());
            xmlCalendar.add(duration);
            rs.add(new XSTime(xmlCalendar.toGregorianCalendar(), timezone));
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw DynamicError.invalidTimezone();
        }
        return rs;
    }

    public static synchronized Collection expectedArgs() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            _expected_args.add(new SeqType(new XSTime(), 3));
            _expected_args.add(new SeqType(new XSDayTimeDuration(), 3));
        }
        return _expected_args;
    }
}

