/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.ui.util.ConcurrentTaskManager;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvisioningJobListener
extends JobChangeAdapter {
    private final Set<CatalogItem> installItems;

    public ProvisioningJobListener(Set<CatalogItem> installItems) {
        this.installItems = installItems;
    }

    public void done(IJobChangeEvent event) {
        if (event.getResult().isOK()) {
            Job job = new Job(Messages.ProvisioningJobListener_notificationTaskName){
                {
                    this.setPriority(30);
                    this.setSystem(true);
                    this.setUser(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    ConcurrentTaskManager taskManager = new ConcurrentTaskManager(ProvisioningJobListener.this.installItems.size(), Messages.ProvisioningJobListener_notificationTaskName);
                    for (final CatalogItem item : ProvisioningJobListener.this.installItems) {
                        taskManager.submit(new Runnable(){

                            public void run() {
                                Node node = (Node)item.getData();
                                String url = node.getUrl();
                                if (!url.endsWith("/")) {
                                    url = String.valueOf(url) + "/";
                                }
                                url = String.valueOf(url) + "success";
                                try {
                                    InputStream stream = RepositoryTransport.getInstance().stream(new URI(url), (IProgressMonitor)new NullProgressMonitor());
                                    try {
                                        while (stream.read() != -1) {
                                        }
                                    }
                                    finally {
                                        stream.close();
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    try {
                        taskManager.waitUntilFinished(monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

