/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.ExecutionArguments;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.target.provisional.ITargetHandle;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.osgi.framework.Bundle;

public class LaunchArgumentsHelper {
    static /* synthetic */ Class class$0;

    public static String getWorkspaceLocation(ILaunchConfiguration configuration) throws CoreException {
        String location = configuration.getAttribute("location", null);
        if (location == null && (location = configuration.getAttribute("location0", null)) != null) {
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute("location0", null);
            wc.setAttribute("location", location);
            wc.doSave();
        }
        return LaunchArgumentsHelper.getSubstitutedString(location);
    }

    public static String[] getUserProgramArgumentArray(ILaunchConfiguration configuration) throws CoreException {
        String args = LaunchArgumentsHelper.getUserProgramArguments(configuration);
        return new ExecutionArguments("", args).getProgramArgumentsArray();
    }

    public static String getUserProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        if (args == null && (args = configuration.getAttribute("progargs", null)) != null) {
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute("progargs", null);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.doSave();
        }
        return args == null ? "" : LaunchArgumentsHelper.getSubstitutedString(args);
    }

    public static String getUserVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String args = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        if (args == null && (args = configuration.getAttribute("vmargs", null)) != null) {
            ILaunchConfigurationWorkingCopy wc = null;
            wc = configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)configuration : configuration.getWorkingCopy();
            wc.setAttribute("vmargs", null);
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, args);
            wc.doSave();
        }
        return args == null ? "" : LaunchArgumentsHelper.getSubstitutedString(args);
    }

    public static String getInitialVMArguments() {
        try {
            ITargetHandle target;
            ITargetPlatformService service;
            PDECore pDECore = PDECore.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((service = (ITargetPlatformService)pDECore.acquireService(clazz.getName())) != null && (target = service.getWorkspaceTargetHandle()) != null) {
                String result = target.getTargetDefinition().getVMArguments();
                result = result != null ? result : "";
                return result;
            }
        }
        catch (CoreException coreException) {}
        PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
        StringBuffer result = new StringBuffer(preferences.getString("vm_args"));
        if (preferences.getBoolean("vm_launcher_ini")) {
            result.append(TargetPlatformHelper.getIniVMArgs());
        }
        return result.toString();
    }

    public static String getInitialProgramArguments() {
        StringBuffer buffer = new StringBuffer("-os ${target.os} -ws ${target.ws} -arch ${target.arch} -nl ${target.nl} -consoleLog");
        PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
        String programArgs = preferences.getString("program_args");
        if (programArgs.length() > 0) {
            buffer.append(" ");
            buffer.append(programArgs);
        }
        return buffer.toString();
    }

    public static File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        String working;
        try {
            working = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, new File(".").getCanonicalPath());
        }
        catch (IOException iOException) {
            working = "${workspace_loc}/../";
        }
        File dir = new File(LaunchArgumentsHelper.getSubstitutedString(working));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static Map getVMSpecificAttributesMap(ILaunchConfiguration config) throws CoreException {
        ModelEntry entry;
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        String javaCommand = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, null);
        map.put(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, javaCommand);
        if (TargetPlatform.getOS().equals("macosx") && (entry = PluginRegistry.findEntry((String)"org.eclipse.jdt.debug")) != null) {
            IPluginModelBase[] models = entry.getExternalModels();
            int i = 0;
            while (i < models.length) {
                File file = new File(models[i].getInstallLocation());
                if (!file.isFile()) {
                    file = new File(file, "jdi.jar");
                }
                if (file.exists()) {
                    map.put(IJavaLaunchConfigurationConstants.ATTR_BOOTPATH_PREPEND, new String[]{file.getAbsolutePath()});
                    break;
                }
                ++i;
            }
        }
        return map;
    }

    public static String getTracingFileArgument(ILaunchConfiguration config, String optionsFileName) throws CoreException {
        try {
            TracingOptionsManager mng = PDECore.getDefault().getTracingOptionsManager();
            Map options = config.getAttribute("tracingOptions", null);
            String selected = config.getAttribute("checked", null);
            if (selected == null) {
                mng.save(optionsFileName, options);
            } else if (!selected.equals("[NONE]")) {
                HashSet<String> result = new HashSet<String>();
                StringTokenizer tokenizer = new StringTokenizer(selected, ",");
                while (tokenizer.hasMoreTokens()) {
                    result.add(tokenizer.nextToken());
                }
                mng.save(optionsFileName, options, result);
            }
        }
        catch (CoreException coreException) {
            return "";
        }
        return optionsFileName;
    }

    public static String[] constructClasspath(ILaunchConfiguration configuration) throws CoreException {
        String jarPath;
        double targetVersion = TargetPlatformHelper.getTargetVersion();
        String string = jarPath = targetVersion >= 3.3 ? LaunchArgumentsHelper.getEquinoxStartupPath("org.eclipse.equinox.launcher") : LaunchArgumentsHelper.getStartupJarPath();
        if (jarPath == null && targetVersion < 3.3) {
            jarPath = LaunchArgumentsHelper.getEquinoxStartupPath("org.eclipse.core.launcher");
        }
        if (jarPath == null) {
            return null;
        }
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(jarPath);
        String bootstrap = configuration.getAttribute("bootstrap", "");
        StringTokenizer tok = new StringTokenizer(LaunchArgumentsHelper.getSubstitutedString(bootstrap), ",");
        while (tok.hasMoreTokens()) {
            entries.add(tok.nextToken().trim());
        }
        return entries.toArray(new String[entries.size()]);
    }

    private static String getEquinoxStartupPath(String packageName) throws CoreException {
        Bundle bundle;
        IPluginModelBase model = PluginRegistry.findModel((String)"org.eclipse.equinox.launcher");
        if (model != null) {
            IResource resource = model.getUnderlyingResource();
            if (resource == null) {
                return model.getInstallLocation();
            }
            IProject project = resource.getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IClasspathEntry[] entries = jProject.getRawClasspath();
                int i = 0;
                while (i < entries.length) {
                    int kind = entries[i].getEntryKind();
                    if (kind == 3 || kind == 1) {
                        IPackageFragmentRoot[] roots = jProject.findPackageFragmentRoots(entries[i]);
                        int j = 0;
                        while (j < roots.length) {
                            if (roots[j].getPackageFragment(packageName).exists()) {
                                if (kind == 3) {
                                    IPath path = entries[i].getOutputLocation();
                                    if (path == null) {
                                        path = jProject.getOutputLocation();
                                    }
                                    path = path.removeFirstSegments(1);
                                    return project.getLocation().append(path).toOSString();
                                }
                                IResource jar = roots[j].getResource();
                                if (jar != null) {
                                    return jar.getLocation().toOSString();
                                }
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        if ((bundle = Platform.getBundle((String)"org.eclipse.equinox.launcher")) != null) {
            try {
                URL url = FileLocator.resolve((URL)bundle.getEntry("/"));
                url = FileLocator.toFileURL((URL)url);
                String path = url.getFile();
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if ((path = new File(path).getAbsolutePath()).endsWith("!")) {
                    path = path.substring(0, path.length() - 1);
                }
                return path;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static String getStartupJarPath() throws CoreException {
        File startupJar;
        IPluginModelBase model = PluginRegistry.findModel((String)"org.eclipse.platform");
        if (model != null && model.getUnderlyingResource() != null) {
            IProject project = model.getUnderlyingResource().getProject();
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject jProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    if (roots[i].getKind() == 1 && roots[i].getPackageFragment("org.eclipse.core.launcher").exists()) {
                        IPath path = jProject.getOutputLocation().removeFirstSegments(1);
                        return project.getLocation().append(path).toOSString();
                    }
                    ++i;
                }
            }
            if (project.getFile("startup.jar").exists()) {
                return project.getFile("startup.jar").getLocation().toOSString();
            }
        }
        if (!(startupJar = new Path(TargetPlatform.getLocation()).append("startup.jar").toFile()).exists()) {
            startupJar = new Path(TargetPlatform.getDefaultLocation()).append("startup.jar").toFile();
        }
        return startupJar.exists() ? startupJar.getAbsolutePath() : null;
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public static String getDefaultWorkspaceLocation(String uniqueName) {
        return "${workspace_loc}/../runtime-" + uniqueName.replaceAll("\\s", "");
    }

    public static String getDefaultJUnitWorkspaceLocation() {
        return "${workspace_loc}/../junit-workspace";
    }

    public static String getDefaultJUnitConfigurationLocation() {
        return "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/pde-junit";
    }
}

