/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IQualifiedAllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;

public class QualifiedAllocationExpression
extends AllocationExpression
implements IQualifiedAllocationExpression {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration anonymousType) {
        this.anonymousType = anonymousType;
        anonymousType.allocation = this;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(currentScope, flowContext, flowInfo);
        }
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo);
                ++i;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(currentScope, flowContext, flowInfo);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding allocatedTypeErasure;
        if ((flowInfo.tagBits & 1) == 0 && (allocatedTypeErasure = this.binding.declaringClass).isNestedType() && currentScope.enclosingSourceType().isLocalType() && allocatedTypeErasure.isLocalType()) {
            ((LocalTypeBinding)allocatedTypeErasure).addInnerEmulationDependent(currentScope, this.enclosingInstance != null);
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, output).append('.');
        }
        super.printExpression(0, output);
        if (this.anonymousType != null) {
            this.anonymousType.print(indent, output);
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        int length;
        if (this.anonymousType == null && this.enclosingInstance == null) {
            return super.resolveType(scope);
        }
        this.constant = Constant.NotAConstant;
        TypeBinding enclosingInstanceType = null;
        TypeBinding receiverType = null;
        boolean hasError = false;
        boolean argsContainCast = false;
        if (this.enclosingInstance != null) {
            enclosingInstanceType = this.enclosingInstance.resolveType(scope);
            if (enclosingInstanceType == null) {
                hasError = true;
            } else if (enclosingInstanceType.isBaseType() || enclosingInstanceType.isArrayType()) {
                scope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(enclosingInstanceType, this.enclosingInstance);
                hasError = true;
            } else if (this.type instanceof QualifiedTypeReference) {
                scope.problemReporter().illegalUsageOfQualifiedTypeReference((QualifiedTypeReference)this.type);
                hasError = true;
            } else {
                receiverType = ((SingleTypeReference)this.type).resolveTypeEnclosing(scope, (ReferenceBinding)enclosingInstanceType);
            }
        } else if (this.type == null) {
            receiverType = scope.enclosingSourceType();
        } else {
            receiverType = this.type.resolveType(scope, true);
            if (receiverType == null) {
                // empty if block
            }
        }
        if (receiverType == null) {
            hasError = true;
        }
        TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                argumentTypes[i] = argument.resolveType(scope);
                if (argumentTypes[i] == null) {
                    hasError = true;
                }
                ++i;
            }
        }
        if (hasError) {
            if (receiverType instanceof ReferenceBinding) {
                MethodBinding closestMatch;
                length = this.arguments == null ? 0 : this.arguments.length;
                TypeBinding[] pseudoArgs = new TypeBinding[length];
                int i = length;
                while (--i >= 0) {
                    TypeBinding typeBinding = pseudoArgs[i] = argumentTypes[i] == null ? TypeBinding.NULL : argumentTypes[i];
                }
                this.binding = scope.findMethod((ReferenceBinding)receiverType, TypeConstants.INIT, pseudoArgs, this);
                if (this.binding != null && !this.binding.isValidBinding() && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                    this.binding = closestMatch;
                    MethodBinding closestMatchOriginal = closestMatch.original();
                    if ((closestMatchOriginal.isPrivate() || closestMatchOriginal.declaringClass.isLocalType()) && !scope.isDefinedInMethod(closestMatchOriginal)) {
                        closestMatchOriginal.modifiers |= 0x8000000;
                    }
                }
            }
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        if (this.anonymousType == null) {
            if (!receiverType.canBeInstantiated()) {
                scope.problemReporter().cannotInstantiate(this.type, receiverType);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            ReferenceBinding allocationType = (ReferenceBinding)receiverType;
            this.binding = scope.getConstructor(allocationType, argumentTypes, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, scope, true)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocationType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            QualifiedAllocationExpression.checkInvocationArguments(scope, null, allocationType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
            ReferenceBinding expectedType = this.binding.declaringClass.enclosingType();
            if (expectedType != enclosingInstanceType) {
                scope.compilationUnitScope().recordTypeConversion(expectedType, enclosingInstanceType);
            }
            if (enclosingInstanceType.isCompatibleWith(expectedType) || scope.isBoxingCompatibleWith(enclosingInstanceType, expectedType)) {
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            scope.problemReporter().typeMismatchError(enclosingInstanceType, expectedType, this.enclosingInstance);
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        this.superTypeBinding = (ReferenceBinding)receiverType;
        scope.addAnonymousType(this.anonymousType, (ReferenceBinding)receiverType);
        this.anonymousType.resolve(scope);
        MethodBinding inheritedBinding = scope.getConstructor(this.superTypeBinding, argumentTypes, this);
        if (!inheritedBinding.isValidBinding()) {
            if (inheritedBinding.declaringClass == null) {
                inheritedBinding.declaringClass = this.superTypeBinding;
            }
            scope.problemReporter().invalidConstructor(this, inheritedBinding);
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.enclosingInstance != null) {
            ReferenceBinding targetEnclosing = inheritedBinding.declaringClass.enclosingType();
            if (targetEnclosing == null) {
                scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.enclosingInstance, (ReferenceBinding)receiverType);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            if (!enclosingInstanceType.isCompatibleWith(targetEnclosing) && !scope.isBoxingCompatibleWith(enclosingInstanceType, targetEnclosing)) {
                scope.problemReporter().typeMismatchError(enclosingInstanceType, targetEnclosing, this.enclosingInstance);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
        }
        if (this.arguments != null) {
            QualifiedAllocationExpression.checkInvocationArguments(scope, null, this.superTypeBinding, inheritedBinding, this.arguments, argumentTypes, argsContainCast, this);
        }
        this.binding = this.anonymousType.createDefaultConstructorWithBinding(inheritedBinding);
        this.resolvedType = this.anonymousType.binding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(visitor, scope);
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    public int getASTType() {
        return 85;
    }
}

