/*******************************************************************************
 * Copyright (c) 2008 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.core.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JavaSerializer<K> implements BTreeSerializer<K>
{

	public byte[] getBytes( K object ) throws IOException
	{
		ByteArrayOutputStream out = new ByteArrayOutputStream( );
		ObjectOutputStream oo = new ObjectOutputStream( out );
		oo.writeObject( object );
		return out.toByteArray( );
	}

	public K getObject( byte[] bytes ) throws IOException,
			ClassNotFoundException
	{
		ByteArrayInputStream in = new ByteArrayInputStream( bytes );
		ObjectInputStream oi = new ObjectInputStream( in );
		return (K) oi.readObject( );
	}
}
