/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the service database table.
 * 
 */
@Entity
@Table(name="SERVICE")
public class Service implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="ID_SERVICE")
	private Integer idService;

    @Temporal( TemporalType.TIMESTAMP)
	private Date enddate;

	@Column(name="MONITOR_ENABLED")
	private String monitorEnabled;

    @Temporal( TemporalType.TIMESTAMP)
	private Date startdate;

	private double state;
	
	@Column(name="NAME")
	private String name;

	//bi-directional many-to-one association to Message
	@OneToMany(mappedBy="service",fetch=FetchType.LAZY)
	private Set<Message> messages;

	//bi-directional many-to-one association to ServiceInstance
	@OneToMany(mappedBy="service",fetch=FetchType.LAZY)
	private Set<ServiceInstance> serviceInstances;

    public Service() {
    }


	public Date getEnddate() {
		return this.enddate;
	}

	public void setEnddate(Date enddate) {
		this.enddate = enddate;
	}

	public String getMonitorEnabled() {
		return this.monitorEnabled;
	}

	public void setMonitorEnabled(String monitorEnabled) {
		this.monitorEnabled = monitorEnabled;
	}

	public Date getStartdate() {
		return this.startdate;
	}

	public void setStartdate(Date startdate) {
		this.startdate = startdate;
	}

	public double getState() {
		return this.state;
	}

	public void setState(double state) {
		this.state = state;
	}

	public Set<Message> getMessages() {
		return this.messages;
	}

	public void setMessages(Set<Message> messages) {
		this.messages = messages;
	}
	
	public Set<ServiceInstance> getServiceInstances() {
		return this.serviceInstances;
	}

	public void setServiceInstances(Set<ServiceInstance> serviceInstances) {
		this.serviceInstances = serviceInstances;
	}


	public Integer getIdService() {
		return idService;
	}


	public void setIdService(Integer idService) {
		this.idService = idService;
	}


	public String getName() {
		return name;
	}


	public void setName(String name) {
		this.name = name;
	}
	
}