/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;


/**
 * The persistent class for the sbi_alarm_contact database table.
 * 
 */
@Entity
@Table(name="SBI_ALARM_CONTACT")
public class SbiAlarmContact implements Serializable {
	private static final long serialVersionUID = 1L;

    @TableGenerator(name="AlarmCId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="ALARM_CONTACT_ID", allocationSize=1)
	@Id
    @GeneratedValue(generator="AlarmCId", strategy=GenerationType.TABLE) 
	@Column(name="ALARM_CONTACT_ID")
	private Integer alarmContactId;

	@Column(name="EMAIL")
	private String email;

	@Column(name="MOBILE")
	private String mobile;

	@Column(name="NAME")
	private String name;

	@Column(name="RESOURCES")
	private String resources;

	//bi-directional many-to-many association to SbiAlarm
    @ManyToMany(fetch=FetchType.LAZY, cascade = CascadeType.ALL)
	@JoinTable(
		name="sbi_alarm_distribution"
		, joinColumns={
			@JoinColumn(name="ALARM_CONTACT_ID")
			}
		, inverseJoinColumns={
			@JoinColumn(name="ALARM_ID")
			}
		)
	private Set<SbiAlarm> sbiAlarms;

    public SbiAlarmContact() {
    }

	public int getAlarmContactId() {
		return this.alarmContactId;
	}

	public void setAlarmContactId(int alarmContactId) {
		this.alarmContactId = alarmContactId;
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getMobile() {
		return this.mobile;
	}

	public void setMobile(String mobile) {
		this.mobile = mobile;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getResources() {
		return this.resources;
	}

	public void setResources(String resources) {
		this.resources = resources;
	}

	public Set<SbiAlarm> getSbiAlarms() {
		return this.sbiAlarms;
	}

	public void setSbiAlarms(Set<SbiAlarm> sbiAlarms) {
		this.sbiAlarms = sbiAlarms;
	}
	
}