/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the journal database table.
 * 
 */
@Entity
@Table(name = "EBAM_JOURNAL")
public class Journal implements Serializable {
	
	/**
	 * Serial version.
	 */
	private static final long serialVersionUID = 1L;
	
    @TableGenerator(name="JId", table="ID_GEN",
            pkColumnName="ID_NAME", valueColumnName="ID_VAL",
            pkColumnValue="JOURNAL_ID", allocationSize=1)
	@Id
    @GeneratedValue(generator="JId", strategy=GenerationType.TABLE)   
	@Column(name = "JOURNAL_ID")
	private Double jurnalId;

	/**
	 * Alarm.
	 */
	@Column(name = "ALARM")
	private String alarm;

	/**
	 * End date.
	 */
    @Temporal(TemporalType.TIMESTAMP)
	@Column(name = "END_DATE")
	private Date endDate;

	/**
	 * Error.
	 */
	@Column(name="ERROR")
	private String error;
	
	@Column(name="MARKER")
	private String marker;

	/**
	 * Execution timestamp.
	 */
    @Temporal(TemporalType.TIMESTAMP)
	@Column(name = "EXECUTION_TIME")
	private Date executionTime;

	/**
	 * Field storing the xml key.
	 */
	@Column(name = "NAME")
	private String name;
	
	/**
	 * Phase description.
	 */
	@Column(name = "PHASE_DESCR")
	private String phaseDescr;

	/**
	 * Phase name.
	 */
	@Column(name = "PHASE_NAME")
	private String phaseName;

	/**
	 * Phase progressive.
	 */
	@Column(name = "PHASE_PROG")
	private String phaseProg;

	/**
	 * Request.
	 */
    @Lob()
	private String request;

	/**
	 * Response.
	 */
    @Lob()
	private String response;

	/**
	 * Original service source.
	 */
	@Column(name = "SERVICE_SRC_ORIG")
	private String serviceSrcOrig;

	/**
	 * Start date.
	 */
    @Temporal(TemporalType.TIMESTAMP)
	@Column(name = "START_DATE")
	private Date startDate;

	/**
	 * State description.
	 */
	@Column(name = "STATE_DESCR")
	private String stateDescr;

	/**
	 * Timestamp insert.
	 */
    @Temporal(TemporalType.TIMESTAMP)
	@Column(name = "TIMESTAMP_IN")
	private Date timestampIn;

	/**
	 * Warning.
	 */
	@Column(name = "WARNING")
	private String warning;
	/**
	 * Field storing the whole xml message.
	 */
	@Column(name = "XML_DATA")
	private String xmlData;
	/**
	 * Source name.
	 */	
	@Column(name = "SOURCE_NAME")
	private String sourceName;
	
	/**
	 * Source label.
	 */	
	@Column(name = "LABEL")
	private String label;
	/**
	 * Service instance id.
	 */
	//bi-directional many-to-one association to ServiceInstance
    @ManyToOne(fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
    @JoinColumn(name = "ID_SERVICE_INSTANCE")    
	private ServiceInstance serviceInstance;
	/**
	 * Message id.
	 */
	//bi-directional many-to-one association to Message
    @ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "MESSAGE_ID")
	private Message message;
	/**
	 * Message content (relevant data).
	 */
	//bi-directional many-to-one association to MessageContent
	@OneToMany(mappedBy = "journal", fetch = FetchType.LAZY)
	private Set<MessageContent> messageContents;

    public Journal() {
    }

	public double getJurnalId() {
		return this.jurnalId;
	}

	public void setJurnalId(double jurnalId) {
		this.jurnalId = jurnalId;
	}

	public String getSourceName() {
		return sourceName;
	}

	public void setSourceName(String sourceName) {
		this.sourceName = sourceName;
	}
	public String getAlarm() {
		return this.alarm;
	}

	public void setAlarm(String alarm) {
		this.alarm = alarm;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getError() {
		return this.error;
	}

	public void setError(String error) {
		this.error = error;
	}

	public Date getExecutionTime() {
		return this.executionTime;
	}

	public void setExecutionTime(Date executionTime) {
		this.executionTime = executionTime;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getPhaseDescr() {
		return this.phaseDescr;
	}

	public void setPhaseDescr(String phaseDescr) {
		this.phaseDescr = phaseDescr;
	}

	public String getPhaseName() {
		return this.phaseName;
	}

	public void setPhaseName(String phaseName) {
		this.phaseName = phaseName;
	}

	public String getPhaseProg() {
		return this.phaseProg;
	}

	public void setPhaseProg(String phaseProg) {
		this.phaseProg = phaseProg;
	}

	public String getRequest() {
		return this.request;
	}

	public void setRequest(String request) {
		this.request = request;
	}

	public String getResponse() {
		return this.response;
	}

	public void setResponse(String response) {
		this.response = response;
	}

	public String getServiceSrcOrig() {
		return this.serviceSrcOrig;
	}

	public void setServiceSrcOrig(String serviceSrcOrig) {
		this.serviceSrcOrig = serviceSrcOrig;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public String getStateDescr() {
		return this.stateDescr;
	}

	public void setStateDescr(String stateDescr) {
		this.stateDescr = stateDescr;
	}

	public Date getTimestampIn() {
		return this.timestampIn;
	}

	public void setTimestampIn(Date timestampIn) {
		this.timestampIn = timestampIn;
	}

	public String getWarning() {
		return this.warning;
	}

	public void setWarning(String warning) {
		this.warning = warning;
	}

	public String getXmlData() {
		return this.xmlData;
	}

	public void setXmlData(String xmlData) {
		this.xmlData = xmlData;
	}

	public ServiceInstance getServiceInstance() {
		return this.serviceInstance;
	}

	public void setServiceInstance(ServiceInstance serviceInstance) {
		this.serviceInstance = serviceInstance;
	}
	
	public Message getMessage() {
		return this.message;
	}

	public void setMessage(Message message) {
		this.message = message;
	}
	
	public Set<MessageContent> getMessageContents() {
		return this.messageContents;
	}

	public void setMessageContents(Set<MessageContent> messageContents) {
		this.messageContents = messageContents;
	}

	public String getMarker() {
		return marker;
	}

	public void setMarker(String marker) {
		this.marker = marker;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}
	
}