/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Query;
import javax.xml.namespace.QName;

import org.eclipse.ebam.emf.interfaces.ICEPTransaction;
import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Event;
import org.eclipse.ebam.model.entities.EventAttribute;
import org.eclipse.ebam.model.entities.EventContent;
import org.eclipse.ebam.model.entities.EventJournal;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CEPTransaction extends EMF implements ICEPTransaction{
	
	/**
	 * Logger.
	 */
	private static Logger logger = 
							LoggerFactory.getLogger(CEPTransaction.class);
	private EntityManager em = null;
	
	public String retrieveStatement(Integer idStatement){
		EntityManagerFactory emf = getEMF();
		em = emf.createEntityManager();
		// to do : prendo gli stamente in base ad in numero progressivo
		
		return null;
	}	
	 	
	public String retrieveListener(Integer idStatement){
		// to do : prendo la strainga del nome del listener da attaccare allo statement
		return null;
	}
	
	public List<Message> retrieveEbamMessages(){
		List<Message> result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        Query query = em.createQuery("select e from  Message e ");
	      
	      result  = query.getResultList();
	       
	        
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;}
		
	}
	
	public Integer retrieveIdMessage(Integer i){
		Integer result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        Query query = em.createQuery("SELECT * FROM  EBAM_MESSAGE WHERE  MESSAGE_ID=:index");
	        query.setParameter(":index", i);
	        Message m = (Message) query.getSingleResult();
	        result = m.getMessageId();
	        
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;
			
		}
		
		
		//to do ritorna l'id message
		
	}
	
	
	public List <DataAttribute> retrieveEbamDataAttributes(Integer idEventMessage) {
		List<DataAttribute> result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        result = new ArrayList<DataAttribute>();
			Query query = em.createQuery("select s from DataAttribute s where s.message.messageId = :index");
	        query.setParameter("index", idEventMessage);
	        result = query.getResultList();
	        
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;	
		}
	};
	
	public Map<String,String> retrieveAttributesPath(Integer idEventMessage){
		// getting the name and the xpath of the attribute 
		List<DataAttribute> data = retrieveEbamDataAttributes(idEventMessage);
		Map<String,String> result = new HashMap<String, String>();
		if(data != null && !data.isEmpty()){
			for (DataAttribute dataAttribute: data){
				result.put(dataAttribute.getName(), dataAttribute.getExpression());
			}	
		}
		return result;
	}
	
	public Map<String,QName> retrieveAttributesType(Integer idEventMessage){
		// getting the xpath and the type of teh attribute
		List<DataAttribute> data = retrieveEbamDataAttributes(idEventMessage);
		Map<String,QName> result = new HashMap<String, QName>();
		if(data != null && !data.isEmpty()){
			for (DataAttribute dataAttribute: data){
				result.put(dataAttribute.getExpression(), dataAttribute.toQName(dataAttribute.getAttrType()));
			}	
		}
		return result;
		
	}
	public String retrieveNameEvent(Integer idEventMessage){
		//getting the name of the event
		String result = null;
		try {
			Query query = em.createQuery("SELECT NAME  FROM EBAM_MESSAGE WHERE ID_SERVICE =:index");
	        query.setParameter(":index", idEventMessage);
	        result = (String) query.getSingleResult();
	        
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;}
	}
	
	public String retrieveRootNameElement(Integer idEventMessage){
		String result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        Query query = em.createQuery("SELECT ROOT_ELEMENT FROM  EBAM_MESSAGE WHERE  MESSAGE_ID= :index");
	        query.setParameter(":index", idEventMessage);
	        String m = (String) query.getSingleResult();
	        result = m ;
	        
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;}
		
		// to  do: prendo il root element dell'event type.
		
		
	}

	public List<Rule> retrieveCEPRules() {
		List<Rule> result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        result = new ArrayList<Rule>();
			Query query = em.createQuery("select s from Rule s ");
	        result = query.getResultList();
	        
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;
			}
		}
		

	public List<Rule> retrieveCEPRulesByType(SbiDomain domainType) {
		List<Rule> result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        result = new ArrayList<Rule>();
			Query query = em.createQuery("select s from Rule s where s.sbiDomain.valueId = :typeId");
			query.setParameter("typeId", domainType.getValueId());
	        result = query.getResultList();
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;
			}
	}

	public Rule retrieveCEPRuleByEventId(Double eventId) throws Exception {
		Rule result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
			Query query = em.createQuery("select s from Rule s where s.event.eventId = :eventId");
			query.setParameter("eventId", eventId);
	        result = (Rule) query.getSingleResult();
	        
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		} finally {
			em.close();
			return result;
			}
	}

	public List<EventAttribute> getAttributesByEventId(Double EventId) throws Exception{
		List<EventAttribute> result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
	        result = new ArrayList<EventAttribute>();
			Query query = em.createQuery("select e from EventAttribute e " +
					"where e.ebamEvent.eventId= :idEvent" );
			query.setParameter("idEvent", EventId);
			result = query.getResultList();  
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.close();
			return result;
			}
		
	} 
	
	public Event getEventbyId(Double idEvent)throws Exception{
		Event result = null;
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		try {
			Query query = em.createQuery("select e from Event e " +
					"where e.eventId= :idEvent" );
			query.setParameter("idEvent", idEvent);
			result = (Event) query.getSingleResult();  
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		} finally {
			em.close();
			return result;
			}
		
	}

	public void storeOnEventContent(EventAttribute n, String value) throws Exception {
		
		
		em = getEMF().createEntityManager();
		em.getTransaction().begin();
		// Set the flush-mode so the manager query does not force a
		// write before the read.
		em.setFlushMode(FlushModeType.COMMIT);
		try {
	        //create a new EventJournal to store on Db
			EventJournal ev = new EventJournal();
	        ev.setEvent(n.getEbamEvent());
	        ev.setTimestamp(new Date());
	        em.persist(ev);
	        em.flush();
	        
	        //create an event content to store on DB connected with 
	        //event journal and event attribute
	        
			EventContent eventContent = new EventContent();
	        eventContent.setEbamEventAttribute(n);
	        eventContent.setEbamEventJournal(ev);
	        eventContent.setName(n.getName());
	        eventContent.setValue(value);
	        em.persist(eventContent);
	        em.flush();
		
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			em.getTransaction().commit();
			em.close();
			
			}
		
		// TODO Auto-generated method stub
		
	}
	
}
