/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.NullAttributeOverrideColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceColumnAnnotation;
import org.eclipse.jpt.core.internal.resource.java.source.SourceOverrideAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableAttributeOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.NestableColumnAnnotation;
import org.eclipse.jpt.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;

public final class SourceAttributeOverrideAnnotation
extends SourceOverrideAnnotation
implements NestableAttributeOverrideAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.AttributeOverride");
    private final MemberAnnotationAdapter columnAdapter;
    private NestableColumnAnnotation column;

    public SourceAttributeOverrideAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
        this.columnAdapter = new MemberAnnotationAdapter(this.member, SourceColumnAnnotation.buildAttributeOverrideAnnotationAdapter(this.daa));
    }

    public String getAnnotationName() {
        return "javax.persistence.AttributeOverride";
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        if (this.columnAdapter.getAnnotation(astRoot) != null) {
            this.column = SourceColumnAnnotation.createAttributeOverrideColumn(this, this.member, this.daa);
            this.column.initialize(astRoot);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncColumn(astRoot);
    }

    protected String getNameElementName() {
        return "name";
    }

    public ColumnAnnotation getColumn() {
        return this.column;
    }

    public ColumnAnnotation getNonNullColumn() {
        return this.column != null ? this.column : new NullAttributeOverrideColumnAnnotation(this);
    }

    public NestableColumnAnnotation addColumn() {
        if (this.column != null) {
            throw new IllegalStateException("'column' element already exists: " + this.column);
        }
        this.column = SourceColumnAnnotation.createAttributeOverrideColumn(this, this.member, this.daa);
        this.column.newAnnotation();
        return this.column;
    }

    public void removeColumn() {
        if (this.column == null) {
            throw new IllegalStateException("'column' element does not exist");
        }
        this.column.removeAnnotation();
        this.column = null;
    }

    private void syncColumn(CompilationUnit astRoot) {
        if (this.columnAdapter.getAnnotation(astRoot) == null) {
            this.syncColumn_(null);
        } else if (this.column == null) {
            NestableColumnAnnotation col = SourceColumnAnnotation.createAttributeOverrideColumn(this, this.member, this.daa);
            col.initialize(astRoot);
            this.syncColumn_(col);
        } else {
            this.column.synchronizeWith(astRoot);
        }
    }

    private void syncColumn_(NestableColumnAnnotation astColumn) {
        NestableColumnAnnotation old = this.column;
        this.column = astColumn;
        this.firePropertyChanged("column", old, astColumn);
    }

    public void initializeFrom(NestableAnnotation oldAnnotation) {
        super.initializeFrom(oldAnnotation);
        AttributeOverrideAnnotation oldOverride = (AttributeOverrideAnnotation)((Object)oldAnnotation);
        ColumnAnnotation oldColumn = oldOverride.getColumn();
        if (oldColumn != null) {
            NestableColumnAnnotation newColumn = this.addColumn();
            newColumn.initializeFrom((NestableAnnotation)((Object)oldColumn));
        }
    }

    public static SourceAttributeOverrideAnnotation buildAttributeOverride(JavaResourceNode parent, Member member) {
        return new SourceAttributeOverrideAnnotation(parent, member, DECLARATION_ANNOTATION_ADAPTER, (AnnotationAdapter)new MemberAnnotationAdapter(member, DECLARATION_ANNOTATION_ADAPTER));
    }

    static SourceAttributeOverrideAnnotation buildNestedAttributeOverride(JavaResourceNode parent, Member member, int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        IndexedDeclarationAnnotationAdapter idaa = SourceAttributeOverrideAnnotation.buildNestedDeclarationAnnotationAdapter(index, attributeOverridesAdapter);
        MemberIndexedAnnotationAdapter annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        return new SourceAttributeOverrideAnnotation(parent, member, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)annotationAdapter);
    }

    private static IndexedDeclarationAnnotationAdapter buildNestedDeclarationAnnotationAdapter(int index, DeclarationAnnotationAdapter attributeOverridesAdapter) {
        return new NestedIndexedDeclarationAnnotationAdapter(attributeOverridesAdapter, index, "javax.persistence.AttributeOverride");
    }
}

