/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa2.context.java;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BaseColumn;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.CollectionMapping;
import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Embeddable;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.RelationshipReference;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaBaseColumn;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaConverter;
import org.eclipse.jpt.core.context.java.JavaOverrideContainer;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.MappingTools;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaAttributeMapping;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaCollectionTable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaElementCollectionMapping2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOrderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.core.jpa2.resource.java.CollectionTable2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.ElementCollection2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyClass2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.MapKeyColumn2_0Annotation;
import org.eclipse.jpt.core.resource.java.ColumnAnnotation;
import org.eclipse.jpt.core.resource.java.MapKeyAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaElementCollectionMapping2_0
extends AbstractJavaAttributeMapping<ElementCollection2_0Annotation>
implements JavaElementCollectionMapping2_0 {
    protected String specifiedTargetClass;
    protected String defaultTargetClass;
    protected String fullyQualifiedTargetClass;
    protected PersistentType resolvedTargetType;
    protected Embeddable resolvedTargetEmbeddable;
    protected Entity resolvedTargetEntity;
    protected FetchType specifiedFetch;
    protected final JavaOrderable2_0 orderable = this.getJpaFactory().buildJavaOrderable(this, this.buildOrderableOwner());
    protected final JavaCollectionTable2_0 collectionTable = this.getJpaFactory().buildJavaCollectionTable(this);
    protected CollectionMapping.Type valueType;
    protected final JavaColumn valueColumn;
    protected JavaConverter valueConverter;
    protected final JavaConverter nullConverter;
    protected final JavaAttributeOverrideContainer valueAttributeOverrideContainer;
    protected final JavaAssociationOverrideContainer valueAssociationOverrideContainer;
    protected CollectionMapping.Type keyType;
    protected String specifiedMapKey;
    protected boolean noMapKey = false;
    protected boolean pkMapKey = false;
    protected boolean customMapKey = false;
    protected String specifiedMapKeyClass;
    protected String defaultMapKeyClass;
    protected String fullyQualifiedMapKeyClass;
    protected PersistentType resolvedMapKeyType;
    protected Embeddable resolvedMapKeyEmbeddable;
    protected Entity resolvedMapKeyEntity;
    protected final JavaColumn mapKeyColumn;
    protected final JavaAttributeOverrideContainer mapKeyAttributeOverrideContainer;

    protected AbstractJavaElementCollectionMapping2_0(JavaPersistentAttribute parent) {
        super(parent);
        this.valueColumn = this.getJpaFactory().buildJavaColumn(parent, new ValueColumnOwner());
        this.valueConverter = this.nullConverter = this.getJpaFactory().buildJavaNullConverter(this);
        this.valueAttributeOverrideContainer = this.getJpaFactory().buildJavaAttributeOverrideContainer(this, new ValueAttributeOverrideContainerOwner());
        this.valueAssociationOverrideContainer = this.getJpaFactory().buildJavaAssociationOverrideContainer(this, (JavaAssociationOverrideContainer.Owner)new ValueAssociationOverrideContainerOwner());
        this.mapKeyColumn = this.getJpaFactory().buildJavaMapKeyColumn(parent, new MapKeyColumnOwner());
        this.mapKeyAttributeOverrideContainer = this.getJpaFactory().buildJavaAttributeOverrideContainer(this, new MapKeyAttributeOverrideContainerOwner());
    }

    @Override
    protected JpaFactory2_0 getJpaFactory() {
        return (JpaFactory2_0)super.getJpaFactory();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.specifiedFetch = this.getResourceFetch();
        this.orderable.initialize();
        this.defaultTargetClass = this.buildDefaultTargetClass();
        this.specifiedTargetClass = this.getResourceTargetClass();
        this.fullyQualifiedTargetClass = this.buildFullyQualifiedTargetClass();
        this.resolvedTargetType = this.buildResolvedTargetType();
        this.resolvedTargetEmbeddable = this.buildResolvedTargetEmbeddable();
        this.resolvedTargetEntity = this.buildResolvedTargetEntity();
        this.initializeCollectionTable();
        this.initializeValueType();
        this.initializeValueColumn();
        this.initializeValueConverter();
        this.valueAttributeOverrideContainer.initialize(this.getResourcePersistentAttribute());
        this.valueAssociationOverrideContainer.initialize(this.getResourcePersistentAttribute());
        this.defaultMapKeyClass = this.buildDefaultMapKeyClass();
        this.specifiedMapKeyClass = this.getResourceMapKeyClass();
        this.fullyQualifiedMapKeyClass = this.buildFullyQualifiedMapKeyClass();
        this.resolvedMapKeyType = this.buildResolvedMapKeyType();
        this.resolvedMapKeyEmbeddable = this.buildResolvedMapKeyEmbeddable();
        this.resolvedMapKeyEntity = this.buildResolvedMapKeyEntity();
        this.initializeKeyType();
        this.initializeMapKey();
        this.initializeMapKeyColumn();
        this.mapKeyAttributeOverrideContainer.initialize(this.getResourcePersistentAttribute());
    }

    @Override
    protected void update() {
        super.update();
        this.setSpecifiedFetch_(this.getResourceFetch());
        this.orderable.update();
        this.setDefaultTargetClass(this.buildDefaultTargetClass());
        this.setSpecifiedTargetClass_(this.getResourceTargetClass());
        this.setFullyQualifiedTargetClass(this.buildFullyQualifiedTargetClass());
        this.resolvedTargetType = this.buildResolvedTargetType();
        this.setResolvedTargetEmbeddable(this.buildResolvedTargetEmbeddable());
        this.updateCollectionTable();
        this.updateValueType();
        this.updateValueColumn();
        this.updateValueConverter();
        this.valueAttributeOverrideContainer.update(this.getResourcePersistentAttribute());
        this.valueAssociationOverrideContainer.update(this.getResourcePersistentAttribute());
        this.setDefaultMapKeyClass(this.buildDefaultMapKeyClass());
        this.setSpecifiedMapKeyClass_(this.getResourceMapKeyClass());
        this.setFullyQualifiedMapKeyClass(this.buildFullyQualifiedMapKeyClass());
        this.resolvedMapKeyType = this.buildResolvedMapKeyType();
        this.setResolvedMapKeyEmbeddable(this.buildResolvedMapKeyEmbeddable());
        this.setResolvedMapKeyEntity(this.buildResolvedMapKeyEntity());
        this.updateKeyType();
        this.updateMapKey();
        this.updateMapKeyColumn();
        this.mapKeyAttributeOverrideContainer.update(this.getResourcePersistentAttribute());
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.valueAssociationOverrideContainer.postUpdate();
    }

    @Override
    public Entity getEntity() {
        return this.getTypeMapping().getKey() == "entity" ? (Entity)this.getTypeMapping() : null;
    }

    @Override
    public String getKey() {
        return "elementCollection";
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.ElementCollection";
    }

    @Override
    protected void addSupportingAnnotationNamesTo(Vector<String> names) {
        super.addSupportingAnnotationNamesTo(names);
        names.add("javax.persistence.AssociationOverride");
        names.add("javax.persistence.AssociationOverrides");
        names.add("javax.persistence.AttributeOverride");
        names.add("javax.persistence.AttributeOverrides");
        names.add("javax.persistence.CollectionTable");
        names.add("javax.persistence.Column");
        names.add("javax.persistence.Enumerated");
        names.add("javax.persistence.Lob");
        names.add("javax.persistence.MapKey");
        names.add("javax.persistence.MapKeyClass");
        names.add("javax.persistence.MapKeyColumn");
        names.add("javax.persistence.MapKeyEnumerated");
        names.add("javax.persistence.MapKeyJoinColumn");
        names.add("javax.persistence.MapKeyJoinColumns");
        names.add("javax.persistence.MapKeyTemporal");
        names.add("javax.persistence.OrderBy");
        names.add("javax.persistence.OrderColumn");
        names.add("javax.persistence.Temporal");
    }

    @Override
    public String getTargetClass() {
        return this.specifiedTargetClass != null ? this.specifiedTargetClass : this.defaultTargetClass;
    }

    @Override
    public String getSpecifiedTargetClass() {
        return this.specifiedTargetClass;
    }

    @Override
    public void setSpecifiedTargetClass(String targetClass) {
        String old = this.specifiedTargetClass;
        this.specifiedTargetClass = targetClass;
        ((ElementCollection2_0Annotation)this.mappingAnnotation).setTargetClass(targetClass);
        this.firePropertyChanged("specifiedTargetClass", old, targetClass);
    }

    protected void setSpecifiedTargetClass_(String targetClass) {
        String old = this.specifiedTargetClass;
        this.specifiedTargetClass = targetClass;
        this.firePropertyChanged("specifiedTargetClass", old, targetClass);
    }

    protected String getResourceTargetClass() {
        return ((ElementCollection2_0Annotation)this.mappingAnnotation).getTargetClass();
    }

    @Override
    public String getDefaultTargetClass() {
        return this.defaultTargetClass;
    }

    protected void setDefaultTargetClass(String targetClass) {
        String old = this.defaultTargetClass;
        this.defaultTargetClass = targetClass;
        this.firePropertyChanged("defaultTargetClass", old, targetClass);
    }

    protected String buildDefaultTargetClass() {
        return this.getPersistentAttribute().getMultiReferenceTargetTypeName();
    }

    @Override
    public String getFullyQualifiedTargetClass() {
        return this.fullyQualifiedTargetClass;
    }

    protected void setFullyQualifiedTargetClass(String targetClass) {
        String old = this.fullyQualifiedTargetClass;
        this.fullyQualifiedTargetClass = targetClass;
        this.firePropertyChanged("fullyQualifiedTargetClass", old, targetClass);
    }

    protected String buildFullyQualifiedTargetClass() {
        return this.specifiedTargetClass == null ? this.defaultTargetClass : ((ElementCollection2_0Annotation)this.mappingAnnotation).getFullyQualifiedTargetClassName();
    }

    @Override
    public Embeddable getResolvedTargetEmbeddable() {
        return this.resolvedTargetEmbeddable;
    }

    protected void setResolvedTargetEmbeddable(Embeddable embeddable) {
        Embeddable old = this.resolvedTargetEmbeddable;
        this.resolvedTargetEmbeddable = embeddable;
        this.firePropertyChanged("resolvedTargetEmbeddable", old, embeddable);
    }

    @Override
    public PersistentType getResolvedTargetType() {
        return this.resolvedTargetType;
    }

    protected PersistentType buildResolvedTargetType() {
        return this.fullyQualifiedTargetClass == null ? null : this.getPersistenceUnit().getPersistentType(this.fullyQualifiedTargetClass);
    }

    protected Embeddable buildResolvedTargetEmbeddable() {
        if (this.resolvedTargetType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedTargetType.getMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected Entity buildResolvedTargetEntity() {
        if (this.resolvedTargetType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedTargetType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public char getTargetClassEnclosingTypeSeparator() {
        return '.';
    }

    @Override
    public FetchType getFetch() {
        return this.getSpecifiedFetch() == null ? this.getDefaultFetch() : this.getSpecifiedFetch();
    }

    @Override
    public FetchType getDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        ((ElementCollection2_0Annotation)this.mappingAnnotation).setFetch(FetchType.toJavaResourceModel(newSpecifiedFetch));
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected void setSpecifiedFetch_(FetchType newSpecifiedFetch) {
        FetchType oldFetch = this.specifiedFetch;
        this.specifiedFetch = newSpecifiedFetch;
        this.firePropertyChanged("specifiedFetch", (Object)oldFetch, (Object)newSpecifiedFetch);
    }

    protected FetchType getResourceFetch() {
        return FetchType.fromJavaResourceModel(((ElementCollection2_0Annotation)this.mappingAnnotation).getFetch());
    }

    @Override
    public JavaCollectionTable2_0 getCollectionTable() {
        return this.collectionTable;
    }

    protected void initializeCollectionTable() {
        this.collectionTable.initialize(this.getCollectionTableAnnotation());
    }

    protected void updateCollectionTable() {
        this.collectionTable.update(this.getCollectionTableAnnotation());
    }

    @Override
    public CollectionTable2_0Annotation getCollectionTableAnnotation() {
        return (CollectionTable2_0Annotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.CollectionTable");
    }

    @Override
    public JavaColumn getValueColumn() {
        return this.valueColumn;
    }

    protected void initializeValueColumn() {
        this.valueColumn.initialize(this.getColumnAnnotation());
    }

    protected void updateValueColumn() {
        this.getValueColumn().update(this.getColumnAnnotation());
    }

    public ColumnAnnotation getColumnAnnotation() {
        return (ColumnAnnotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.Column");
    }

    @Override
    public JavaConverter getConverter() {
        return this.valueConverter;
    }

    protected String getValueConverterType() {
        return this.valueConverter.getType();
    }

    @Override
    public void setConverter(String converterType) {
        if (this.valuesAreEqual(this.getValueConverterType(), converterType)) {
            return;
        }
        JavaConverter oldConverter = this.valueConverter;
        JavaConverter newConverter = this.buildConverter(converterType);
        this.valueConverter = this.nullConverter;
        if (oldConverter != null) {
            oldConverter.removeFromResourceModel();
        }
        this.valueConverter = newConverter;
        if (newConverter != null) {
            newConverter.addToResourceModel();
        }
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void setConverter(JavaConverter newConverter) {
        JavaConverter oldConverter = this.valueConverter;
        this.valueConverter = newConverter;
        this.firePropertyChanged("converter", oldConverter, newConverter);
    }

    protected void initializeValueConverter() {
        this.valueConverter = this.buildConverter(this.getResourceConverterType());
    }

    protected void updateValueConverter() {
        if (this.valuesAreEqual(this.getResourceConverterType(), this.getValueConverterType())) {
            this.getConverter().update(this.getResourcePersistentAttribute());
        } else {
            JavaConverter javaConverter = this.buildConverter(this.getResourceConverterType());
            this.setConverter(javaConverter);
        }
    }

    protected JavaConverter buildConverter(String converterType) {
        if (this.valuesAreEqual(converterType, "noConverter")) {
            return this.nullConverter;
        }
        if (this.valuesAreEqual(converterType, "enumeratedConverter")) {
            return this.getJpaFactory().buildJavaEnumeratedConverter(this, this.getResourcePersistentAttribute());
        }
        if (this.valuesAreEqual(converterType, "temporalConverter")) {
            return this.getJpaFactory().buildJavaTemporalConverter(this, this.getResourcePersistentAttribute());
        }
        return null;
    }

    protected String getResourceConverterType() {
        if (this.getResourcePersistentAttribute().getAnnotation("javax.persistence.Enumerated") != null) {
            return "enumeratedConverter";
        }
        if (this.getResourcePersistentAttribute().getAnnotation("javax.persistence.Temporal") != null) {
            return "temporalConverter";
        }
        return "noConverter";
    }

    @Override
    public JavaAttributeOverrideContainer getValueAttributeOverrideContainer() {
        return this.valueAttributeOverrideContainer;
    }

    @Override
    public JavaAssociationOverrideContainer getValueAssociationOverrideContainer() {
        return this.valueAssociationOverrideContainer;
    }

    @Override
    public JavaColumn getMapKeyColumn() {
        return this.mapKeyColumn;
    }

    protected void initializeMapKeyColumn() {
        this.mapKeyColumn.initialize(this.getMapKeyColumnAnnotation());
    }

    protected void updateMapKeyColumn() {
        this.getMapKeyColumn().update(this.getMapKeyColumnAnnotation());
    }

    public MapKeyColumn2_0Annotation getMapKeyColumnAnnotation() {
        return (MapKeyColumn2_0Annotation)this.getResourcePersistentAttribute().getNonNullAnnotation("javax.persistence.MapKeyColumn");
    }

    @Override
    public JavaAttributeOverrideContainer getMapKeyAttributeOverrideContainer() {
        return this.mapKeyAttributeOverrideContainer;
    }

    @Override
    public JavaOrderable2_0 getOrderable() {
        return this.orderable;
    }

    protected Orderable2_0.Owner buildOrderableOwner() {
        return new Orderable2_0.Owner(){

            public String getTableName() {
                return AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getName();
            }

            public Table getDbTable(String tableName) {
                return AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getDbTable();
            }
        };
    }

    @Override
    public CollectionMapping.Type getValueType() {
        return this.valueType;
    }

    protected void setValueType(CollectionMapping.Type newValueType) {
        CollectionMapping.Type old = this.valueType;
        this.valueType = newValueType;
        this.firePropertyChanged("valueType", (Object)old, (Object)newValueType);
    }

    protected void initializeValueType() {
        this.valueType = this.buildValueType();
    }

    protected void updateValueType() {
        this.setValueType(this.buildValueType());
    }

    protected CollectionMapping.Type buildValueType() {
        if (this.getResolvedTargetEmbeddable() != null) {
            return CollectionMapping.Type.EMBEDDABLE_TYPE;
        }
        if (this.resolvedTargetEntity != null) {
            return CollectionMapping.Type.ENTITY_TYPE;
        }
        if (this.getTargetClass() == null) {
            return CollectionMapping.Type.NO_TYPE;
        }
        return CollectionMapping.Type.BASIC_TYPE;
    }

    @Override
    public CollectionMapping.Type getKeyType() {
        return this.keyType;
    }

    protected void setKeyType(CollectionMapping.Type newKeyType) {
        CollectionMapping.Type old = this.keyType;
        this.keyType = newKeyType;
        this.firePropertyChanged("keyType", (Object)old, (Object)newKeyType);
    }

    protected void initializeKeyType() {
        this.keyType = this.buildKeyType();
    }

    protected void updateKeyType() {
        this.setKeyType(this.buildKeyType());
    }

    protected CollectionMapping.Type buildKeyType() {
        if (this.getResolvedMapKeyEmbeddable() != null) {
            return CollectionMapping.Type.EMBEDDABLE_TYPE;
        }
        if (this.getResolvedMapKeyEntity() != null) {
            return CollectionMapping.Type.ENTITY_TYPE;
        }
        if (this.getMapKeyClass() == null) {
            return CollectionMapping.Type.NO_TYPE;
        }
        return CollectionMapping.Type.BASIC_TYPE;
    }

    @Override
    public String getMapKey() {
        if (this.noMapKey) {
            return null;
        }
        if (this.pkMapKey) {
            return null;
        }
        if (this.customMapKey) {
            return this.specifiedMapKey;
        }
        throw new IllegalStateException("unknown map key");
    }

    @Override
    public String getSpecifiedMapKey() {
        return this.specifiedMapKey;
    }

    @Override
    public void setSpecifiedMapKey(String mapKey) {
        String old = this.specifiedMapKey;
        this.specifiedMapKey = mapKey;
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyAnnotation();
        if (mapKey == null) {
            if (mapKeyAnnotation != null) {
                this.removeMapKeyAnnotation();
            }
        } else {
            if (mapKeyAnnotation == null) {
                mapKeyAnnotation = this.addMapKeyAnnotation();
            }
            mapKeyAnnotation.setName(mapKey);
        }
        this.firePropertyChanged("specifiedMapKey", old, mapKey);
    }

    protected void setSpecifiedMapKey_(String mapKey) {
        String old = this.specifiedMapKey;
        this.specifiedMapKey = mapKey;
        this.firePropertyChanged("specifiedMapKey", old, mapKey);
    }

    protected void initializeMapKey() {
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyAnnotation();
        if (mapKeyAnnotation == null) {
            this.noMapKey = true;
        } else {
            this.specifiedMapKey = mapKeyAnnotation.getName();
            if (this.specifiedMapKey == null) {
                this.pkMapKey = true;
            } else {
                this.customMapKey = true;
            }
        }
    }

    protected void updateMapKey() {
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyAnnotation();
        if (mapKeyAnnotation == null) {
            this.setSpecifiedMapKey_(null);
            this.setNoMapKey_(true);
            this.setPkMapKey_(false);
            this.setCustomMapKey_(false);
        } else {
            String mk = mapKeyAnnotation.getName();
            this.setSpecifiedMapKey_(mk);
            this.setNoMapKey_(false);
            this.setPkMapKey_(mk == null);
            this.setCustomMapKey_(mk != null);
        }
    }

    protected MapKeyAnnotation getMapKeyAnnotation() {
        return (MapKeyAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.MapKey");
    }

    protected MapKeyAnnotation addMapKeyAnnotation() {
        return (MapKeyAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.MapKey");
    }

    protected void removeMapKeyAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.MapKey");
    }

    protected boolean mapKeyNameTouches(int pos, CompilationUnit astRoot) {
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyAnnotation();
        return mapKeyAnnotation != null && mapKeyAnnotation.nameTouches(pos, astRoot);
    }

    @Override
    public boolean isNoMapKey() {
        return this.noMapKey;
    }

    @Override
    public void setNoMapKey(boolean noMapKey) {
        boolean old = this.noMapKey;
        this.noMapKey = noMapKey;
        if (noMapKey && this.getMapKeyAnnotation() != null) {
            this.removeMapKeyAnnotation();
        }
        this.firePropertyChanged("noMapKey", old, noMapKey);
    }

    protected void setNoMapKey_(boolean noMapKey) {
        boolean old = this.noMapKey;
        this.noMapKey = noMapKey;
        this.firePropertyChanged("noMapKey", old, noMapKey);
    }

    @Override
    public boolean isPkMapKey() {
        return this.pkMapKey;
    }

    @Override
    public void setPkMapKey(boolean pkMapKey) {
        boolean old = this.pkMapKey;
        this.pkMapKey = pkMapKey;
        MapKeyAnnotation mapKeyAnnotation = this.getMapKeyAnnotation();
        if (pkMapKey) {
            if (mapKeyAnnotation == null) {
                this.addMapKeyAnnotation();
            } else {
                mapKeyAnnotation.setName(null);
            }
        }
        this.firePropertyChanged("pkMapKey", old, pkMapKey);
    }

    protected void setPkMapKey_(boolean pkMapKey) {
        boolean old = this.pkMapKey;
        this.pkMapKey = pkMapKey;
        this.firePropertyChanged("pkMapKey", old, pkMapKey);
    }

    @Override
    public boolean isCustomMapKey() {
        return this.customMapKey;
    }

    @Override
    public void setCustomMapKey(boolean customMapKey) {
        boolean old = this.customMapKey;
        this.customMapKey = customMapKey;
        if (customMapKey) {
            this.setSpecifiedMapKey("");
        }
        this.firePropertyChanged("customMapKey", old, customMapKey);
    }

    protected void setCustomMapKey_(boolean customMapKey) {
        boolean old = this.customMapKey;
        this.customMapKey = customMapKey;
        this.firePropertyChanged("customMapKey", old, customMapKey);
    }

    @Override
    public String getMapKeyClass() {
        return this.specifiedMapKeyClass != null ? this.specifiedMapKeyClass : this.defaultMapKeyClass;
    }

    @Override
    public String getSpecifiedMapKeyClass() {
        return this.specifiedMapKeyClass;
    }

    @Override
    public void setSpecifiedMapKeyClass(String mapKeyClass) {
        String old = this.specifiedMapKeyClass;
        this.specifiedMapKeyClass = mapKeyClass;
        MapKeyClass2_0Annotation mapKeyClassAnnotation = this.getMapKeyClassAnnotation();
        if (mapKeyClass == null) {
            if (mapKeyClassAnnotation != null) {
                this.removeMapKeyClassAnnotation();
            }
        } else {
            if (mapKeyClassAnnotation == null) {
                mapKeyClassAnnotation = this.addMapKeyClassAnnotation();
            }
            mapKeyClassAnnotation.setValue(mapKeyClass);
        }
        this.firePropertyChanged("specifiedMapKeyClass", old, mapKeyClass);
    }

    protected void setSpecifiedMapKeyClass_(String mapKeyClass) {
        String old = this.specifiedMapKeyClass;
        this.specifiedMapKeyClass = mapKeyClass;
        this.firePropertyChanged("specifiedMapKeyClass", old, mapKeyClass);
    }

    protected String getResourceMapKeyClass() {
        MapKeyClass2_0Annotation annotation = this.getMapKeyClassAnnotation();
        return annotation == null ? null : annotation.getValue();
    }

    @Override
    public String getDefaultMapKeyClass() {
        return this.defaultMapKeyClass;
    }

    protected void setDefaultMapKeyClass(String mapKeyClass) {
        String old = this.defaultMapKeyClass;
        this.defaultMapKeyClass = mapKeyClass;
        this.firePropertyChanged("defaultMapKeyClass", old, mapKeyClass);
    }

    protected String buildDefaultMapKeyClass() {
        return this.getPersistentAttribute().getMultiReferenceMapKeyTypeName();
    }

    @Override
    public String getFullyQualifiedMapKeyClass() {
        return this.fullyQualifiedMapKeyClass;
    }

    protected void setFullyQualifiedMapKeyClass(String mapKeyClass) {
        String old = this.fullyQualifiedMapKeyClass;
        this.fullyQualifiedMapKeyClass = mapKeyClass;
        this.firePropertyChanged("fullyQualifiedMapKeyClass", old, mapKeyClass);
    }

    protected String buildFullyQualifiedMapKeyClass() {
        return this.specifiedMapKeyClass == null ? this.defaultMapKeyClass : this.getMapKeyClassAnnotation().getFullyQualifiedClassName();
    }

    @Override
    public char getMapKeyClassEnclosingTypeSeparator() {
        return '.';
    }

    protected MapKeyClass2_0Annotation getMapKeyClassAnnotation() {
        return (MapKeyClass2_0Annotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.MapKeyClass");
    }

    protected MapKeyClass2_0Annotation addMapKeyClassAnnotation() {
        return (MapKeyClass2_0Annotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.MapKeyClass");
    }

    protected void removeMapKeyClassAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.MapKeyClass");
    }

    @Override
    public Embeddable getResolvedMapKeyEmbeddable() {
        return this.resolvedMapKeyEmbeddable;
    }

    protected void setResolvedMapKeyEmbeddable(Embeddable embeddable) {
        Embeddable old = this.resolvedMapKeyEmbeddable;
        this.resolvedMapKeyEmbeddable = embeddable;
        this.firePropertyChanged("resolvedMapKeyEmbeddable", old, embeddable);
    }

    @Override
    public Entity getResolvedMapKeyEntity() {
        return this.resolvedMapKeyEntity;
    }

    protected void setResolvedMapKeyEntity(Entity entity) {
        Entity old = this.resolvedMapKeyEntity;
        this.resolvedMapKeyEntity = entity;
        this.firePropertyChanged("resolvedMapKeyEntity", old, entity);
    }

    public PersistentType getResolvedMapKeyType() {
        return this.getResolvedMapKeyEmbeddable() == null ? null : this.getResolvedMapKeyEmbeddable().getPersistentType();
    }

    protected PersistentType buildResolvedMapKeyType() {
        return this.fullyQualifiedMapKeyClass == null ? null : this.getPersistenceUnit().getPersistentType(this.fullyQualifiedMapKeyClass);
    }

    protected Embeddable buildResolvedMapKeyEmbeddable() {
        if (this.resolvedMapKeyType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedMapKeyType.getMapping();
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected Entity buildResolvedMapKeyEntity() {
        if (this.resolvedMapKeyType == null) {
            return null;
        }
        TypeMapping typeMapping = this.resolvedMapKeyType.getMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getCollectionTable().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getValueColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getConverter().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getOrderable().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getValueAttributeOverrideContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getValueAssociationOverrideContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.mapKeyNameTouches(pos, astRoot)) {
            return this.javaCandidateMapKeyNames(filter);
        }
        result = this.getMapKeyColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getMapKeyAttributeOverrideContainer().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected Iterator<String> javaCandidateMapKeyNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateMapKeyNames(filter));
    }

    protected Iterator<String> candidateMapKeyNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateMapKeyNames(), filter);
    }

    @Override
    public Iterator<String> candidateMapKeyNames() {
        return this.allTargetEmbeddableAttributeNames();
    }

    public Iterator<String> allTargetEmbeddableAttributeNames() {
        return new CompositeIterator((Iterator)new TransformationIterator<AttributeMapping, Iterator<String>>(this.allTargetEmbeddableAttributeMappings()){

            protected Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allMappingNames() {
        return new CompositeIterator((Object)this.getName(), this.allEmbeddableAttributeMappingNames());
    }

    protected Iterator<String> allEmbeddableAttributeMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allMappingNames();
            }
        });
    }

    protected Iterator<AttributeMapping> allTargetEmbeddableAttributeMappings() {
        return this.resolvedTargetEmbeddable != null ? this.resolvedTargetEmbeddable.allAttributeMappings() : EmptyIterator.instance();
    }

    protected Iterator<AttributeMapping> embeddableAttributeMappings() {
        Embeddable targetEmbeddable = this.getResolvedTargetEmbeddable();
        if (targetEmbeddable != null && targetEmbeddable != this.getPersistentAttribute().getOwningTypeMapping()) {
            return targetEmbeddable.attributeMappings();
        }
        return EmptyIterator.instance();
    }

    @Override
    public Iterator<String> allOverrideableAttributeMappingNames() {
        return this.embeddableOverrideableAttributeMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAttributeMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAttributeMappingNames();
            }
        });
    }

    @Override
    public Iterator<String> allOverrideableAssociationMappingNames() {
        return this.embeddableOverrideableAssociationMappingNames();
    }

    protected Iterator<String> embeddableOverrideableAssociationMappingNames() {
        return this.embeddableOverrideableMappingNames(new Transformer<AttributeMapping, Iterator<String>>(){

            public Iterator<String> transform(AttributeMapping mapping) {
                return mapping.allOverrideableAssociationMappingNames();
            }
        });
    }

    protected Iterator<String> embeddableOverrideableMappingNames(Transformer<AttributeMapping, Iterator<String>> transformer) {
        return new TransformationIterator<String, String>((Iterator)new CompositeIterator((Iterator)new TransformationIterator(this.embeddableAttributeMappings(), transformer))){

            protected String transform(String next) {
                return String.valueOf(AbstractJavaElementCollectionMapping2_0.this.getName()) + '.' + next;
            }
        };
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String name) {
        AttributeMapping resolvedMapping = super.resolveAttributeMapping(name);
        if (resolvedMapping != null) {
            return resolvedMapping;
        }
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1 && this.getName().equals(name.substring(0, dotIndex))) {
            for (AttributeMapping attributeMapping : CollectionTools.iterable(this.embeddableAttributeMappings())) {
                resolvedMapping = attributeMapping.resolveAttributeMapping(name.substring(dotIndex + 1));
                if (resolvedMapping == null) continue;
                return resolvedMapping;
            }
        }
        return null;
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        int dotIndex = attributeName.indexOf(46);
        if (dotIndex != -1 && this.getName().equals(attributeName.substring(0, dotIndex))) {
            attributeName = attributeName.substring(dotIndex + 1);
            JavaAttributeOverride override = this.getValueAttributeOverrideContainer().getAttributeOverrideNamed(attributeName);
            if (override != null && !override.isVirtual()) {
                return override.getColumn();
            }
            if (this.getResolvedTargetEmbeddable() == null) {
                return null;
            }
            return this.getResolvedTargetEmbeddable().resolveOverriddenColumn(attributeName);
        }
        return null;
    }

    @Override
    protected String getMetamodelFieldTypeName() {
        return ((JavaPersistentAttribute2_0)this.getPersistentAttribute()).getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelTypeName() {
        return this.fullyQualifiedTargetClass != null ? this.fullyQualifiedTargetClass : MetamodelField.DEFAULT_TYPE_NAME;
    }

    @Override
    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        this.addMetamodelFieldMapKeyTypeArgumentNameTo(typeArgumentNames);
        super.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
    }

    protected void addMetamodelFieldMapKeyTypeArgumentNameTo(ArrayList<String> typeArgumentNames) {
        String keyTypeName = ((JavaPersistentAttribute2_0)this.getPersistentAttribute()).getMetamodelContainerFieldMapKeyTypeName();
        if (keyTypeName != null) {
            typeArgumentNames.add(keyTypeName);
        }
    }

    @Override
    public String getMetamodelFieldMapKeyTypeName() {
        return MappingTools.getMetamodelFieldMapKeyTypeName(this);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateTargetClass(messages, astRoot);
        this.validateMapKeyClass(messages, astRoot);
        this.getOrderable().validate(messages, reporter, astRoot);
        this.getCollectionTable().validate(messages, reporter, astRoot);
        this.validateValue(messages, reporter, astRoot);
        this.validateMapKey(messages, reporter, astRoot);
    }

    protected void validateValue(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.getValueType() == CollectionMapping.Type.BASIC_TYPE) {
            this.getValueColumn().validate(messages, reporter, astRoot);
            this.getConverter().validate(messages, reporter, astRoot);
        } else if (this.getValueType() == CollectionMapping.Type.EMBEDDABLE_TYPE) {
            this.getValueAttributeOverrideContainer().validate(messages, reporter, astRoot);
            this.getValueAssociationOverrideContainer().validate(messages, reporter, astRoot);
        }
    }

    protected void validateMapKey(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.getMapKey() != null) {
            return;
        }
        if (this.getKeyType() == CollectionMapping.Type.BASIC_TYPE) {
            this.getMapKeyColumn().validate(messages, reporter, astRoot);
        } else if (this.getKeyType() != CollectionMapping.Type.ENTITY_TYPE && this.getKeyType() == CollectionMapping.Type.EMBEDDABLE_TYPE) {
            this.getMapKeyAttributeOverrideContainer().validate(messages, reporter, astRoot);
        }
    }

    protected void validateTargetClass(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getTargetClass() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ELEMENT_COLLECTION_TARGET_CLASS_NOT_DEFINED", new String[0], this, this.getValidationTextRange(astRoot)));
        }
        if (this.resolvedTargetType != null && this.getResolvedTargetEmbeddable() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ELEMENT_COLLECTION_TARGET_CLASS_MUST_BE_EMBEDDABLE_OR_BASIC_TYPE", new String[]{this.getTargetClass()}, this, this.getTargetClassTextRange(astRoot)));
        }
    }

    protected void validateMapKeyClass(List<IMessage> messages, CompilationUnit astRoot) {
        if (!this.getPersistentAttribute().getJpaContainer().isMap()) {
            return;
        }
        if (this.getMapKeyClass() == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ELEMENT_COLLECTION_MAP_KEY_CLASS_NOT_DEFINED", new String[0], this, this.getValidationTextRange(astRoot)));
        }
    }

    protected TextRange getTargetClassTextRange(CompilationUnit astRoot) {
        return this.getTextRange(((ElementCollection2_0Annotation)this.mappingAnnotation).getTargetClassTextRange(astRoot), astRoot);
    }

    protected TextRange getTextRange(TextRange textRange, CompilationUnit astRoot) {
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ColumnOwner
    implements JavaBaseColumn.Owner {
        protected ColumnOwner() {
        }

        @Override
        public String getDefaultTableName() {
            return AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getName();
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractJavaElementCollectionMapping2_0.this.getTypeMapping();
        }

        @Override
        public Table getDbTable(String tableName) {
            if (AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getName() != null && AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getName().equals(tableName)) {
                return AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getDbTable();
            }
            return null;
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return !StringTools.stringsAreEqual((String)this.getDefaultTableName(), (String)tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaElementCollectionMapping2_0.this.getValidationTextRange(astRoot);
        }

        @Override
        public IMessage buildTableNotValidMessage(BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getColumnTableNotValidMessage(), new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected abstract String getColumnTableNotValidMessage();

        @Override
        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, this.getColumnUnresolvedNameMessage(), new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected abstract String getColumnUnresolvedNameMessage();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapKeyAttributeOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAttributeOverrideContainer.Owner {
        protected MapKeyAttributeOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaElementCollectionMapping2_0.this.getResolvedMapKeyEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAttributeNames();
        }

        @Override
        public String getPossiblePrefix() {
            return "key.";
        }

        @Override
        public String getWritePrefix() {
            return this.getPossiblePrefix();
        }

        @Override
        public boolean isRelevant(String overrideName) {
            if (AbstractJavaElementCollectionMapping2_0.this.getValueType() != CollectionMapping.Type.EMBEDDABLE_TYPE) {
                return true;
            }
            return overrideName.startsWith("key.");
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_MAP_KEY_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }
    }

    protected class MapKeyColumnOwner
    extends ColumnOwner {
        protected MapKeyColumnOwner() {
        }

        public String getDefaultColumnName() {
            return String.valueOf(AbstractJavaElementCollectionMapping2_0.this.getName()) + "_KEY";
        }

        protected String getColumnTableNotValidMessage() {
            return "MAP_KEY_COLUMN_TABLE_NOT_VALID";
        }

        protected String getColumnUnresolvedNameMessage() {
            return "MAP_KEY_COLUMN_UNRESOLVED_NAME";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class OverrideContainerOwner
    implements JavaOverrideContainer.Owner {
        protected OverrideContainerOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return AbstractJavaElementCollectionMapping2_0.this.getTypeMapping();
        }

        @Override
        public String getDefaultTableName() {
            return AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getName();
        }

        @Override
        public Table getDbTable(String tableName) {
            return AbstractJavaElementCollectionMapping2_0.this.getCollectionTable().getDbTable();
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return !StringTools.stringsAreEqual((String)this.getDefaultTableName(), (String)tableName);
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return AbstractJavaElementCollectionMapping2_0.this.getValidationTextRange(astRoot);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueAssociationOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAssociationOverrideContainer.Owner {
        protected ValueAssociationOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaElementCollectionMapping2_0.this.getResolvedTargetEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAssociationNames();
        }

        @Override
        public RelationshipReference resolveRelationshipReference(String associationOverrideName) {
            return MappingTools.resolveRelationshipReference(this.getOverridableTypeMapping(), associationOverrideName);
        }

        @Override
        public String getPossiblePrefix() {
            return "value.";
        }

        @Override
        public String getWritePrefix() {
            return AbstractJavaElementCollectionMapping2_0.this.getPersistentAttribute().getJpaContainer().isMap() ? this.getPossiblePrefix() : null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            if (AbstractJavaElementCollectionMapping2_0.this.getKeyType() != CollectionMapping.Type.EMBEDDABLE_TYPE) {
                return true;
            }
            return !overrideName.startsWith("key.");
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualOverrideColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualOverrideColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnUnresolvedReferencedColumnNameMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedReferencedColumnNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedReferencedColumnNameMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_UNRESOLVED_REFERENCED_COLUMN_NAME", new String[]{overrideName, column.getReferencedColumnName(), column.getReferencedColumnDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }

        @Override
        public IMessage buildUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(AssociationOverride override, BaseJoinColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[0], column, textRange);
        }

        protected IMessage buildVirtualUnspecifiedReferencedColumnNameMultipleJoinColumnsMessage(String overrideName, BaseJoinColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ASSOCIATION_OVERRIDE_JOIN_COLUMN_REFERENCED_COLUMN_NAME_MUST_BE_SPECIFIED_MULTIPLE_JOIN_COLUMNS", new String[]{overrideName}, column, textRange);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ValueAttributeOverrideContainerOwner
    extends OverrideContainerOwner
    implements JavaAttributeOverrideContainer.Owner {
        protected ValueAttributeOverrideContainerOwner() {
        }

        @Override
        public TypeMapping getOverridableTypeMapping() {
            return AbstractJavaElementCollectionMapping2_0.this.getResolvedTargetEmbeddable();
        }

        @Override
        public Iterator<String> allOverridableNames() {
            TypeMapping typeMapping = this.getOverridableTypeMapping();
            return typeMapping == null ? EmptyIterator.instance() : typeMapping.allOverridableAttributeNames();
        }

        @Override
        public Column resolveOverriddenColumn(String attributeOverrideName) {
            return MappingTools.resolveOverridenColumn(this.getOverridableTypeMapping(), attributeOverrideName);
        }

        @Override
        public String getPossiblePrefix() {
            return "value.";
        }

        @Override
        public String getWritePrefix() {
            return AbstractJavaElementCollectionMapping2_0.this.getPersistentAttribute().getJpaContainer().isMap() ? this.getPossiblePrefix() : null;
        }

        @Override
        public boolean isRelevant(String overrideName) {
            if (AbstractJavaElementCollectionMapping2_0.this.getKeyType() != CollectionMapping.Type.EMBEDDABLE_TYPE) {
                return true;
            }
            return !overrideName.startsWith("key.");
        }

        @Override
        public IMessage buildColumnUnresolvedNameMessage(BaseOverride override, NamedColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnUnresolvedNameMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        protected IMessage buildVirtualColumnUnresolvedNameMessage(String overrideName, NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_UNRESOLVED_NAME", new String[]{overrideName, column.getName(), column.getDbTable().getName()}, column, textRange);
        }

        @Override
        public IMessage buildColumnTableNotValidMessage(BaseOverride override, BaseColumn column, TextRange textRange) {
            if (override.isVirtual()) {
                return this.buildVirtualColumnTableNotValidMessage(override.getName(), column, textRange);
            }
            return DefaultJpaValidationMessages.buildMessage(1, "COLUMN_TABLE_NOT_VALID", new String[]{column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }

        protected IMessage buildVirtualColumnTableNotValidMessage(String overrideName, BaseColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "VIRTUAL_ATTRIBUTE_OVERRIDE_COLUMN_TABLE_NOT_VALID", new String[]{overrideName, column.getTable(), column.getName(), JpaValidationDescriptionMessages.DOES_NOT_MATCH_COLLECTION_TABLE}, column, textRange);
        }
    }

    protected class ValueColumnOwner
    extends ColumnOwner {
        protected ValueColumnOwner() {
        }

        public String getDefaultColumnName() {
            return AbstractJavaElementCollectionMapping2_0.this.getName();
        }

        protected String getColumnTableNotValidMessage() {
            return "COLUMN_TABLE_NOT_VALID";
        }

        protected String getColumnUnresolvedNameMessage() {
            return "COLUMN_UNRESOLVED_NAME";
        }
    }
}

