/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.context.orm.OrmTypeMappingDefinition;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.core.jpa2.context.java.JavaPersistentType2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmPersistentType2_0;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.OrmPackage;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.resource.xml.EmfTools;
import org.eclipse.jpt.core.utility.BodySourceWriter;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.ClassName;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.jpt.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPersistentType
extends AbstractOrmXmlContextNode
implements OrmPersistentType2_0 {
    protected OrmTypeMapping mapping;
    protected AccessType defaultAccess;
    protected AccessType specifiedAccess;
    protected final Vector<OrmPersistentAttribute> specifiedAttributes = new Vector();
    protected final Vector<OrmPersistentAttribute> virtualAttributes = new Vector();
    protected PersistentType superPersistentType;
    protected String declaringTypeName;
    protected JavaPersistentType javaPersistentType;
    protected final MetamodelSourceType.Synchronizer metamodelSynchronizer;
    protected static final Comparator<OrmPersistentAttribute> ATTRIBUTE_COMPARATOR = new Comparator<OrmPersistentAttribute>(){

        @Override
        public int compare(OrmPersistentAttribute o1, OrmPersistentAttribute o2) {
            int o2Sequence;
            int o1Sequence = o1.getMapping().getXmlSequence();
            return o1Sequence == (o2Sequence = o2.getMapping().getXmlSequence()) ? 0 : (o1Sequence < o2Sequence ? -1 : 1);
        }
    };

    public GenericOrmPersistentType(EntityMappings parent, XmlTypeMapping resourceMapping) {
        super(parent);
        this.mapping = this.buildMapping(resourceMapping);
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.defaultAccess = this.buildDefaultAccess();
        this.javaPersistentType = this.buildJavaPersistentType();
        this.superPersistentType = this.buildSuperPersistentType();
        this.declaringTypeName = this.buildDeclaringTypeName();
        this.initializeAttributes();
        this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
    }

    protected MetamodelSourceType.Synchronizer buildMetamodelSynchronizer() {
        return this.isJpa2_0Compatible() ? ((JpaFactory2_0)this.getJpaFactory()).buildMetamodelSynchronizer(this) : null;
    }

    @Override
    public void update() {
        this.setSpecifiedAccess(this.buildSpecifiedAccess());
        this.setDefaultAccess(this.buildDefaultAccess());
        this.mapping.update();
        this.updateJavaPersistentType();
        this.updateSuperPersistentType();
        this.setDeclaringTypeName(this.buildDeclaringTypeName());
        this.updateAttributes();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.javaPersistentType != null) {
            this.javaPersistentType.postUpdate();
        }
        this.mapping.postUpdate();
        for (PersistentAttribute persistentAttribute : this.getAttributes()) {
            persistentAttribute.postUpdate();
        }
    }

    @Override
    public String getName() {
        String name = this.mapping.getClass_();
        return name == null ? null : name.replace('$', '.');
    }

    @Override
    public String getShortName() {
        String className = this.getName();
        return StringTools.stringIsEmpty((String)className) ? null : ClassName.getSimpleName((String)className);
    }

    @Override
    public OrmTypeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public void setMappingKey(String newMappingKey) {
        if (this.valuesAreEqual(this.getMappingKey(), newMappingKey)) {
            return;
        }
        OrmTypeMapping oldMapping = this.mapping;
        OrmTypeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getOrmTypeMappingDefinition(newMappingKey);
        XmlTypeMapping resourceTypeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        this.mapping = this.buildMapping(resourceTypeMapping);
        this.getEntityMappings().changeMapping(this, oldMapping, this.mapping);
        this.firePropertyChanged("mapping", oldMapping, this.mapping);
    }

    protected OrmTypeMapping buildMapping(XmlTypeMapping resourceMapping) {
        OrmTypeMappingDefinition mappingDefintion = this.getMappingFileDefinition().getOrmTypeMappingDefinition(resourceMapping.getMappingKey());
        return mappingDefintion.buildContextMapping(this, resourceMapping, this.getXmlContextNodeFactory());
    }

    @Override
    public AccessType getAccess() {
        return this.specifiedAccess != null ? this.specifiedAccess : this.defaultAccess;
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType defaultAccess) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = defaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)defaultAccess);
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType specifiedAccess) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = specifiedAccess;
        this.getResourceTypeMapping().setAccess(AccessType.toOrmResourceModel(specifiedAccess));
        this.firePropertyChanged("specifiedAccess", (Object)old, (Object)specifiedAccess);
    }

    protected AccessType buildDefaultAccess() {
        AccessType access;
        if (!this.mapping.isMetadataComplete() && this.javaPersistentType != null) {
            if (this.javaPersistentTypeHasSpecifiedAccess()) {
                return this.javaPersistentType.getAccess();
            }
            if (this.superPersistentType != null) {
                return this.superPersistentType.getAccess();
            }
        }
        return (access = this.getMappingFileRoot().getAccess()) != null ? access : AccessType.FIELD;
    }

    protected boolean javaPersistentTypeHasSpecifiedAccess() {
        return this.javaPersistentType.getSpecifiedAccess() != null || this.javaPersistentType.hasAnyAnnotatedAttributes();
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getEntityMappings().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getEntityMappings().getDefaultPersistentTypeAccess();
    }

    protected AccessType buildSpecifiedAccess() {
        return AccessType.fromOrmResourceModel(this.getResourceTypeMapping().getAccess());
    }

    @Override
    public ListIterator<OrmPersistentAttribute> attributes() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributes(), this.virtualAttributes()});
    }

    protected Iterable<OrmPersistentAttribute> getAttributes() {
        return new CompositeIterable(new Iterable[]{this.getSpecifiedAttributes(), this.getVirtualAttributes()});
    }

    @Override
    public int attributesSize() {
        return this.specifiedAttributesSize() + this.virtualAttributesSize();
    }

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    protected Iterator<OrmPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<OrmPersistentAttribute>(this.attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                return Tools.valuesAreEqual((Object)attributeName, (Object)o.getName());
            }
        };
    }

    @Override
    public OrmPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<OrmPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<OrmPersistentAttribute> attributes = this.attributesNamed(attributeName);
        if (attributes.hasNext()) {
            OrmPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        return this.superPersistentType == null ? null : this.superPersistentType.resolveAttribute(attributeName);
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    protected void initializeAttributes() {
        this.initializeSpecifiedAttributes();
        this.initializeVirtualAttributes();
    }

    protected void updateAttributes() {
        this.updateSpecifiedAttributes();
        this.updateVirtualAttributes();
    }

    protected Iterator<JavaResourcePersistentAttribute> javaPersistentAttributes() {
        return this.javaPersistentType == null ? EmptyListIterator.instance() : this.javaPersistentAttributes(this.javaPersistentType.getResourcePersistentType());
    }

    protected Iterator<JavaResourcePersistentAttribute> javaPersistentAttributes(JavaResourcePersistentType resourcePersistentType) {
        AccessType access = this.specifiedAccess;
        if (access == null && !this.mapping.isMetadataComplete()) {
            access = this.getJavaPersistentType().getSpecifiedAccess();
        }
        if (access == null) {
            access = this.defaultAccess;
        }
        return resourcePersistentType.persistableAttributes(AccessType.toJavaResourceModel(access));
    }

    @Override
    public ListIterator<OrmPersistentAttribute> specifiedAttributes() {
        return new CloneListIterator(this.specifiedAttributes);
    }

    protected Iterable<OrmPersistentAttribute> getSpecifiedAttributes() {
        return new LiveCloneIterable(this.specifiedAttributes);
    }

    @Override
    public int specifiedAttributesSize() {
        return this.specifiedAttributes.size();
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourcePersistentAttribute jrpa) {
        for (OrmPersistentAttribute attribute : this.getSpecifiedAttributes()) {
            JavaPersistentAttribute javaAttribute = attribute.getJavaPersistentAttribute();
            if (javaAttribute == null || javaAttribute.getResourcePersistentAttribute() != jrpa) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public OrmPersistentAttribute addSpecifiedAttribute(String mappingKey, String attributeName) {
        Attributes resourceAttributes = this.getResourceAttributes();
        if (resourceAttributes == null) {
            resourceAttributes = this.createResourceAttributes();
            this.mapping.getResourceTypeMapping().setAttributes(resourceAttributes);
        }
        OrmAttributeMappingDefinition mappingDefintion = this.getMappingFileDefinition().getOrmAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping resourceMapping = mappingDefintion.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentAttribute persistentAttribute = this.buildSpecifiedAttribute(resourceMapping);
        int index = this.getSpecifiedAttributeInsertionIndex(persistentAttribute);
        this.specifiedAttributes.add(index, persistentAttribute);
        persistentAttribute.getMapping().addToResourceModel(resourceAttributes);
        persistentAttribute.getSpecifiedMapping().setName(attributeName);
        this.fireItemAdded("attributes", index, persistentAttribute);
        return persistentAttribute;
    }

    @Override
    public void changeMapping(OrmPersistentAttribute ormPersistentAttribute, OrmAttributeMapping oldMapping, OrmAttributeMapping newMapping) {
        int sourceIndex = this.specifiedAttributes.indexOf(ormPersistentAttribute);
        this.specifiedAttributes.remove(sourceIndex);
        oldMapping.removeFromResourceModel(this.getResourceAttributes());
        int targetIndex = this.getSpecifiedAttributeInsertionIndex(ormPersistentAttribute);
        this.specifiedAttributes.add(targetIndex, ormPersistentAttribute);
        newMapping.addToResourceModel(this.getResourceAttributes());
        oldMapping.initializeOn(newMapping);
        this.fireItemMoved("attributes", targetIndex, sourceIndex);
    }

    @Override
    public void makeAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute) {
        this.makeAttributeSpecified(ormPersistentAttribute, ormPersistentAttribute.getMappingKey());
    }

    @Override
    public void makeAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute, String mappingKey) {
        if (!ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (this.valuesAreEqual(mappingKey, MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY)) {
            throw new IllegalStateException("Use makePersistentAttributeSpecified(OrmPersistentAttribute, String) instead and specify a mapping type");
        }
        Attributes resourceAttributes = this.getResourceAttributes();
        if (resourceAttributes == null) {
            resourceAttributes = this.createResourceAttributes();
            this.mapping.getResourceTypeMapping().setAttributes(resourceAttributes);
        }
        OrmAttributeMappingDefinition mappingDefintion = this.getMappingFileDefinition().getOrmAttributeMappingDefinition(mappingKey);
        XmlAttributeMapping resourceMapping = mappingDefintion.buildResourceMapping(this.getResourceNodeFactory());
        OrmPersistentAttribute newAttribute = this.buildSpecifiedAttribute(resourceMapping);
        int insertionIndex = this.getSpecifiedAttributeInsertionIndex(newAttribute);
        this.specifiedAttributes.add(insertionIndex, newAttribute);
        newAttribute.getMapping().addToResourceModel(resourceAttributes);
        int removalIndex = this.virtualAttributes.indexOf(ormPersistentAttribute);
        this.virtualAttributes.remove(ormPersistentAttribute);
        newAttribute.getSpecifiedMapping().setName(ormPersistentAttribute.getName());
        if (ormPersistentAttribute.getJavaPersistentAttribute().getSpecifiedAccess() != null) {
            newAttribute.setSpecifiedAccess(ormPersistentAttribute.getJavaPersistentAttribute().getSpecifiedAccess());
        }
        this.fireItemAdded("attributes", insertionIndex, newAttribute);
        this.fireItemRemoved("virtualAttributes", removalIndex, ormPersistentAttribute);
    }

    protected int getSpecifiedAttributeInsertionIndex(OrmPersistentAttribute specifiedAttribute) {
        return CollectionTools.insertionIndexOf(this.specifiedAttributes, (Object)specifiedAttribute, this.getAttributeComparator());
    }

    protected Comparator<OrmPersistentAttribute> getAttributeComparator() {
        return ATTRIBUTE_COMPARATOR;
    }

    protected Attributes getResourceAttributes() {
        return this.getResourceTypeMapping().getAttributes();
    }

    protected Attributes createResourceAttributes() {
        return EmfTools.create(this.getResourceNodeFactory(), OrmPackage.eINSTANCE.getAttributes(), Attributes.class);
    }

    protected void initializeSpecifiedAttributes() {
        Attributes attributes = this.getResourceAttributes();
        if (attributes == null) {
            return;
        }
        for (XmlAttributeMapping resourceMapping : attributes.getAttributeMappings()) {
            this.addSpecifiedAttribute(resourceMapping);
        }
    }

    protected void updateSpecifiedAttributes() {
        Attributes attributes = this.getResourceAttributes();
        HashBag contextAttributesToRemove = CollectionTools.collection(this.specifiedAttributes());
        ArrayList<OrmPersistentAttribute> contextAttributesToUpdate = new ArrayList<OrmPersistentAttribute>();
        int resourceIndex = 0;
        if (attributes != null) {
            for (XmlAttributeMapping resourceMapping : attributes.getAttributeMappings()) {
                boolean contextAttributeFound = false;
                for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
                    if (contextAttribute.getMapping().getResourceAttributeMapping() != resourceMapping) continue;
                    this.moveSpecifiedAttribute_(resourceIndex, contextAttribute);
                    contextAttributesToRemove.remove(contextAttribute);
                    contextAttributesToUpdate.add(contextAttribute);
                    contextAttributeFound = true;
                    break;
                }
                if (!contextAttributeFound) {
                    OrmPersistentAttribute ormPersistentAttribute = this.addSpecifiedAttribute(resourceMapping);
                    this.fireItemAdded("attributes", this.specifiedAttributesSize(), ormPersistentAttribute);
                }
                ++resourceIndex;
            }
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeSpecifiedAttribute_(contextAttribute);
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected void removeSpecifiedAttribute_(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.specifiedAttributes, "attributes");
    }

    protected OrmPersistentAttribute addSpecifiedAttribute(XmlAttributeMapping resourceMapping) {
        OrmPersistentAttribute ormPersistentAttribute = this.buildSpecifiedAttribute(resourceMapping);
        this.specifiedAttributes.add(ormPersistentAttribute);
        return ormPersistentAttribute;
    }

    protected void moveSpecifiedAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, this.specifiedAttributes.indexOf(attribute), this.specifiedAttributes, "attributes");
    }

    @Override
    public void removeSpecifiedAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        int index = this.specifiedAttributes.indexOf(ormPersistentAttribute);
        this.specifiedAttributes.remove(ormPersistentAttribute);
        ormPersistentAttribute.getMapping().removeFromResourceModel(this.getResourceAttributes());
        if (this.getResourceAttributes().isUnset()) {
            this.mapping.getResourceTypeMapping().setAttributes(null);
        }
        this.fireItemRemoved("attributes", index, ormPersistentAttribute);
    }

    protected OrmPersistentAttribute buildSpecifiedAttribute(XmlAttributeMapping resourceMapping) {
        return this.buildOrmPersistentAttribute(this.buildSpecifiedAttributeOwner(), resourceMapping);
    }

    protected OrmPersistentAttribute.Owner buildSpecifiedAttributeOwner() {
        return new SpecifiedAttributeOwner();
    }

    protected JavaPersistentAttribute buildJavaPersistentAttribute(JavaResourcePersistentAttribute jrpa) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this, jrpa);
    }

    @Override
    public ListIterator<OrmPersistentAttribute> virtualAttributes() {
        return new CloneListIterator(this.virtualAttributes);
    }

    protected Iterable<OrmPersistentAttribute> getVirtualAttributes() {
        return new LiveCloneIterable(this.virtualAttributes);
    }

    @Override
    public int virtualAttributesSize() {
        return this.virtualAttributes.size();
    }

    protected void addVirtualAttribute(OrmPersistentAttribute virtualAttribute) {
        this.addItemToList(virtualAttribute, this.virtualAttributes, "virtualAttributes");
    }

    protected void removeVirtualAttribute(OrmPersistentAttribute virtualAttribute) {
        this.removeItemFromList(virtualAttribute, this.virtualAttributes, "virtualAttributes");
    }

    @Override
    public boolean containsVirtualAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        return this.virtualAttributes.contains(ormPersistentAttribute);
    }

    @Override
    public void makeAttributeVirtual(OrmPersistentAttribute ormPersistentAttribute) {
        if (ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        JavaPersistentAttribute javaPersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute();
        OrmPersistentAttribute virtualAttribute = null;
        if (javaPersistentAttribute != null) {
            virtualAttribute = this.addVirtualAttribute(javaPersistentAttribute.getResourcePersistentAttribute());
        }
        this.removeSpecifiedAttribute(ormPersistentAttribute);
        if (virtualAttribute != null) {
            this.fireItemAdded("virtualAttributes", this.virtualAttributesSize() - 1, virtualAttribute);
        }
    }

    protected void initializeVirtualAttributes() {
        Iterator<JavaResourcePersistentAttribute> stream = this.javaPersistentAttributes();
        while (stream.hasNext()) {
            JavaResourcePersistentAttribute javaResourceAttribute = stream.next();
            if (this.getSpecifiedAttributeFor(javaResourceAttribute) != null) continue;
            this.addVirtualAttribute(javaResourceAttribute);
        }
    }

    protected void updateVirtualAttributes() {
        HashBag contextAttributesToRemove = CollectionTools.collection(this.virtualAttributes());
        ArrayList<OrmPersistentAttribute> contextAttributesToUpdate = new ArrayList<OrmPersistentAttribute>();
        int resourceIndex = 0;
        Iterator<JavaResourcePersistentAttribute> stream = this.javaPersistentAttributes();
        while (stream.hasNext()) {
            JavaResourcePersistentAttribute javaResourceAttribute = stream.next();
            OrmPersistentAttribute specifiedAttribute = this.getSpecifiedAttributeFor(javaResourceAttribute);
            if (specifiedAttribute != null) continue;
            JavaPersistentAttribute javaAttribute = this.getJpaFactory().buildJavaPersistentAttribute(this, javaResourceAttribute);
            JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
            if (this.mapping.isMetadataComplete()) {
                javaAttributeMapping = javaAttribute.getDefaultMapping();
            }
            boolean contextAttributeFound = false;
            for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
                JavaPersistentAttribute javaPersistentAttribute = contextAttribute.getJavaPersistentAttribute();
                if (javaPersistentAttribute.getResourcePersistentAttribute() != javaResourceAttribute || !this.valuesAreEqual(contextAttribute.getMappingKey(), javaAttributeMapping.getKey())) continue;
                contextAttributesToRemove.remove(contextAttribute);
                contextAttributesToUpdate.add(contextAttribute);
                contextAttributeFound = true;
                break;
            }
            if (!contextAttributeFound) {
                OrmPersistentAttribute virtualAttribute = this.addVirtualAttribute(javaAttributeMapping);
                this.fireItemAdded("virtualAttributes", this.virtualAttributesSize() - 1, virtualAttribute);
            }
            ++resourceIndex;
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeVirtualAttribute(contextAttribute);
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected OrmPersistentAttribute addVirtualAttribute(JavaResourcePersistentAttribute resourceAttribute) {
        JavaPersistentAttribute javaAttribute = this.getJpaFactory().buildJavaPersistentAttribute(this, resourceAttribute);
        JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
        if (this.mapping.isMetadataComplete()) {
            javaAttributeMapping = javaAttribute.getDefaultMapping();
        }
        return this.addVirtualAttribute(javaAttributeMapping);
    }

    protected OrmPersistentAttribute addVirtualAttribute(JavaAttributeMapping javaAttributeMapping) {
        OrmAttributeMappingDefinition mappingDefintion = this.getMappingFileDefinition().getOrmAttributeMappingDefinition(javaAttributeMapping.getKey());
        XmlAttributeMapping resourceMapping = mappingDefintion.buildVirtualResourceMapping(this.mapping, javaAttributeMapping, this.getXmlContextNodeFactory());
        OrmPersistentAttribute virtualAttribute = this.buildVirtualOrmPersistentAttribute(javaAttributeMapping, resourceMapping);
        this.virtualAttributes.add(virtualAttribute);
        return virtualAttribute;
    }

    protected OrmPersistentAttribute buildVirtualOrmPersistentAttribute(JavaAttributeMapping javaAttributeMapping, XmlAttributeMapping resourceMapping) {
        return this.buildOrmPersistentAttribute(this.buildVirtualAttributeOwner(javaAttributeMapping.getPersistentAttribute()), resourceMapping);
    }

    protected OrmPersistentAttribute buildOrmPersistentAttribute(OrmPersistentAttribute.Owner owner, XmlAttributeMapping resourceMapping) {
        return this.getXmlContextNodeFactory().buildOrmPersistentAttribute(this, owner, resourceMapping);
    }

    protected OrmPersistentAttribute.Owner buildVirtualAttributeOwner(final JavaPersistentAttribute javaPersistentAttribute) {
        return new OrmPersistentAttribute.Owner(){

            public JavaPersistentAttribute findJavaPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
                return javaPersistentAttribute;
            }

            public void updateJavaPersistentAttribute() {
                javaPersistentAttribute.update();
            }
        };
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType javaPersistentType) {
        JavaPersistentType old = this.javaPersistentType;
        this.javaPersistentType = javaPersistentType;
        this.firePropertyChanged("javaPersistentType", old, javaPersistentType);
    }

    protected JavaPersistentType buildJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        return jrpt == null ? null : this.buildJavaPersistentType(jrpt);
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        return this.getEntityMappings().resolveJavaResourcePersistentType(this.getName());
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType(String className) {
        return this.getJpaProject().getJavaResourcePersistentType(className);
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        if (jrpt == null) {
            this.setJavaPersistentType(null);
        } else if (this.javaPersistentType == null) {
            this.setJavaPersistentType(this.buildJavaPersistentType(jrpt));
        } else {
            this.javaPersistentType.update(jrpt);
        }
    }

    @Override
    public PersistentType getSuperPersistentType() {
        return this.superPersistentType;
    }

    protected void setSuperPersistentType(PersistentType superPersistentType) {
        PersistentType old = this.superPersistentType;
        this.superPersistentType = superPersistentType;
        this.firePropertyChanged("superPersistentType", old, superPersistentType);
    }

    protected void updateSuperPersistentType() {
        PersistentType spt = this.buildSuperPersistentType();
        if (spt == null || CollectionTools.contains(spt.inheritanceHierarchy(), (Object)this)) {
            this.setSuperPersistentType(null);
        } else {
            this.setSuperPersistentType(spt);
        }
    }

    protected PersistentType buildSuperPersistentType() {
        return this.javaPersistentType == null ? null : this.javaPersistentType.getSuperPersistentType();
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return this.inheritanceHierarchyOf(this);
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return this.inheritanceHierarchyOf(this.superPersistentType);
    }

    protected Iterator<PersistentType> inheritanceHierarchyOf(PersistentType start) {
        return new ChainIterator<PersistentType>(start){

            protected PersistentType nextLink(PersistentType persistentType) {
                return persistentType.getSuperPersistentType();
            }
        };
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    protected void setDeclaringTypeName(String declaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = declaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, declaringTypeName);
    }

    protected String buildDeclaringTypeName() {
        return this.isJpa2_0Compatible() ? this.buildDeclaringTypeName_() : null;
    }

    protected String buildDeclaringTypeName_() {
        return this.javaPersistentType == null ? null : ((JavaPersistentType2_0)this.javaPersistentType).getDeclaringTypeName();
    }

    @Override
    public IFile getMetamodelFile() {
        return this.javaPersistentType == null ? null : this.metamodelSynchronizer.getFile();
    }

    public void initializeMetamodel() {
    }

    @Override
    public boolean isManaged() {
        return true;
    }

    @Override
    public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        if (this.javaPersistentType != null) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }
    }

    @Override
    public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
        if (this.javaPersistentType != null) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }

    public void disposeMetamodel() {
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentType";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentAttribute attribute : this.getSpecifiedAttributes()) {
            if (!attribute.contains(textOffset)) continue;
            return attribute;
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.mapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        AccessType accessType;
        if (this.specifiedAccess != null) {
            return this.specifiedAccess;
        }
        if (this.superPersistentType instanceof OrmPersistentType && (accessType = ((OrmPersistentType)this.superPersistentType).getSpecifiedAccess()) != null) {
            return accessType;
        }
        if (this.mapping.isMetadataComplete() && (accessType = this.getOwnerDefaultAccess()) != null) {
            return accessType;
        }
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        AccessType accessType;
        if (this.superPersistentType instanceof OrmPersistentType && (accessType = ((OrmPersistentType)this.superPersistentType).getDefaultAccess()) != null) {
            return accessType;
        }
        return this.getOwnerDefaultAccess();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
        this.validateMapping(messages, reporter);
        this.validateAttributes(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages) {
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNRESOLVED_CLASS", new String[]{this.getName()}, this, this.mapping.getClassTextRange()));
        }
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter) {
        try {
            this.mapping.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter) {
        ListIterator<OrmPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            this.validateAttribute((OrmPersistentAttribute)stream.next(), messages, reporter);
        }
    }

    protected void validateAttribute(OrmPersistentAttribute attribute, List<IMessage> messages, IReporter reporter) {
        try {
            attribute.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.mapping.getValidationTextRange();
    }

    @Override
    public EntityMappings getParent() {
        return (EntityMappings)super.getParent();
    }

    @Override
    public String getDefaultPackage() {
        return this.getEntityMappings().getPackage();
    }

    @Override
    public boolean isDefaultMetadataComplete() {
        return this.getEntityMappings().isDefaultPersistentTypeMetadataComplete();
    }

    @Override
    public boolean isFor(String typeName) {
        String className = this.getName();
        if (className == null) {
            return false;
        }
        if (className.equals(typeName)) {
            return true;
        }
        String defaultPackage = this.getDefaultPackage();
        if (defaultPackage == null) {
            return false;
        }
        return (String.valueOf(defaultPackage) + '.' + className).equals(typeName);
    }

    @Override
    public boolean contains(int textOffset) {
        return this.mapping.containsOffset(textOffset);
    }

    @Override
    public void classChanged(String oldClass, String newClass) {
        this.firePropertyChanged("name", oldClass, newClass);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    protected EntityMappings getEntityMappings() {
        return this.getParent();
    }

    protected XmlTypeMapping getResourceTypeMapping() {
        return this.mapping.getResourceTypeMapping();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedAttributeOwner
    implements OrmPersistentAttribute.Owner {
        private JavaPersistentAttribute cachedJavaPersistentAttribute;

        @Override
        public JavaPersistentAttribute findJavaPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
            if (GenericOrmPersistentType.this.javaPersistentType == null) {
                return null;
            }
            String ormName = ormPersistentAttribute.getName();
            if (ormName == null) {
                return null;
            }
            AccessType ormAccess = ormPersistentAttribute.getAccess();
            JavaPersistentAttribute javaPersistentAttribute = this.findExistingJavaPersistentAttribute(ormName);
            if (javaPersistentAttribute != null && javaPersistentAttribute.getAccess() == ormAccess) {
                this.cachedJavaPersistentAttribute = null;
                return javaPersistentAttribute;
            }
            return this.buildJavaPersistentAttribute(ormName, ormAccess);
        }

        protected JavaPersistentAttribute findExistingJavaPersistentAttribute(String attributeName) {
            return GenericOrmPersistentType.this.javaPersistentType.getAttributeNamed(attributeName);
        }

        protected JavaPersistentAttribute buildJavaPersistentAttribute(String ormName, AccessType ormAccess) {
            JavaResourcePersistentAttribute jrpa = this.getJavaResourcePersistentAttribute(this.getJavaResourcePersistentType(), ormName, ormAccess);
            if (this.cachedJavaPersistentAttribute != null && this.cachedJavaPersistentAttribute.getResourcePersistentAttribute() == jrpa) {
                return this.cachedJavaPersistentAttribute;
            }
            this.cachedJavaPersistentAttribute = jrpa == null ? null : GenericOrmPersistentType.this.buildJavaPersistentAttribute(jrpa);
            return this.cachedJavaPersistentAttribute;
        }

        protected JavaResourcePersistentType getJavaResourcePersistentType() {
            return GenericOrmPersistentType.this.javaPersistentType.getResourcePersistentType();
        }

        protected JavaResourcePersistentAttribute getJavaResourcePersistentAttribute(JavaResourcePersistentType javaResourcePersistentType, String ormName, AccessType ormAccess) {
            Iterator<JavaResourcePersistentAttribute> stream = this.attributes(javaResourcePersistentType, ormAccess);
            while (stream.hasNext()) {
                JavaResourcePersistentAttribute jrpa = stream.next();
                if (!jrpa.getName().equals(ormName)) continue;
                return jrpa;
            }
            String superclassName = javaResourcePersistentType.getSuperclassQualifiedName();
            if (superclassName == null) {
                return null;
            }
            JavaResourcePersistentType superclass = GenericOrmPersistentType.this.getJavaResourcePersistentType(superclassName);
            if (superclass == null) {
                return null;
            }
            return this.getJavaResourcePersistentAttribute(superclass, ormName, ormAccess);
        }

        protected Iterator<JavaResourcePersistentAttribute> attributes(JavaResourcePersistentType javaResourcePersistentType, AccessType ormAccess) {
            return ormAccess == AccessType.PROPERTY ? javaResourcePersistentType.persistableProperties() : javaResourcePersistentType.persistableFields();
        }

        @Override
        public void updateJavaPersistentAttribute() {
            if (this.cachedJavaPersistentAttribute != null) {
                this.cachedJavaPersistentAttribute.update();
            }
        }
    }
}

