/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.NamedColumn;
import org.eclipse.jpt.core.context.Orderable;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaNamedColumn;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.core.internal.jpa2.context.java.NullJavaOrderColumn2_0;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOrderColumn2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOrderable2_0;
import org.eclipse.jpt.core.jpa2.resource.java.OrderColumn2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.OrderByAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaOrderable
extends AbstractJavaJpaContextNode
implements JavaOrderable2_0 {
    protected String specifiedOrderBy = null;
    protected boolean noOrdering = false;
    protected boolean pkOrdering = false;
    protected boolean customOrdering = false;
    protected final Orderable.Owner owner;
    protected boolean orderColumnOrdering = false;
    protected final JavaOrderColumn2_0 orderColumn;

    public GenericJavaOrderable(JavaAttributeMapping parent, Orderable.Owner owner) {
        super(parent);
        this.owner = owner;
        this.orderColumn = this.buildOrderColumn();
    }

    @Override
    public void initialize() {
        this.initializeOrdering();
    }

    @Override
    public void update() {
        this.updateOrdering();
    }

    @Override
    public JavaAttributeMapping getParent() {
        return (JavaAttributeMapping)super.getParent();
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.getParent().getPersistentAttribute();
    }

    protected JavaResourcePersistentAttribute getResourcePersistentAttribute() {
        return this.getPersistentAttribute().getResourcePersistentAttribute();
    }

    @Override
    public String getDefaultTableName() {
        return this.getOwner().getTableName();
    }

    protected Orderable2_0.Owner getOwner() {
        return (Orderable2_0.Owner)this.owner;
    }

    @Override
    public String getSpecifiedOrderBy() {
        return this.specifiedOrderBy;
    }

    @Override
    public void setSpecifiedOrderBy(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        if (orderBy == null) {
            if (orderByAnnotation != null) {
                this.removeOrderByAnnotation();
            }
        } else {
            if (orderByAnnotation == null) {
                orderByAnnotation = this.addOrderByAnnotation();
            }
            orderByAnnotation.setValue(orderBy);
        }
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected void setSpecifiedOrderBy_(String orderBy) {
        String old = this.specifiedOrderBy;
        this.specifiedOrderBy = orderBy;
        this.firePropertyChanged("specifiedOrderBy", old, orderBy);
    }

    protected void initializeOrdering() {
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        OrderColumn2_0Annotation orderColumnAnnotation = this.getOrderColumnAnnotation();
        if (orderByAnnotation == null && orderColumnAnnotation == null) {
            this.noOrdering = true;
        } else if (orderByAnnotation != null) {
            this.specifiedOrderBy = orderByAnnotation.getValue();
            if (this.specifiedOrderBy == null) {
                this.pkOrdering = true;
            } else {
                this.customOrdering = true;
            }
        } else {
            this.orderColumnOrdering = true;
        }
        this.orderColumn.initialize(this.getResourcePersistentAttribute());
    }

    protected void updateOrdering() {
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        OrderColumn2_0Annotation orderColumnAnnotation = this.getOrderColumnAnnotation();
        if (orderByAnnotation == null && orderColumnAnnotation == null) {
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(true);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(false);
        } else if (orderByAnnotation != null) {
            String ob = orderByAnnotation.getValue();
            this.setSpecifiedOrderBy_(ob);
            this.setNoOrdering_(false);
            this.setPkOrdering_(ob == null);
            this.setCustomOrdering_(ob != null);
            this.setOrderColumnOrdering_(false);
        } else {
            this.setSpecifiedOrderBy_(null);
            this.setNoOrdering_(false);
            this.setPkOrdering_(false);
            this.setCustomOrdering_(false);
            this.setOrderColumnOrdering_(true);
        }
        this.orderColumn.update(this.getResourcePersistentAttribute());
    }

    protected OrderByAnnotation getOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.OrderBy");
    }

    protected OrderByAnnotation addOrderByAnnotation() {
        return (OrderByAnnotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.OrderBy");
    }

    protected void removeOrderByAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.OrderBy");
    }

    @Override
    public boolean isNoOrdering() {
        return this.noOrdering;
    }

    @Override
    public void setNoOrdering(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        if (noOrdering) {
            if (this.getOrderByAnnotation() != null) {
                this.removeOrderByAnnotation();
            }
            if (this.getOrderColumnAnnotation() != null) {
                this.removeOrderColumnAnnotation();
            }
        }
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    protected void setNoOrdering_(boolean noOrdering) {
        boolean old = this.noOrdering;
        this.noOrdering = noOrdering;
        this.firePropertyChanged("noOrdering", old, noOrdering);
    }

    @Override
    public boolean isPkOrdering() {
        return this.pkOrdering;
    }

    @Override
    public void setPkOrdering(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        if (pkOrdering) {
            if (orderByAnnotation == null) {
                this.addOrderByAnnotation();
            } else {
                orderByAnnotation.setValue(null);
            }
        }
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    protected void setPkOrdering_(boolean pkOrdering) {
        boolean old = this.pkOrdering;
        this.pkOrdering = pkOrdering;
        this.firePropertyChanged("pkOrdering", old, pkOrdering);
    }

    @Override
    public boolean isCustomOrdering() {
        return this.customOrdering;
    }

    @Override
    public void setCustomOrdering(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        if (customOrdering) {
            this.setSpecifiedOrderBy("");
        }
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    protected void setCustomOrdering_(boolean customOrdering) {
        boolean old = this.customOrdering;
        this.customOrdering = customOrdering;
        this.firePropertyChanged("customOrdering", old, customOrdering);
    }

    protected JavaOrderColumn2_0 buildOrderColumn() {
        return this.isJpa2_0Compatible() ? ((JpaFactory2_0)this.getJpaFactory()).buildJavaOrderColumn(this, new OrderColumnOwner()) : new NullJavaOrderColumn2_0(this, new OrderColumnOwner());
    }

    @Override
    public boolean isOrderColumnOrdering() {
        return this.orderColumnOrdering;
    }

    @Override
    public void setOrderColumnOrdering(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        OrderColumn2_0Annotation orderColumnAnnotation = this.getOrderColumnAnnotation();
        if (orderColumnOrdering) {
            if (orderColumnAnnotation == null) {
                this.addOrderColumnAnnotation();
            }
            this.removeOrderByAnnotation();
        } else {
            this.removeOrderColumnAnnotation();
        }
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    protected void setOrderColumnOrdering_(boolean orderColumnOrdering) {
        boolean old = this.orderColumnOrdering;
        this.orderColumnOrdering = orderColumnOrdering;
        this.firePropertyChanged("orderColumnOrdering", old, orderColumnOrdering);
    }

    @Override
    public JavaOrderColumn2_0 getOrderColumn() {
        return this.orderColumn;
    }

    protected OrderColumn2_0Annotation getOrderColumnAnnotation() {
        return (OrderColumn2_0Annotation)this.getResourcePersistentAttribute().getAnnotation("javax.persistence.OrderColumn");
    }

    protected OrderColumn2_0Annotation addOrderColumnAnnotation() {
        return (OrderColumn2_0Annotation)this.getResourcePersistentAttribute().addAnnotation("javax.persistence.OrderColumn");
    }

    protected void removeOrderColumnAnnotation() {
        this.getResourcePersistentAttribute().removeAnnotation("javax.persistence.OrderColumn");
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getOrderColumn().javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getOrderByAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    protected TextRange getOrderByAnnotationTextRange(CompilationUnit astRoot) {
        OrderByAnnotation orderByAnnotation = this.getOrderByAnnotation();
        return orderByAnnotation == null ? null : orderByAnnotation.getTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.getOrderColumnAnnotation() != null && this.getOrderByAnnotation() != null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ORDER_COLUMN_AND_ORDER_BY_BOTH_SPECIFIED", new String[]{this.getPersistentAttribute().getName()}, this.getParent(), this.getOrderByAnnotationTextRange(astRoot)));
        }
        if (this.isOrderColumnOrdering()) {
            this.getOrderColumn().validate(messages, reporter, astRoot);
        }
    }

    protected class OrderColumnOwner
    implements JavaNamedColumn.Owner {
        protected OrderColumnOwner() {
        }

        public String getDefaultTableName() {
            return GenericJavaOrderable.this.getDefaultTableName();
        }

        public Table getDbTable(String tableName) {
            return GenericJavaOrderable.this.getOwner().getDbTable(tableName);
        }

        public String getDefaultColumnName() {
            return String.valueOf(GenericJavaOrderable.this.getPersistentAttribute().getName()) + "_ORDER";
        }

        public TypeMapping getTypeMapping() {
            return GenericJavaOrderable.this.getPersistentAttribute().getOwningTypeMapping();
        }

        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaOrderable.this.getValidationTextRange(astRoot);
        }

        public IMessage buildUnresolvedNameMessage(NamedColumn column, TextRange textRange) {
            return DefaultJpaValidationMessages.buildMessage(1, "ORDER_COLUMN_UNRESOLVED_NAME", new String[]{column.getName(), column.getDbTable().getName()}, column, textRange);
        }
    }
}

