/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.persistence;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.context.MappingFile;
import org.eclipse.jpt.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingFileRef
extends AbstractPersistenceXmlContextNode
implements MappingFileRef {
    protected String fileName;
    protected MappingFile mappingFile;

    protected AbstractMappingFileRef(PersistenceUnit parent, String resourceFileName) {
        super(parent);
        this.fileName = resourceFileName;
        this.mappingFile = this.buildMappingFile();
    }

    @Override
    public PersistenceUnit getParent() {
        return (PersistenceUnit)super.getParent();
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.fileName);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.persistence.mappingFileRef";
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public void dispose() {
        if (this.mappingFile != null) {
            this.mappingFile.dispose();
        }
    }

    @Override
    public boolean persistenceUnitDefaultsExists() {
        MappingFilePersistenceUnitDefaults defaults = this.getPersistenceUnitDefaults();
        return defaults != null && defaults.resourceExists();
    }

    @Override
    public MappingFilePersistenceUnitDefaults getPersistenceUnitDefaults() {
        MappingFileRoot root = this.getChildMappingFileRoot();
        return root == null ? null : root.getPersistenceUnitDefaults();
    }

    protected MappingFileRoot getChildMappingFileRoot() {
        return this.mappingFile == null ? null : this.mappingFile.getRoot();
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        return this.mappingFile == null ? null : this.mappingFile.getPersistentType(typeName);
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public MappingFile getMappingFile() {
        return this.mappingFile;
    }

    protected void setMappingFile(MappingFile mappingFile) {
        MappingFile old = this.mappingFile;
        this.mappingFile = mappingFile;
        this.firePropertyChanged("mappingFile", old, mappingFile);
    }

    protected MappingFile buildMappingFile() {
        JpaXmlResource xmlResource = this.resolveMappingFileXmlResource();
        return xmlResource == null ? null : this.buildMappingFile(xmlResource);
    }

    protected void updateMappingFile() {
        JpaXmlResource xmlResource = this.resolveMappingFileXmlResource();
        if (xmlResource == null) {
            if (this.mappingFile != null) {
                this.mappingFile.dispose();
                this.setMappingFile(null);
            }
        } else if (this.mappingFile == null) {
            this.setMappingFile(this.buildMappingFile(xmlResource));
        } else if (this.mappingFile.getXmlResource() == xmlResource) {
            this.mappingFile.update();
        } else {
            this.mappingFile.dispose();
            this.setMappingFile(this.buildMappingFile(xmlResource));
        }
    }

    protected JpaXmlResource resolveMappingFileXmlResource() {
        if (this.fileName == null) {
            return null;
        }
        JpaXmlResource xmlResource = this.getJpaProject().getMappingFileXmlResource(this.fileName);
        if (xmlResource == null) {
            return null;
        }
        if (xmlResource.isReverting()) {
            return null;
        }
        JpaResourceType resourceType = xmlResource.getResourceType();
        if (resourceType == null) {
            return null;
        }
        if (!this.getJpaPlatform().supportsResourceType(resourceType)) {
            return null;
        }
        return xmlResource;
    }

    protected MappingFile buildMappingFile(JpaXmlResource resource) {
        return this.getJpaFactory().buildMappingFile(this, resource);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.mappingFile != null ? this.mappingFile.getPersistentTypes() : EmptyIterable.instance();
    }

    protected void update() {
        this.updateMappingFile();
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.mappingFile != null) {
            this.mappingFile.postUpdate();
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.stringIsEmpty((String)this.fileName)) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_UNSPECIFIED_MAPPING_FILE", this, this.getValidationTextRange()));
            return;
        }
        if (this.mappingFile == null) {
            messages.add(this.buildMappingFileValidationMessage());
            return;
        }
        this.mappingFile.validate(messages, reporter);
    }

    protected IMessage buildMappingFileValidationMessage() {
        int severity = 1;
        IFile file = this.getPlatformFile();
        if (file.exists()) {
            JpaXmlResource xmlResource = this.getJpaProject().getMappingFileXmlResource(this.fileName);
            if (xmlResource != null && !this.getJpaPlatform().supportsResourceType(xmlResource.getResourceType())) {
                return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_UNIT_UNSUPPORTED_MAPPING_FILE_CONTENT", new String[]{file.getName()}, file);
            }
            return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_UNIT_INVALID_MAPPING_FILE", new String[]{file.getName()}, file);
        }
        return DefaultJpaValidationMessages.buildMessage(severity, "PERSISTENCE_UNIT_NONEXISTENT_MAPPING_FILE", new String[]{this.fileName}, this, this.getValidationTextRange());
    }

    protected IFile getPlatformFile() {
        return this.getJpaProject().convertToPlatformFile(this.fileName);
    }
}

