/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.context.java.JavaBaseColumn;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.core.resource.java.BaseColumnAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBaseColumn<T extends BaseColumnAnnotation>
extends AbstractJavaNamedColumn<T>
implements JavaBaseColumn {
    protected String specifiedTable;
    protected String defaultTable;
    protected Boolean specifiedUnique;
    protected Boolean specifiedNullable;
    protected Boolean specifiedInsertable;
    protected Boolean specifiedUpdatable;

    protected AbstractJavaBaseColumn(JavaJpaContextNode parent, JavaBaseColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    protected void initialize(T column) {
        super.initialize(column);
        this.defaultTable = this.buildDefaultTableName();
        this.specifiedTable = this.getResourceTable();
        this.specifiedUnique = this.getResourceUnique();
        this.specifiedNullable = this.getResourceNullable();
        this.specifiedInsertable = this.getResourceInsertable();
        this.specifiedUpdatable = this.getResourceUpdatable();
    }

    @Override
    protected void update(T column) {
        super.update(column);
        this.setDefaultTable(this.buildDefaultTableName());
        this.setSpecifiedTable_(this.getResourceTable());
        this.setSpecifiedUnique_(this.getResourceUnique());
        this.setSpecifiedNullable_(this.getResourceNullable());
        this.setSpecifiedInsertable_(this.getResourceInsertable());
        this.setSpecifiedUpdatable_(this.getResourceUpdatable());
    }

    @Override
    public JavaBaseColumn.Owner getOwner() {
        return (JavaBaseColumn.Owner)super.getOwner();
    }

    @Override
    public String getTable() {
        return this.getSpecifiedTable() == null ? this.getDefaultTable() : this.getSpecifiedTable();
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setTable(newSpecifiedTable);
        this.firePropertyChanged("specifiedTable", oldSpecifiedTable, newSpecifiedTable);
    }

    protected void setSpecifiedTable_(String newSpecifiedTable) {
        String oldSpecifiedTable = this.specifiedTable;
        this.specifiedTable = newSpecifiedTable;
        this.firePropertyChanged("specifiedTable", oldSpecifiedTable, newSpecifiedTable);
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String newDefaultTable) {
        String oldDefaultTable = this.defaultTable;
        this.defaultTable = newDefaultTable;
        this.firePropertyChanged("defaultTable", oldDefaultTable, newDefaultTable);
    }

    protected String getResourceTable() {
        return ((BaseColumnAnnotation)this.getResourceColumn()).getTable();
    }

    @Override
    public boolean tableNameIsInvalid() {
        return this.getOwner().tableNameIsInvalid(this.getTable());
    }

    @Override
    public boolean isUnique() {
        return this.getSpecifiedUnique() == null ? this.isDefaultUnique() : this.getSpecifiedUnique().booleanValue();
    }

    @Override
    public boolean isDefaultUnique() {
        return false;
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        ((BaseColumnAnnotation)this.getResourceColumn()).setUnique(newSpecifiedUnique);
        this.firePropertyChanged("specifiedUnique", oldSpecifiedUnique, newSpecifiedUnique);
    }

    protected void setSpecifiedUnique_(Boolean newSpecifiedUnique) {
        Boolean oldSpecifiedUnique = this.specifiedUnique;
        this.specifiedUnique = newSpecifiedUnique;
        this.firePropertyChanged("specifiedUnique", oldSpecifiedUnique, newSpecifiedUnique);
    }

    protected Boolean getResourceUnique() {
        return ((BaseColumnAnnotation)this.getResourceColumn()).getUnique();
    }

    @Override
    public boolean isNullable() {
        return this.getSpecifiedNullable() == null ? this.isDefaultNullable() : this.getSpecifiedNullable().booleanValue();
    }

    @Override
    public boolean isDefaultNullable() {
        return true;
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setNullable(newSpecifiedNullable);
        this.firePropertyChanged("specifiedNullable", oldSpecifiedNullable, newSpecifiedNullable);
    }

    protected void setSpecifiedNullable_(Boolean newSpecifiedNullable) {
        Boolean oldSpecifiedNullable = this.specifiedNullable;
        this.specifiedNullable = newSpecifiedNullable;
        this.firePropertyChanged("specifiedNullable", oldSpecifiedNullable, newSpecifiedNullable);
    }

    protected Boolean getResourceNullable() {
        return ((BaseColumnAnnotation)this.getResourceColumn()).getNullable();
    }

    @Override
    public boolean isInsertable() {
        return this.getSpecifiedInsertable() == null ? this.isDefaultInsertable() : this.getSpecifiedInsertable().booleanValue();
    }

    @Override
    public boolean isDefaultInsertable() {
        return true;
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setInsertable(newSpecifiedInsertable);
        this.firePropertyChanged("specifiedInsertable", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    protected void setSpecifiedInsertable_(Boolean newSpecifiedInsertable) {
        Boolean oldSpecifiedInsertable = this.specifiedInsertable;
        this.specifiedInsertable = newSpecifiedInsertable;
        this.firePropertyChanged("specifiedInsertable", oldSpecifiedInsertable, newSpecifiedInsertable);
    }

    protected Boolean getResourceInsertable() {
        return ((BaseColumnAnnotation)this.getResourceColumn()).getInsertable();
    }

    @Override
    public boolean isUpdatable() {
        return this.getSpecifiedUpdatable() == null ? this.isDefaultUpdatable() : this.getSpecifiedUpdatable().booleanValue();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return true;
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        ((BaseColumnAnnotation)this.getResourceColumn()).setUpdatable(newSpecifiedUpdatable);
        this.firePropertyChanged("specifiedUpdatable", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    protected void setSpecifiedUpdatable_(Boolean newSpecifiedUpdatable) {
        Boolean oldSpecifiedUpdatable = this.specifiedUpdatable;
        this.specifiedUpdatable = newSpecifiedUpdatable;
        this.firePropertyChanged("specifiedUpdatable", oldSpecifiedUpdatable, newSpecifiedUpdatable);
    }

    protected Boolean getResourceUpdatable() {
        return ((BaseColumnAnnotation)this.getResourceColumn()).getUpdatable();
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        TextRange textRange = ((BaseColumnAnnotation)this.getResourceColumn()).getTableTextRange(astRoot);
        return textRange != null ? textRange : this.getOwner().getValidationTextRange(astRoot);
    }

    public boolean tableTouches(int pos, CompilationUnit astRoot) {
        return ((BaseColumnAnnotation)this.getResourceColumn()).tableTouches(pos, astRoot);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return this.getOwner().candidateTableNames();
    }

    private Iterator<String> candidateTableNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateTableNames(), filter);
    }

    private Iterator<String> javaCandidateTableNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateTableNames(filter));
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos, astRoot)) {
            return this.javaCandidateTableNames(filter);
        }
        return null;
    }

    protected String buildDefaultTableName() {
        return this.getOwner().getDefaultTableName();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        if (this.validateTable(messages, astRoot)) {
            super.validate(messages, reporter, astRoot);
        }
    }

    protected boolean validateTable(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.tableNameIsInvalid()) {
            messages.add(this.getOwner().buildTableNotValidMessage(this, this.getTableTextRange(astRoot)));
            return false;
        }
        return true;
    }
}

