/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor;

import java.lang.reflect.Method;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionInitializer;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.internal.externalfile.ExternalSQLFileEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.ScrapbookExecuteSQLAction;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.ScrapbookExecuteSelectionSQLAction;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.SetConnectionInfoAction;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.AbstractConnectionInfoComposite;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoComposite2;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.ScrapbookEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.GenericSQLMatchingPairs;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.GenericSQLPairMatcher;
import org.eclipse.datatools.sqltools.sqleditor.internal.matching.IMatchingPairs;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SQLScrapbookEditor
extends SQLEditor {
    public static final String EDITOR_ID = "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor";
    private Connection _connection = null;
    private ConnectionService _conService = null;
    private DatabaseIdentifier _databaseIdentifier = null;
    private int _connid;
    private IAction _setConnectionInfoAction;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setRulerContextMenuId("#SQLScrapbookEditorRulerContext");
        this.setDocumentProvider(SqlscrapbookPlugin.getDefault().getSQLEditorDocumentProvider());
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        ISQLEditorInput newInput = null;
        if (input instanceof SQLScrapbookEditorInput) {
            newInput = (SQLScrapbookEditorInput)input;
        } else if (input instanceof IFileEditorInput) {
            newInput = new SQLScrapbookEditorInput(((IFileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((IPathEditorInput)input).getPath());
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof ILocationProvider) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((ILocationProvider)input).getPath((Object)input));
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof IAdaptable) {
            URI uri = (URI)input.getAdapter(URI.class);
            if (uri == null) {
                Class<?> clazz = input.getClass();
                try {
                    Method getURI = clazz.getMethod("getURI", null);
                    uri = (URI)getURI.invoke((Object)input, null);
                }
                catch (Exception exception) {}
            }
            if (uri != null) {
                IFileStore store = EFS.getStore((URI)uri);
                newInput = new ExternalSQLFileEditorInput(store);
            }
        }
        if (newInput == null) {
            super.doSetInput(input);
        } else {
            if (input instanceof SQLScrapbookEditorInput) {
                newInput.setEditorSite(this.getEditorSite());
            }
            super.doSetInput((IEditorInput)newInput);
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = Messages.getBundleForConstructedKeys();
        this._setConnectionInfoAction = new SetConnectionInfoAction(bundle, "SetConnectionInfo.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.attachProfileAction", this._setConnectionInfoAction);
        IActionBars bars = ((IEditorSite)this.getSite()).getActionBars();
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", (IAction)new ScrapbookExecuteSelectionSQLAction(this));
        this.markAsSelectionDependentAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", true);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", (IAction)new ScrapbookExecuteSQLAction(this));
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", this.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "org.eclipse.datatools.sqltools.sqleditor.attachProfileAction");
    }

    public void requestConnection() {
        this._setConnectionInfoAction.run();
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        this.doSetConnectionInfo(connInfo);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                AbstractConnectionInfoComposite connBar = ((ToolbarSourceViewer)SQLScrapbookEditor.this.getSV()).connBar;
                connBar.init(SQLScrapbookEditor.this.getConnectionInfo().getDatabaseVendorDefinitionId().toString(), SQLScrapbookEditor.this.getConnectionInfo().getConnectionProfileName(), SQLScrapbookEditor.this.getConnectionInfo().getDatabaseName());
                if (connBar.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo && SQLScrapbookEditor.this.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo) {
                    ((ScrapbookEditorConnectionInfo)connBar.getConnectionInfo()).setAutoCommit(((ScrapbookEditorConnectionInfo)SQLScrapbookEditor.this.getConnectionInfo()).isAuto());
                }
                connBar.refreshConnectionStatus();
            }
        });
    }

    protected void doSetConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        ISQLEditorConnectionInfo scrapbookConnInfo;
        ISQLEditorConnectionInfo preConnInfo = this.getConnectionInfo();
        ISQLEditorConnectionInfo iSQLEditorConnectionInfo = scrapbookConnInfo = connInfo instanceof ScrapbookEditorConnectionInfo ? connInfo : SQLFileUtil.getConnectionInfo4Scrapbook(connInfo);
        if (scrapbookConnInfo.encode().equals(preConnInfo.encode())) {
            super.setConnectionInfo(scrapbookConnInfo);
        } else {
            String content = this.getSV().getDocument().get();
            super.setConnectionInfo(scrapbookConnInfo);
            this.getSV().getDocument().set(content);
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                SQLScrapbookEditor.this.setTitleToolTip(SQLScrapbookEditor.this.getTitleToolTip());
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.releaseConnection();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditorInput() instanceof SQLEditorStorageEditorInput) {
            super.doSaveAs();
        }
        super.doSave(monitor);
    }

    public void doSaveAs() {
        super.doSaveAs();
        super.doSave(null);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected SQLEditor.AdaptedSourceViewer doCreateSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new ToolbarSourceViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, this.getConnectionInfo());
    }

    public void refreshConnectionStatus() {
        super.refreshConnectionStatus();
        if (this.getSV() != null) {
            ((ToolbarSourceViewer)this.getSV()).refreshConnectionStatus();
        }
    }

    public void refreshMatcher() {
        SQLDevToolsUIConfiguration sqlDevToolsConfig = SQLToolsUIFacade.getConfiguration((String)this.getDBType(), (DatabaseIdentifier)this.getDatabaseIdentifier());
        ICharacterPairMatcher matcher = sqlDevToolsConfig.getSQLEditorUIService().getSQLPairMatcher();
        if (matcher == null) {
            matcher = new GenericSQLPairMatcher((IMatchingPairs)GenericSQLMatchingPairs.getInstance());
        }
        this.setPairMatcher(matcher);
    }

    public Connection getConnection() {
        ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
        if (connInfo instanceof ScrapbookEditorConnectionInfo && ((ScrapbookEditorConnectionInfo)connInfo).isAuto()) {
            return null;
        }
        try {
            if (this._connection == null || this._connection.isClosed()) {
                this.fetchConnection();
            }
        }
        catch (SQLException e) {
            SqlscrapbookPlugin.log(e);
        }
        return this._connection;
    }

    private void fetchConnection() {
        try {
            String profileName = this.getConnectionInfo().getConnectionProfileName();
            String dbName = this.getConnectionInfo().getDatabaseName();
            this._databaseIdentifier = new DatabaseIdentifier(profileName, dbName);
            SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)this._databaseIdentifier.getProfileName());
            this._conService = f.getConnectionService();
            this._connection = this._conService.createConnection(this._databaseIdentifier, true);
            this._connid = SQLToolsFacade.getConnectionId((DatabaseIdentifier)this._databaseIdentifier, (Connection)this._connection);
            IConnectionInitializer init = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)this._databaseIdentifier).getConnectionService().getConnectionInitializer();
            if (init != null) {
                init.init(this._databaseIdentifier, this._connection);
            }
            if (this._connection != null && !this._connection.isClosed()) {
                this._connection.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            SqlscrapbookPlugin.log(e);
        }
        catch (NoSuchProfileException e) {
            SqlscrapbookPlugin.log(e);
        }
    }

    private void releaseConnection() {
        if (this._connection == null) {
            return;
        }
        try {
            if (this._conService != null) {
                if (!this._connection.isClosed()) {
                    this._connection.setAutoCommit(true);
                }
                this._conService.closeConnection(this._connection, this._connid, this._databaseIdentifier);
            }
        }
        catch (SQLException e) {
            SqlscrapbookPlugin.log(e);
        }
    }

    public class ToolbarSourceViewer
    extends SQLEditor.AdaptedSourceViewer
    implements Listener {
        private AbstractConnectionInfoComposite connBar;
        private boolean initialized;

        public ToolbarSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, ISQLEditorConnectionInfo initialConnInfo) {
            super((SQLEditor)SQLScrapbookEditor.this, parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
            this.initialized = false;
            if (initialConnInfo != null) {
                this.connBar.init(initialConnInfo);
            }
        }

        protected void createControl(Composite parent, int styles) {
            Composite fDefaultComposite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginBottom = 0;
            fDefaultComposite.setLayout((Layout)gridLayout);
            fDefaultComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.connBar = new ConnectionInfoComposite2(fDefaultComposite, Window.getDefaultOrientation(), this, null, null, 410);
            this.connBar.setLayoutData(new GridData(4, 0x1000000, true, false));
            ((GridLayout)this.connBar.getLayout()).marginWidth = 12;
            Composite textComposite = new Composite(fDefaultComposite, 0);
            textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            textComposite.setLayout((Layout)new FillLayout());
            super.createControl(textComposite, styles);
        }

        public void handleEvent(Event event) {
            String content = this.getDocument().get();
            SQLScrapbookEditor.this.doSetConnectionInfo(this.connBar.getConnectionInfo());
            this.getDocument().set(content);
            SQLScrapbookEditor.this.refreshMatcher();
        }

        public void refreshConnectionStatus() {
            if (this.connBar != null) {
                if (!this.initialized) {
                    this.connBar.init();
                    this.initialized = true;
                }
                if (this.connBar.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo && SQLScrapbookEditor.this.getConnectionInfo() instanceof ScrapbookEditorConnectionInfo) {
                    ((ScrapbookEditorConnectionInfo)this.connBar.getConnectionInfo()).setAutoCommit(((ScrapbookEditorConnectionInfo)SQLScrapbookEditor.this.getConnectionInfo()).isAuto());
                }
                this.connBar.refreshConnectionStatus();
            }
        }

        protected void handleDispose() {
            if (this.getDocument() != null && SQLScrapbookEditor.this._fSQLUpdater != null) {
                this.getDocument().removeDocumentListener((IDocumentListener)SQLScrapbookEditor.this._fSQLUpdater);
            }
            super.handleDispose();
        }
    }
}

