/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tracwiki.core;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.HeadingBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.ListBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.ParagraphBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.PreformattedBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.QuoteBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.block.TableBlock;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.phrase.DeletedPhraseModifier;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.phrase.EscapePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.phrase.MonospacePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.phrase.SimplePhraseModifier;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.BangEscapeToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.ChangesetLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.HyperlinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.LineBreakToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.MilestoneLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.ReportLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.RevisionLogReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.SourceLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.TicketAttachmentLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.TicketLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.WikiLinkReplacementToken;
import org.eclipse.mylyn.internal.wikitext.tracwiki.core.token.WikiWordReplacementToken;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.token.ImpliedHyperlinkReplacementToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracWikiLanguage
extends AbstractMarkupLanguage {
    private boolean autoLinking = true;
    private String serverUrl;

    public TracWikiLanguage() {
        this.setName("TracWiki");
    }

    public String toInternalHref(String pageName) {
        String pageId = pageName;
        if (pageId.startsWith("#")) {
            return pageId;
        }
        return MessageFormat.format(this.internalLinkPattern, pageId);
    }

    public String toTicketHref(String ticketId, String commentNumber) {
        String url = String.valueOf(this.serverUrl) + "ticket/" + ticketId;
        if (commentNumber != null) {
            url = String.valueOf(url) + "#comment:" + commentNumber;
        }
        return url;
    }

    public String toChangesetHref(String changesetId, String restriction) {
        String url = String.valueOf(this.serverUrl) + "changeset/" + changesetId;
        if (restriction != null) {
            url = String.valueOf(url) + "/" + restriction;
        }
        return url;
    }

    public String toRevisionLogHref(String revision1, String revision2, String restriction) {
        String url = String.valueOf(this.serverUrl) + "log/";
        if (restriction != null) {
            url = String.valueOf(url) + restriction;
        }
        url = String.valueOf(url) + "?revs=" + revision1 + "-" + revision2;
        return url;
    }

    public String toReportHref(String reportId) {
        String url = String.valueOf(this.serverUrl) + "report/" + reportId;
        return url;
    }

    public String toMilestoneHref(String milestoneId) {
        String url = String.valueOf(this.serverUrl) + "milestone/" + milestoneId;
        return url;
    }

    public String toTicketAttachmentHref(String ticketId, String attachment) {
        String url = String.valueOf(this.serverUrl) + "ticket/" + ticketId + "/" + attachment;
        return url;
    }

    public String toSourceBrowserHref(String source, String revision, String line) {
        String url = String.valueOf(this.serverUrl) + "browser";
        if (source.charAt(0) != '/') {
            url = String.valueOf(url) + '/';
        }
        url = String.valueOf(url) + source;
        if (revision != null) {
            url = String.valueOf(url) + "?rev=" + revision;
        }
        if (line != null) {
            url = String.valueOf(url) + "#L" + line;
        }
        return url;
    }

    public boolean computeInternalLinkExists(String link) {
        return true;
    }

    public boolean isAutoLinking() {
        return this.autoLinking;
    }

    public void setAutoLinking(boolean autoLinking) {
        this.autoLinking = autoLinking;
    }

    public void setServerUrl(String url) {
        if (url != null && !url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        this.serverUrl = url;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    protected void addStandardBlocks(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        ListBlock listBlock = new ListBlock();
        blocks.add(listBlock);
        paragraphBreakingBlocks.add(listBlock);
        HeadingBlock headingBlock = new HeadingBlock();
        blocks.add(headingBlock);
        paragraphBreakingBlocks.add(headingBlock);
        PreformattedBlock preformattedBlock = new PreformattedBlock();
        blocks.add(preformattedBlock);
        paragraphBreakingBlocks.add(preformattedBlock);
        QuoteBlock quoteBlock = new QuoteBlock();
        blocks.add(quoteBlock);
        paragraphBreakingBlocks.add(quoteBlock);
        TableBlock tableBlock = new TableBlock();
        blocks.add(tableBlock);
        paragraphBreakingBlocks.add(tableBlock);
    }

    protected void addStandardPhraseModifiers(MarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        phraseModifierSyntax.add((PatternBasedElement)new MonospacePhraseModifier());
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]-])|^)(?:", 0);
        phraseModifierSyntax.add((PatternBasedElement)new EscapePhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("__", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add((PatternBasedElement)new DeletedPhraseModifier());
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, true));
        phraseModifierSyntax.add((PatternBasedElement)new SimplePhraseModifier(",,", DocumentBuilder.SpanType.SUBSCRIPT, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected void addStandardTokens(MarkupLanguage.PatternBasedSyntax tokenSyntax) {
        tokenSyntax.add((PatternBasedElement)new BangEscapeToken());
        tokenSyntax.add((PatternBasedElement)new LineBreakToken());
        tokenSyntax.beginGroup("(?:(?<=[\\s\\.\\\"'?!;:\\)\\(\\{\\}\\[\\]-])|^)(?:", 0);
        tokenSyntax.add((PatternBasedElement)new RevisionLogReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ChangesetLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new HyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new TicketAttachmentLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new TicketLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new ReportLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new MilestoneLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new SourceLinkReplacementToken());
        tokenSyntax.add((PatternBasedElement)new WikiLinkReplacementToken());
        if (this.configuration == null || this.configuration.isWikiWordLinking() == null || this.configuration.isWikiWordLinking().booleanValue()) {
            tokenSyntax.add((PatternBasedElement)new WikiWordReplacementToken());
        }
        tokenSyntax.endGroup(")(?=\\W|$)", 0);
    }

    protected Block createParagraphBlock() {
        return new ParagraphBlock();
    }
}

