/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class PsfFilenameStore {
    private static final int HISTORY_LENGTH = 10;
    private static final String STORE_SECTION = "ImportPSFDialog";
    private static final String FILENAMES = "filenames";
    private static final String PREVIOUS = "previous";
    private static String _selectedFilename = null;
    private static IDialogSettings _section;
    static /* synthetic */ Class class$0;

    private PsfFilenameStore() {
    }

    public static void setDefaultFromSelection(IWorkbench workbench) {
        Object o;
        IWorkbenchWindow wnd = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage pg = wnd.getActivePage();
        ISelection sel = pg.getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Object firstElement = selection.getFirstElement();
        if (!(firstElement instanceof IAdaptable)) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)firstElement;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = iAdaptable.getAdapter((Class)clazz)) == null) {
            return;
        }
        IResource resource = (IResource)o;
        if (resource.getType() != 1) {
            return;
        }
        if (!resource.isAccessible()) {
            return;
        }
        String extension = resource.getFileExtension();
        if (extension == null || !extension.equalsIgnoreCase("psf")) {
            return;
        }
        IWorkspace workspace = resource.getWorkspace();
        workspace.getRoot().getFullPath();
        IPath path = resource.getLocation();
        _selectedFilename = path.toOSString();
    }

    public static String getSuggestedDefault() {
        if (_selectedFilename != null) {
            return _selectedFilename;
        }
        return PsfFilenameStore.getPrevious();
    }

    private static String getPrevious() {
        IDialogSettings section = PsfFilenameStore.getSettingsSection();
        String retval = section.get(PREVIOUS);
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    public static String[] getHistory() {
        IDialogSettings section = PsfFilenameStore.getSettingsSection();
        String[] arr = section.getArray(FILENAMES);
        if (arr == null) {
            arr = new String[]{};
        }
        return arr;
    }

    public static void remember(String filename) {
        Vector filenames = PsfFilenameStore.createVector(PsfFilenameStore.getHistory());
        if (filenames.contains(filename)) {
            filenames.remove(filename);
        }
        filenames.add(0, filename);
        while (filenames.size() > 10) {
            filenames.remove(10);
        }
        String[] arr = filenames.toArray(new String[filenames.size()]);
        IDialogSettings section = PsfFilenameStore.getSettingsSection();
        section.put(FILENAMES, arr);
        section.put(PREVIOUS, filename);
    }

    private static Vector createVector(Object[] arr) {
        Vector<Object> v = new Vector<Object>();
        int ix = 0;
        while (ix < arr.length) {
            v.add(ix, arr[ix]);
            ++ix;
        }
        return v;
    }

    private static IDialogSettings getSettingsSection() {
        if (_section != null) {
            return _section;
        }
        IDialogSettings settings = TeamUIPlugin.getPlugin().getDialogSettings();
        _section = settings.getSection(STORE_SECTION);
        if (_section != null) {
            return _section;
        }
        _section = settings.addNewSection(STORE_SECTION);
        return _section;
    }
}

