/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.java.search.JSPSearchSupport;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.JSPRenameUndoChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.DocumentChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.encoding.CodedStreamCreator;

public class JSPRenameChange
extends DocumentChange {
    protected IFile fJSPFile = null;
    private String fDescription;
    static /* synthetic */ Class class$0;

    public JSPRenameChange(IFile jspFile, IDocument jspDoc, TextEdit edit, String description) {
        super(JSPUIMessages.BasicRefactorSearchRequestor_6, jspDoc);
        MultiTextEdit parentEdit = new MultiTextEdit();
        parentEdit.addChild(edit);
        super.setEdit((TextEdit)parentEdit);
        this.fJSPFile = jspFile;
        this.fDescription = description;
    }

    public JSPRenameChange(JSPRenameChange originalChange) {
        super(JSPUIMessages.BasicRefactorSearchRequestor_6, originalChange.getJSPDoc());
        super.setEdit(originalChange.getEdit());
        this.fJSPFile = originalChange.fJSPFile;
        this.fDescription = originalChange.fDescription;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return new RefactoringStatus();
    }

    public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
        Document copyDoc = new Document(this.getJSPDoc().get());
        try {
            super.getEdit().apply((IDocument)copyDoc);
        }
        catch (MalformedTreeException malformedTreeException) {
        }
        catch (BadLocationException badLocationException) {}
        return copyDoc;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Object undoChange = null;
        try {
            undoChange = super.perform(pm);
            undoChange = new JSPRenameUndoChange(this, (Change)undoChange);
            JSPRenameChange.saveJSPFile(this.fJSPFile, this.getJSPDoc());
        }
        catch (MalformedTreeException e) {
            Logger.logException(e);
        }
        return undoChange;
    }

    public String getName() {
        return this.fDescription;
    }

    public Object getModifiedElement() {
        return this.fJSPFile;
    }

    protected IDocument getJSPDoc() {
        IDocument doc = null;
        try {
            doc = this.acquireDocument(null);
        }
        catch (CoreException coreException) {}
        return doc;
    }

    protected static void saveJSPFile(IFile jspFile, IDocument jspDoc) {
        final ITextEditor editor = JSPRenameChange.findOpenEditor(jspDoc);
        try {
            if (editor == null) {
                SaveJspFileOp op = new SaveJspFileOp(jspFile, jspDoc);
                op.run(JSPSearchSupport.getInstance().getProgressMonitor());
            } else {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InterruptedException {
                        editor.doSave(pm);
                    }
                };
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)editor.getSite().getWorkbenchWindow(), runnable, null);
            }
        }
        catch (InvocationTargetException e) {
            Logger.logException(e);
        }
        catch (InterruptedException e) {
            Logger.logException(e);
        }
    }

    private static ITextEditor findOpenEditor(IDocument jspDoc) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        IWorkbenchWindow w = null;
        int i = 0;
        while (i < windows.length) {
            w = windows[i];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                IEditorPart editor = null;
                Object o = null;
                IDocument doc = null;
                int j = 0;
                while (j < references.length) {
                    editor = references[j].getEditor(false);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((o = editor.getAdapter((Class)clazz)) != null && o instanceof ITextEditor && (doc = ((ITextEditor)o).getDocumentProvider().getDocument((Object)editor.getEditorInput())) != null && doc.equals(jspDoc)) {
                        return (ITextEditor)o;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    private static class SaveJspFileOp
    extends WorkspaceModifyOperation {
        private IDocument fJSPDoc = null;
        private IFile fJSPFile = null;

        public SaveJspFileOp(IFile jspFile, IDocument jspDoc) {
            this.fJSPDoc = jspDoc;
            this.fJSPFile = jspFile;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            CodedStreamCreator codedStreamCreator = new CodedStreamCreator();
            DocumentReader reader = new DocumentReader(this.fJSPDoc);
            codedStreamCreator.set(this.fJSPFile, (Reader)reader);
            ByteArrayOutputStream codedByteStream = null;
            ByteArrayInputStream codedStream = null;
            try {
                block12: {
                    try {
                        codedByteStream = codedStreamCreator.getCodedByteArrayOutputStream();
                        codedStream = new ByteArrayInputStream(codedByteStream.toByteArray());
                        if (this.fJSPFile.exists()) {
                            this.fJSPFile.setContents((InputStream)codedStream, true, true, null);
                            break block12;
                        }
                        this.fJSPFile.create((InputStream)codedStream, false, null);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                    catch (IOException e) {
                        Logger.logException(e);
                    }
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (codedByteStream != null) {
                        codedByteStream.close();
                    }
                    if (codedStream == null) throw throwable;
                    ((InputStream)codedStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {
                return;
            }
            if (codedByteStream != null) {
                codedByteStream.close();
            }
            if (codedStream == null) return;
            ((InputStream)codedStream).close();
        }
    }
}

