/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class VariableDeclarationFix
extends AbstractFix {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static IFix createChangeModifierToFinalFix(JavaScriptUnit compilationUnit, ASTNode[] selectedNodes) {
        HashMap writtenNames = new HashMap();
        WrittenNamesFinder finder = new WrittenNamesFinder(writtenNames);
        compilationUnit.accept((ASTVisitor)finder);
        ArrayList ops = new ArrayList();
        VariableDeclarationFinder visitor = new VariableDeclarationFinder(true, true, true, compilationUnit, ops, writtenNames);
        if (selectedNodes.length == 1) {
            if (selectedNodes[0] instanceof SimpleName) {
                selectedNodes[0] = selectedNodes[0].getParent();
            }
            selectedNodes[0].accept((ASTVisitor)visitor);
        } else {
            int i = 0;
            while (i < selectedNodes.length) {
                ASTNode selectedNode = selectedNodes[i];
                selectedNode.accept((ASTVisitor)visitor);
                ++i;
            }
        }
        if (ops.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] result = ops.toArray(new IFixRewriteOperation[ops.size()]);
        String label = result.length == 1 ? FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description : FixMessages.VariableDeclarationFix_ChangeMidifiersToFinalWherPossible_description;
        return new VariableDeclarationFix(label, compilationUnit, result);
    }

    public static IFix createCleanUp(JavaScriptUnit compilationUnit, boolean addFinalFields, boolean addFinalParameters, boolean addFinalLocals) {
        if (!(addFinalFields || addFinalParameters || addFinalLocals)) {
            return null;
        }
        HashMap writtenNames = new HashMap();
        WrittenNamesFinder finder = new WrittenNamesFinder(writtenNames);
        compilationUnit.accept((ASTVisitor)finder);
        ArrayList operations = new ArrayList();
        VariableDeclarationFinder visitor = new VariableDeclarationFinder(addFinalFields, addFinalParameters, addFinalLocals, compilationUnit, operations, writtenNames);
        compilationUnit.accept((ASTVisitor)visitor);
        if (operations.isEmpty()) {
            return null;
        }
        return new VariableDeclarationFix(FixMessages.VariableDeclarationFix_add_final_change_name, compilationUnit, operations.toArray(new IFixRewriteOperation[operations.size()]));
    }

    private static ModifierChangeOperation createAddFinalOperation(SimpleName name, JavaScriptUnit compilationUnit, ASTNode decl) {
        if (decl == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (!VariableDeclarationFix.canAddFinal(binding, name, decl)) {
            return null;
        }
        if (decl instanceof SingleVariableDeclaration) {
            return new ModifierChangeOperation(decl, new ArrayList(), 16, 64);
        }
        if (decl instanceof VariableDeclarationExpression) {
            return new ModifierChangeOperation(decl, new ArrayList(), 16, 64);
        }
        if (decl instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)decl;
            if ((decl = decl.getParent()) instanceof FieldDeclaration || decl instanceof VariableDeclarationStatement) {
                ArrayList<VariableDeclarationFragment> list = new ArrayList<VariableDeclarationFragment>();
                list.add(frag);
                return new ModifierChangeOperation(decl, list, 16, 64);
            }
            if (decl instanceof VariableDeclarationExpression) {
                return new ModifierChangeOperation(decl, new ArrayList(), 16, 64);
            }
        }
        return null;
    }

    private static boolean canAddFinal(IBinding binding, SimpleName name, ASTNode declNode) {
        FunctionDeclaration declaration;
        ASTNode varDecl;
        ASTNode parent;
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varbinding = (IVariableBinding)binding;
        if (Modifier.isFinal((int)varbinding.getModifiers())) {
            return false;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = ASTNodes.getParent(declNode, clazz)) != null && ((VariableDeclarationExpression)parent).fragments().size() > 1) {
            return false;
        }
        if (varbinding.isField() && !Modifier.isPrivate((int)varbinding.getModifiers())) {
            return false;
        }
        return !varbinding.isParameter() || !((varDecl = declNode.getParent()) instanceof FunctionDeclaration) || (declaration = (FunctionDeclaration)varDecl).getBody() != null;
    }

    protected VariableDeclarationFix(String name, JavaScriptUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class ModifierChangeOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ASTNode fDeclaration;
        private final List fToChange;
        private final int fIncludedModifiers;
        private final int fExcludedModifiers;

        public ModifierChangeOperation(ASTNode declaration, List toChange, int includedModifiers, int excludedModifiers) {
            this.fDeclaration = declaration;
            this.fToChange = toChange;
            this.fIncludedModifiers = includedModifiers;
            this.fExcludedModifiers = excludedModifiers;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description);
            textEditGroups.add(group);
            if (this.fDeclaration instanceof VariableDeclarationStatement) {
                VariableDeclarationFragment[] toChange = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationStatement)this.fDeclaration, toChange, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof FieldDeclaration) {
                VariableDeclarationFragment[] toChange = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((FieldDeclaration)this.fDeclaration, toChange, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof SingleVariableDeclaration) {
                VariableDeclarationRewrite.rewriteModifiers((SingleVariableDeclaration)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof VariableDeclarationExpression) {
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationExpression)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            }
        }
    }

    private static class VariableDeclarationFinder
    extends GenericVisitor {
        private final JavaScriptUnit fCompilationUnit;
        private final List fResult;
        private final HashMap fWrittenVariables;
        private final boolean fAddFinalFields;
        private final boolean fAddFinalParameters;
        private final boolean fAddFinalLocals;

        public VariableDeclarationFinder(boolean addFinalFields, boolean addFinalParameters, boolean addFinalLocals, JavaScriptUnit compilationUnit, List result, HashMap writtenNames) {
            this.fAddFinalFields = addFinalFields;
            this.fAddFinalParameters = addFinalParameters;
            this.fAddFinalLocals = addFinalLocals;
            this.fCompilationUnit = compilationUnit;
            this.fResult = result;
            this.fWrittenVariables = writtenNames;
        }

        public boolean visit(FieldDeclaration node) {
            if (this.fAddFinalFields) {
                return this.handleFragments(node.fragments(), (ASTNode)node);
            }
            return false;
        }

        public boolean visit(VariableDeclarationStatement node) {
            if (this.fAddFinalLocals) {
                return this.handleFragments(node.fragments(), (ASTNode)node);
            }
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            if (this.fAddFinalLocals && node.fragments().size() == 1) {
                SimpleName name = ((VariableDeclarationFragment)node.fragments().get(0)).getName();
                IBinding binding = name.resolveBinding();
                if (binding == null) {
                    return false;
                }
                if (this.fWrittenVariables.containsKey(binding)) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(name, this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            return false;
        }

        private boolean handleFragments(List list, ASTNode declaration) {
            ArrayList<VariableDeclarationFragment> toChange = new ArrayList<VariableDeclarationFragment>();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
                SimpleName name = fragment.getName();
                IBinding resolveBinding = name.resolveBinding();
                if (!VariableDeclarationFix.canAddFinal(resolveBinding, name, declaration)) continue;
                IVariableBinding varbinding = (IVariableBinding)resolveBinding;
                if (varbinding.isField()) {
                    if (!this.fieldCanBeFinal(fragment, varbinding)) continue;
                    toChange.add(fragment);
                    continue;
                }
                if (this.fWrittenVariables.containsKey(resolveBinding)) continue;
                toChange.add(fragment);
            }
            if (toChange.size() == 0) {
                return false;
            }
            ModifierChangeOperation op = new ModifierChangeOperation(declaration, toChange, 16, 64);
            this.fResult.add(op);
            return false;
        }

        private boolean fieldCanBeFinal(VariableDeclarationFragment fragment, IVariableBinding binding) {
            TypeDeclaration typeDecl;
            if (Modifier.isStatic((int)((FieldDeclaration)fragment.getParent()).getModifiers())) {
                return false;
            }
            if (!this.fWrittenVariables.containsKey(binding)) {
                return fragment.getInitializer() != null;
            }
            if (fragment.getInitializer() != null) {
                return false;
            }
            ITypeBinding declaringClass = binding.getDeclaringClass();
            if (declaringClass == null) {
                return false;
            }
            ArrayList writes = (ArrayList)this.fWrittenVariables.get(binding);
            if (!this.isWrittenInTypeConstructors(binding, writes, declaringClass)) {
                return false;
            }
            HashSet<IFunctionBinding> writingConstructorBindings = new HashSet<IFunctionBinding>();
            ArrayList<FunctionDeclaration> writingConstructors = new ArrayList<FunctionDeclaration>();
            int i = 0;
            while (i < writes.size()) {
                SimpleName name = (SimpleName)writes.get(i);
                FunctionDeclaration constructor = this.getWritingConstructor(name);
                if (writingConstructors.contains(constructor)) {
                    return false;
                }
                writingConstructors.add(constructor);
                IFunctionBinding constructorBinding = constructor.resolveBinding();
                if (constructorBinding == null) {
                    return false;
                }
                writingConstructorBindings.add(constructorBinding);
                ++i;
            }
            i = 0;
            while (i < writingConstructors.size()) {
                FunctionDeclaration constructor = (FunctionDeclaration)writingConstructors.get(i);
                if (this.callsWrittingConstructor(constructor, writingConstructorBindings)) {
                    return false;
                }
                ++i;
            }
            FunctionDeclaration constructor = (FunctionDeclaration)writingConstructors.get(0);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.TypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((typeDecl = (TypeDeclaration)ASTNodes.getParent((ASTNode)constructor, clazz)) == null) {
                return false;
            }
            FunctionDeclaration[] methods = typeDecl.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].isConstructor()) {
                    IFunctionBinding methodBinding = methods[i2].resolveBinding();
                    if (methodBinding == null) {
                        return false;
                    }
                    if (!writingConstructorBindings.contains(methodBinding) && !this.callsWrittingConstructor(methods[i2], writingConstructorBindings)) {
                        return false;
                    }
                }
                ++i2;
            }
            return true;
        }

        private boolean callsWrittingConstructor(FunctionDeclaration methodDeclaration, HashSet writingConstructorBindings) {
            Block body = methodDeclaration.getBody();
            if (body == null) {
                return false;
            }
            List statements = body.statements();
            if (statements.size() == 0) {
                return false;
            }
            Statement statement = (Statement)statements.get(0);
            if (!(statement instanceof ConstructorInvocation)) {
                return false;
            }
            ConstructorInvocation invocation = (ConstructorInvocation)statement;
            IFunctionBinding constructorBinding = invocation.resolveConstructorBinding();
            if (constructorBinding == null) {
                return false;
            }
            if (writingConstructorBindings.contains(constructorBinding)) {
                return true;
            }
            ASTNode declaration = ASTNodes.findDeclaration((IBinding)constructorBinding, methodDeclaration.getParent());
            if (!(declaration instanceof FunctionDeclaration)) {
                return false;
            }
            return this.callsWrittingConstructor((FunctionDeclaration)declaration, writingConstructorBindings);
        }

        private boolean isWrittenInTypeConstructors(IVariableBinding binding, ArrayList writes, ITypeBinding declaringClass) {
            int i = 0;
            while (i < writes.size()) {
                SimpleName name = (SimpleName)writes.get(i);
                FunctionDeclaration methodDeclaration = this.getWritingConstructor(name);
                if (methodDeclaration == null) {
                    return false;
                }
                if (!methodDeclaration.isConstructor()) {
                    return false;
                }
                IFunctionBinding constructor = methodDeclaration.resolveBinding();
                if (constructor == null) {
                    return false;
                }
                ITypeBinding declaringClass2 = constructor.getDeclaringClass();
                if (!declaringClass.equals((Object)declaringClass2)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private FunctionDeclaration getWritingConstructor(SimpleName name) {
            Assignment assignement;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.Assignment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((assignement = (Assignment)ASTNodes.getParent((ASTNode)name, clazz)) == null) {
                return null;
            }
            ASTNode expression = assignement.getParent();
            if (!(expression instanceof ExpressionStatement)) {
                return null;
            }
            ASTNode block = expression.getParent();
            if (!(block instanceof Block)) {
                return null;
            }
            ASTNode methodDeclaration = block.getParent();
            if (!(methodDeclaration instanceof FunctionDeclaration)) {
                return null;
            }
            return (FunctionDeclaration)methodDeclaration;
        }

        public boolean visit(VariableDeclarationFragment node) {
            SimpleName name = node.getName();
            IBinding binding = name.resolveBinding();
            if (binding == null) {
                return false;
            }
            if (this.fWrittenVariables.containsKey(binding)) {
                return false;
            }
            ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(name, this.fCompilationUnit, (ASTNode)node);
            if (op == null) {
                return false;
            }
            this.fResult.add(op);
            return false;
        }

        public boolean visit(SingleVariableDeclaration node) {
            SimpleName name = node.getName();
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return false;
            }
            IVariableBinding varBinding = (IVariableBinding)binding;
            if (this.fWrittenVariables.containsKey(varBinding)) {
                return false;
            }
            if (this.fAddFinalParameters && this.fAddFinalLocals) {
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(name, this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            if (this.fAddFinalParameters) {
                if (!varBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(name, this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            if (this.fAddFinalLocals) {
                if (varBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(name, this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            return false;
        }
    }

    private static class WrittenNamesFinder
    extends GenericVisitor {
        private final HashMap fResult;

        public WrittenNamesFinder(HashMap result) {
            this.fResult = result;
        }

        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof VariableDeclarationFragment) {
                return super.visit(node);
            }
            if (node.getParent() instanceof SingleVariableDeclaration) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return super.visit(node);
            }
            binding = ((IVariableBinding)binding).getVariableDeclaration();
            if (ASTResolving.isWriteAccess((Name)node)) {
                List<Object> list = this.fResult.containsKey(binding) ? (List)this.fResult.get(binding) : new ArrayList<SimpleName>();
                list.add(node);
                this.fResult.put(binding, list);
            }
            return super.visit(node);
        }
    }
}

