/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionEventSummary {
    private String type;
    private String name;
    private int usageCount;
    private float interestContribution;
    private String delta;
    private Set<Integer> userIds = new HashSet<Integer>();

    public InteractionEventSummary(String type, String name, int usageCount) {
        this.type = type;
        this.name = name;
        this.usageCount = usageCount;
    }

    public InteractionEventSummary() {
        this.type = "";
        this.name = "";
        this.usageCount = 0;
    }

    public InteractionEventSummary(InteractionEventSummary another) {
        this.type = another.type;
        this.name = another.name;
        this.usageCount = another.usageCount;
        this.userIds.addAll(another.getUserIds());
    }

    public void combine(InteractionEventSummary another) {
        this.usageCount += another.getUsageCount();
        this.userIds.addAll(another.getUserIds());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public void setUsageCount(int usageCount) {
        this.usageCount = usageCount;
    }

    public float getInterestContribution() {
        return this.interestContribution;
    }

    public void setInterestContribution(float interestContribution) {
        this.interestContribution = interestContribution;
    }

    public String getDelta() {
        if ("null".equals(this.delta)) {
            return "";
        }
        return this.delta;
    }

    public void setDelta(String delta) {
        this.delta = delta;
    }

    public Set<Integer> getUserIds() {
        return this.userIds;
    }

    public void setUserIds(Set<Integer> userIds) {
        this.userIds = userIds;
    }

    public void addUserId(int userId) {
        if (!this.userIds.contains(userId)) {
            this.userIds.add(userId);
        }
    }
}

