/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IWhileStatement;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class WhileStatement
extends Statement
implements IWhileStatement {
    public Expression condition;
    public Statement action;

    public WhileStatement(Expression condition, Statement action, int s, int e) {
        this.condition = condition;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo actionInfo;
        boolean isConditionOptimizedTrue;
        boolean isConditionTrue;
        Constant cst = this.condition.constant;
        boolean bl = cst == null ? false : (isConditionTrue = cst != Constant.NotAConstant && cst.booleanValue());
        boolean isConditionFalse = cst == null ? false : cst != Constant.NotAConstant && !cst.booleanValue();
        cst = this.condition.optimizedBooleanConstant();
        boolean bl2 = cst == null ? false : (isConditionOptimizedTrue = cst != Constant.NotAConstant && cst.booleanValue());
        boolean isConditionOptimizedFalse = cst == null ? false : cst != Constant.NotAConstant && !cst.booleanValue();
        FlowInfo condInfo = flowInfo.nullInfoLessUnconditionalCopy();
        LoopingFlowContext condLoopContext = new LoopingFlowContext(flowContext, flowInfo, this, currentScope);
        condInfo = this.condition.analyseCode(currentScope, condLoopContext, condInfo);
        if (this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            condLoopContext.complainOnDeferredFinalChecks(currentScope, condInfo);
            condLoopContext.complainOnDeferredNullChecks(currentScope, condInfo.unconditionalInits());
            if (isConditionTrue) {
                return FlowInfo.DEAD_END;
            }
            FlowInfo mergedInfo = flowInfo.copy().addInitializationsFrom(condInfo.initsWhenFalse());
            if (isConditionOptimizedTrue) {
                mergedInfo.setReachMode(1);
            }
            return mergedInfo;
        }
        LoopingFlowContext loopingContext = new LoopingFlowContext(flowContext, flowInfo, this, currentScope);
        if (isConditionFalse) {
            actionInfo = FlowInfo.DEAD_END;
        } else {
            actionInfo = condInfo.initsWhenTrue().copy();
            if (isConditionOptimizedFalse) {
                actionInfo.setReachMode(1);
            }
        }
        if (!this.action.complainIfUnreachable(actionInfo, currentScope, false)) {
            actionInfo = this.action.analyseCode(currentScope, loopingContext, actionInfo);
        }
        FlowInfo exitBranch = flowInfo.copy();
        if ((actionInfo.tagBits & loopingContext.initsOnContinue.tagBits & 1) != 0) {
            exitBranch.addInitializationsFrom(condInfo.initsWhenFalse());
        } else {
            condLoopContext.complainOnDeferredFinalChecks(currentScope, condInfo);
            actionInfo = actionInfo.mergedWith(loopingContext.initsOnContinue.unconditionalInits());
            condLoopContext.complainOnDeferredNullChecks(currentScope, actionInfo);
            loopingContext.complainOnDeferredFinalChecks(currentScope, actionInfo);
            loopingContext.complainOnDeferredNullChecks(currentScope, actionInfo);
            exitBranch.addPotentialInitializationsFrom(actionInfo.unconditionalInits()).addInitializationsFrom(condInfo.initsWhenFalse());
        }
        UnconditionalFlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches((loopingContext.initsOnBreak.tagBits & 1) != 0 ? loopingContext.initsOnBreak : flowInfo.addInitializationsFrom(loopingContext.initsOnBreak), isConditionOptimizedTrue, exitBranch, isConditionOptimizedFalse, !isConditionTrue);
        return mergedInfo;
    }

    public void resolve(BlockScope scope) {
        this.condition.resolveTypeExpecting(scope, TypeBinding.BOOLEAN);
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        WhileStatement.printIndent(tab, output).append("while (");
        this.condition.printExpression(0, output).append(')');
        if (this.action == null) {
            output.append(';');
        } else {
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.action != null) {
                this.action.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public int getASTType() {
        return 112;
    }
}

