/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.util.PublishHelper;

public class PublishOperation2
extends PublishOperation {
    protected TomcatServerBehaviour server;
    protected IModule[] module;
    protected int kind;
    protected int deltaKind;
    private PublishHelper helper;

    public PublishOperation2(TomcatServerBehaviour server, int kind, IModule[] module, int deltaKind) {
        super("Publish to server", "Publish Web module to Tomcat server");
        this.server = server;
        this.module = module;
        this.kind = kind;
        this.deltaKind = deltaKind;
        IPath base = server.getRuntimeBaseDirectory();
        this.helper = base != null ? new PublishHelper(base.append("temp").toFile()) : new PublishHelper(null);
    }

    public int getOrder() {
        return 0;
    }

    public int getKind() {
        return 2;
    }

    public void execute(IProgressMonitor monitor, IAdaptable info) throws CoreException {
        ArrayList status = new ArrayList();
        if (this.module.length == 1) {
            this.publishDir(this.module[0], status, monitor);
        } else {
            Properties p = this.server.loadModulePublishLocations();
            IWebModule webModule = (IWebModule)this.module[0].loadAdapter(IWebModule.class, monitor);
            String childURI = null;
            if (webModule != null) {
                childURI = webModule.getURI(this.module[1]);
            }
            IJ2EEModule childModule = (IJ2EEModule)this.module[1].loadAdapter(IJ2EEModule.class, monitor);
            boolean isBinary = false;
            if (childModule != null) {
                isBinary = childModule.isBinary();
            }
            if (isBinary) {
                this.publishArchiveModule(childURI, p, status, monitor);
            } else {
                this.publishJar(childURI, p, status, monitor);
            }
            this.server.saveModulePublishLocations(p);
        }
        PublishOperation2.throwException(status);
        this.server.setModulePublishState2(this.module, 1);
    }

    private void publishDir(IModule module2, List status, IProgressMonitor monitor) throws CoreException {
        IStatus[] stat;
        IPath path = this.server.getModuleDeployDirectory(module2);
        if (this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File f = path.toFile();
            if (f.exists()) {
                stat = PublishHelper.deleteDirectory((File)f, (IProgressMonitor)monitor);
                PublishOperation2.addArrayToList(status, stat);
            }
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (this.kind == 4 || this.kind == 2) {
            IModuleResource[] mr = this.server.getResources(this.module);
            stat = this.helper.publishFull(mr, path, monitor);
            PublishOperation2.addArrayToList(status, stat);
            return;
        }
        IModuleResourceDelta[] delta = this.server.getPublishedResourceDelta(this.module);
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IStatus[] stat2 = this.helper.publishDelta(delta[i], path, monitor);
            PublishOperation2.addArrayToList(status, stat2);
            ++i;
        }
    }

    private void publishJar(String jarURI, Properties p, List status, IProgressMonitor monitor) throws CoreException {
        IModuleResourceDelta[] delta;
        IPath jarPath;
        IPath path = this.server.getModuleDeployDirectory(this.module[0]);
        boolean moving = false;
        String oldURI = (String)p.get(this.module[1].getId());
        if (oldURI != null && jarURI != null) {
            boolean bl = moving = !oldURI.equals(jarURI);
        }
        if (jarURI == null) {
            jarURI = "WEB-INF/lib/" + this.module[1].getName() + ".jar";
        }
        IPath oldJarPath = jarPath = path.append(jarURI);
        if (oldURI != null) {
            oldJarPath = path.append(oldURI);
        }
        path = jarPath.removeLastSegments(1);
        if (moving || this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File file = oldJarPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            p.remove(this.module[1].getId());
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (!(moving || this.kind == 4 || this.kind == 2 || (delta = this.server.getPublishedResourceDelta(this.module)) != null && delta.length != 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this.server.getResources(this.module);
        IStatus[] stat = this.helper.publishZip(mr, jarPath, monitor);
        PublishOperation2.addArrayToList(status, stat);
        p.put(this.module[1].getId(), jarURI);
    }

    private void publishArchiveModule(String jarURI, Properties p, List status, IProgressMonitor monitor) {
        IModuleResourceDelta[] delta;
        IPath jarPath;
        IPath path = this.server.getModuleDeployDirectory(this.module[0]);
        boolean moving = false;
        String oldURI = (String)p.get(this.module[1].getId());
        if (oldURI != null && jarURI != null) {
            boolean bl = moving = !oldURI.equals(jarURI);
        }
        if (jarURI == null) {
            jarURI = "WEB-INF/lib/" + this.module[1].getName();
        }
        IPath oldJarPath = jarPath = path.append(jarURI);
        if (oldURI != null) {
            oldJarPath = path.append(oldURI);
        }
        path = jarPath.removeLastSegments(1);
        if (moving || this.kind == 4 || this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
            File file = oldJarPath.toFile();
            if (file.exists()) {
                file.delete();
            }
            p.remove(this.module[1].getId());
            if (this.deltaKind == 3 || this.server.getTomcatServer().isServeModulesWithoutPublish()) {
                return;
            }
        }
        if (!(moving || this.kind == 4 || this.kind == 2 || (delta = this.server.getPublishedResourceDelta(this.module)) != null && delta.length != 0)) {
            return;
        }
        if (!path.toFile().exists()) {
            path.toFile().mkdirs();
        }
        IModuleResource[] mr = this.server.getResources(this.module);
        IStatus[] stat = this.helper.publishToPath(mr, jarPath, monitor);
        PublishOperation2.addArrayToList(status, stat);
        p.put(this.module[1].getId(), jarURI);
    }

    protected static void throwException(List status) throws CoreException {
        if (status == null || status.size() == 0) {
            return;
        }
        if (status.size() == 1) {
            IStatus status2 = (IStatus)status.get(0);
            throw new CoreException(status2);
        }
        IStatus[] children = new IStatus[status.size()];
        status.toArray(children);
        String message = Messages.errorPublish;
        MultiStatus status2 = new MultiStatus("org.eclipse.jst.server.tomcat.core", 0, children, message, null);
        throw new CoreException((IStatus)status2);
    }

    protected static void addArrayToList(List list, IStatus[] a) {
        if (list == null || a == null || a.length == 0) {
            return;
        }
        int size = a.length;
        int i = 0;
        while (i < size) {
            list.add(a[i]);
            ++i;
        }
    }
}

