/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.ui.actions.ShowInSystemsViewDelegate;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class ShowResourceInSystemsViewDelegate
extends ShowInSystemsViewDelegate {
    public void run(IAction action) {
        if (this._selectedObject instanceof IResource) {
            IRemoteFile remoteObject = null;
            IResource resource = (IResource)this._selectedObject;
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            IPath location = resource.getLocation();
            if (location != null) {
                String fullPath = location.toOSString();
                IHost localHost = sr.getLocalHost();
                if (localHost != null) {
                    IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)localHost);
                    try {
                        remoteObject = ss.getRemoteFileObject(fullPath, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {}
                }
            } else {
                URI uri = resource.getLocationURI();
                String hostName = uri.getHost();
                String fullPath = uri.getPath();
                IHost host = null;
                ISystemProfile[] profiles = sr.getSystemProfileManager().getActiveSystemProfiles();
                int i = 0;
                while (i < profiles.length && host == null) {
                    ISystemProfile profile = profiles[i];
                    host = sr.getHost(profile, hostName);
                    ++i;
                }
                if (host != null) {
                    IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem(host);
                    try {
                        remoteObject = ss.getRemoteFileObject(fullPath, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception exception) {}
                }
            }
            if (remoteObject != null) {
                this._selectedObject = remoteObject;
            } else {
                return;
            }
        }
        super.run(action);
    }
}

