/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.command.internal.env.ui.widgets;

import java.util.Vector;
import org.eclipse.wst.command.internal.env.core.data.DataMappingRegistry;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragment;
import org.eclipse.wst.command.internal.env.core.fragment.CommandFragmentFactory;
import org.eclipse.wst.command.internal.env.core.fragment.SequenceFragment;
import org.eclipse.wst.command.internal.env.ui.widgets.CanFinishRegistry;
import org.eclipse.wst.command.internal.env.ui.widgets.CommandWidgetBinding;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetRegistry;

public class CommandWidgetBindingList
implements CommandWidgetBinding {
    private Vector bindings_;
    private Vector fragments_;
    private CommandFragmentFactory factory_;

    public CommandWidgetBindingList(Vector bindings, Vector fragments) {
        this.bindings_ = bindings;
        this.fragments_ = fragments;
    }

    public void registerCanFinish(CanFinishRegistry canFinishRegistry) {
        int length = this.bindings_.size();
        int index = 0;
        while (index < length) {
            CommandWidgetBinding binding = (CommandWidgetBinding)this.bindings_.elementAt(index);
            if (binding != null) {
                binding.registerCanFinish(canFinishRegistry);
            }
            ++index;
        }
    }

    public void registerDataMappings(DataMappingRegistry dataRegistry) {
        int length = this.bindings_.size();
        int index = 0;
        while (index < length) {
            CommandWidgetBinding binding = (CommandWidgetBinding)this.bindings_.elementAt(index);
            if (binding != null) {
                binding.registerDataMappings(dataRegistry);
            }
            ++index;
        }
    }

    public void registerWidgetMappings(WidgetRegistry widgetRegistry) {
        int length = this.bindings_.size();
        int index = 0;
        while (index < length) {
            CommandWidgetBinding binding = (CommandWidgetBinding)this.bindings_.elementAt(index);
            if (binding != null) {
                binding.registerWidgetMappings(widgetRegistry);
            }
            ++index;
        }
    }

    public CommandFragmentFactory create() {
        if (this.factory_ == null) {
            this.factory_ = new CommandFragmentFactory(){

                public CommandFragment create() {
                    SequenceFragment fragmentList = new SequenceFragment();
                    int length = CommandWidgetBindingList.this.bindings_.size();
                    int index = 0;
                    while (index < length) {
                        CommandWidgetBinding binding;
                        CommandFragment fragment = (CommandFragment)CommandWidgetBindingList.this.fragments_.elementAt(index);
                        if (fragment != null) {
                            fragmentList.add(fragment);
                        }
                        if ((binding = (CommandWidgetBinding)CommandWidgetBindingList.this.bindings_.elementAt(index)) != null) {
                            fragmentList.add(binding.create().create());
                        }
                        ++index;
                    }
                    return fragmentList;
                }
            };
        }
        return this.factory_;
    }
}

