/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletAntProjectBuilder;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletBuilderValidator;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDoxletAnnotationUtil;

public class XDocletBuilder
extends IncrementalProjectBuilder
implements IExecutableExtension {
    private static final String JAVASOURCE_TYPE = "org.eclipse.jdt.core.javaSource";
    private static final boolean performValidateEdit = false;
    private static final String[] XDOCLETBUILDINCLUDEFILES = new String[]{"ejb-jar.xml", "web.xml", "bean.java", "servlet.java", "controller.java", "ejb.java", "mdb.java"};
    private static boolean isGloballyEnabled = true;
    private String fName = "XDoclet Builder";

    public static void add(IProgressMonitor monitor, IProject project, Object validateEditContext) {
        if (project == null || !project.isAccessible()) {
            return;
        }
        boolean isBuilderPresent = false;
        try {
            IFile descriptionFile = project.getFile(".project");
            if (descriptionFile.exists() && descriptionFile.isAccessible()) {
                IProjectDescription description = project.getDescription();
                ICommand[] commands = description.getBuildSpec();
                if (commands != null) {
                    int i = 0;
                    while (i < commands.length) {
                        String builderName = commands[i].getBuilderName();
                        if (builderName != null && builderName.equals(XDocletBuilder.getBuilderId())) {
                            isBuilderPresent = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!isBuilderPresent && !monitor.isCanceled()) {
                    Object status = null;
                    if (status != null) {
                        status.isOK();
                    }
                    ICommand newCommand = description.newCommand();
                    newCommand.setBuilderName(XDocletBuilder.getBuilderId());
                    ICommand[] newCommands = null;
                    if (commands != null) {
                        newCommands = new ICommand[commands.length + 1];
                        System.arraycopy(commands, 0, newCommands, 0, commands.length);
                        newCommands[commands.length] = newCommand;
                    } else {
                        newCommands = new ICommand[]{newCommand};
                    }
                    description.setBuildSpec(newCommands);
                    try {
                        project.setDescription(description, monitor);
                    }
                    catch (CoreException coreException) {
                        Logger.log(2, "Description for project \"" + project.getName() + "\" could not be updated");
                    }
                }
            } else {
                Logger.log(2, "Description for project \"" + project.getName() + "\" could not be updated");
            }
        }
        catch (Exception e) {
            Logger.logException("Exception caught when adding Model Builder", e);
        }
    }

    public static synchronized void add(IProgressMonitor monitor, IWorkspaceRoot root, Object validateEditContext) {
        IProject[] allProjects = root.getProjects();
        IProgressMonitor localMonitor = monitor;
        localMonitor.beginTask("Starting to add builder to projects with EJB modules", 1);
        int i = 0;
        while (i < allProjects.length && !monitor.isCanceled()) {
            if (XDocletPreferenceStore.forProject(allProjects[i]).getBooleanProperty("XDOCLETBUILDERACTIVE")) {
                XDocletBuilder.add(localMonitor, allProjects[i], validateEditContext);
            }
            localMonitor.worked(1);
            ++i;
        }
        localMonitor.done();
    }

    public static String getBuilderId() {
        return "org.eclipse.jst.j2ee.ejb.annotations.internal.emitter.model.xdocletbuilder";
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject currentProject = this.getProject();
        boolean locallyEnabled = XDocletPreferenceStore.forProject(currentProject).getBooleanProperty("XDOCLETBUILDERACTIVE");
        if (!(locallyEnabled && currentProject != null && currentProject.isAccessible() && this.isValidRuntime(currentProject))) {
            return new IProject[]{currentProject};
        }
        IResourceDelta delta = this.getDelta(currentProject);
        IProgressMonitor localMonitor = monitor;
        localMonitor.beginTask(this.getDisplayName(), 1);
        if (!localMonitor.isCanceled()) {
            if (kind == 6 || kind == 15 || delta == null) {
                this.doFullBuild(kind, args, localMonitor, this.getProject());
            } else {
                this.doIncrementalBuild(kind, args, localMonitor);
            }
        }
        localMonitor.worked(1);
        localMonitor.done();
        return new IProject[]{this.getProject()};
    }

    void build(int kind, Map args, IResource resource, IContentType[] types, IProgressMonitor monitor) throws CoreException {
        XDocletAntProjectBuilder antProjectBuilder;
        boolean validRuntime;
        boolean bl = validRuntime = resource != null && this.isValidRuntime(resource.getProject());
        if (!monitor.isCanceled() && resource.getType() == 1 && validRuntime && (antProjectBuilder = XDocletAntProjectBuilder.Factory.newInstance(resource)) != null) {
            antProjectBuilder.buildUsingAnt(resource, monitor);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject currentProject = this.getProject();
        if (!isGloballyEnabled || currentProject == null || !currentProject.isAccessible()) {
            return;
        }
    }

    boolean isXDocletAnnotatedResource(IResource resource) {
        IContentType[] types = null;
        if (resource.getType() == 1 && resource.isAccessible()) {
            IContentDescription d = null;
            try {
                d = ((IFile)resource).getContentDescription();
                if (d != null && JAVASOURCE_TYPE.equals(d.getContentType().getId())) {
                    return XDoxletAnnotationUtil.isXDocletAnnotatedResource(resource);
                }
            }
            catch (CoreException coreException) {}
            types = Platform.getContentTypeManager().findContentTypesFor(resource.getName());
            int i = 0;
            while (i < types.length) {
                IContentType type = types[i];
                if (JAVASOURCE_TYPE.equals(type.getId())) {
                    return XDoxletAnnotationUtil.isXDocletAnnotatedResource(resource);
                }
                ++i;
            }
            return false;
        }
        if (resource.getType() == 1 && !resource.isAccessible()) {
            String name = resource.getName();
            int i = 0;
            while (name != null && i < XDOCLETBUILDINCLUDEFILES.length) {
                String fileName = XDOCLETBUILDINCLUDEFILES[i];
                if (name.toLowerCase().endsWith(fileName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void doFullBuild(int kind, Map args, IProgressMonitor monitor, IProject project) {
        final IProgressMonitor subMonitor = monitor;
        final int localKind = kind;
        final Map localArgs = args;
        final IProgressMonitor visitorMonitor = monitor;
        IResourceVisitor internalBuilder = new IResourceVisitor(){
            boolean buildComplete = false;

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1 && !this.buildComplete) {
                    if (!this.buildComplete && XDocletBuilder.this.isXDocletAnnotatedResource(resource)) {
                        XDocletBuilder.this.build(localKind, localArgs, resource, null, subMonitor);
                        this.buildComplete = true;
                        visitorMonitor.worked(1);
                    }
                    return false;
                }
                return true;
            }
        };
        try {
            project.accept(internalBuilder);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    protected void doIncrementalBuild(int kind, Map args, IProgressMonitor monitor) {
        IResourceDelta projectDelta = this.getDelta(this.getProject());
        if (projectDelta == null) {
            throw new IllegalArgumentException("delta is null, should do a full build");
        }
        final Map localArgs = args;
        final int localKind = kind;
        final IProgressMonitor localMonitor = monitor;
        IResourceDeltaVisitor participantVisitor = new IResourceDeltaVisitor(){
            boolean buildComplete = false;

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (!localMonitor.isCanceled() && delta.getResource().getType() == 1 && !this.buildComplete && XDocletBuilder.this.isXDocletAnnotatedResource(delta.getResource())) {
                    XDocletBuilder.this.build(localKind, localArgs, delta.getResource(), null, localMonitor);
                    this.buildComplete = true;
                }
                return delta.getAffectedChildren().length > 0;
            }
        };
        try {
            projectDelta.accept(participantVisitor);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        monitor.worked(1);
    }

    private String getDisplayName() {
        return this.fName;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (config != null) {
            this.fName = config.getDeclaringExtension().getLabel();
        }
    }

    public static void shutdown() {
    }

    public static void startup() {
    }

    public boolean isValidRuntime(IProject currentProject) {
        XDocletBuilderValidator validator = new XDocletBuilderValidator();
        boolean valid = false;
        try {
            valid = validator.validate(currentProject);
        }
        catch (CoreException coreException) {}
        return valid;
    }
}

