/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project.facet;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class EarFacetRuntimeHandler {
    private EarFacetRuntimeHandler() {
    }

    public static void updateModuleProjectRuntime(IProject earProject, IProject moduleProject, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            IFacetedProject earFacetedProject = ProjectFacetsManager.create((IProject)earProject);
            IRuntime earRuntime = earFacetedProject.getRuntime();
            IFacetedProject moduleFacetedProject = ProjectFacetsManager.create((IProject)moduleProject);
            if (moduleFacetedProject != null && !EarFacetRuntimeHandler.equals(earRuntime, moduleFacetedProject.getRuntime())) {
                boolean supports = true;
                if (earRuntime != null) {
                    for (IProjectFacetVersion fver : moduleFacetedProject.getProjectFacets()) {
                        if (earRuntime.supports(fver)) continue;
                        supports = false;
                        break;
                    }
                }
                if (supports) {
                    moduleFacetedProject.setRuntime(earRuntime, EarFacetRuntimeHandler.submon(monitor, 1));
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void updateModuleProjectRuntime(IProject earProject, Set moduleProjects, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", moduleProjects.size());
        }
        try {
            for (IProject moduleProject : moduleProjects) {
                EarFacetRuntimeHandler.updateModuleProjectRuntime(earProject, moduleProject, EarFacetRuntimeHandler.submon(monitor, 1));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return parent == null ? null : new SubProgressMonitor(parent, ticks);
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static final class RuntimeChangedDelegate
    implements IDelegate {
        public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
            if (monitor != null) {
                monitor.beginTask("", 10);
            }
            try {
                HashSet<IProject> moduleProjects = new HashSet<IProject>();
                IVirtualComponent earvc = ComponentCore.createComponent((IProject)project);
                IVirtualReference[] vrefs = earvc.getReferences();
                int i = 0;
                while (i < vrefs.length) {
                    IVirtualReference vref = vrefs[i];
                    IVirtualComponent vc = vref.getReferencedComponent();
                    moduleProjects.add(vc.getProject());
                    ++i;
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                EarFacetRuntimeHandler.updateModuleProjectRuntime(project, moduleProjects, EarFacetRuntimeHandler.submon(monitor, 9));
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

