/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.actions.FindAction;
import org.eclipse.jdt.ui.actions.FindReferencesAction;
import org.eclipse.jdt.ui.actions.FindReferencesInHierarchyAction;
import org.eclipse.jdt.ui.actions.FindReferencesInProjectAction;
import org.eclipse.jdt.ui.actions.FindReferencesInWorkingSetAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jdt.ui.actions.WorkingSetFindAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class ReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_references;
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindReferencesAction fFindReferencesAction;
    private FindReferencesInProjectAction fFindReferencesInProjectAction;
    private FindReferencesInHierarchyAction fFindReferencesInHierarchyAction;
    private FindReferencesInWorkingSetAction fFindReferencesInWorkingSetAction;

    public ReferencesSearchGroup(IWorkbenchSite site) {
        this(site, null);
    }

    public ReferencesSearchGroup(IWorkbenchSite site, ISelectionProvider specialSelectionProvider) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fFindReferencesAction = new FindReferencesAction(site);
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.workspace");
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(site);
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.project");
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(site);
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.hierarchy");
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(site);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.working.set");
        ISelectionProvider provider = specialSelectionProvider == null ? this.fSite.getSelectionProvider() : specialSelectionProvider;
        ISelection selection = provider.getSelection();
        this.registerAction(this.fFindReferencesAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindReferencesInProjectAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindReferencesInHierarchyAction, provider, selection, specialSelectionProvider);
        this.registerAction(this.fFindReferencesInWorkingSetAction, provider, selection, specialSelectionProvider);
    }

    public ReferencesSearchGroup(JavaEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fFindReferencesAction = new FindReferencesAction(editor);
        this.fFindReferencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.workspace");
        this.fEditor.setAction("SearchReferencesInWorkspace", (IAction)this.fFindReferencesAction);
        this.fFindReferencesInProjectAction = new FindReferencesInProjectAction(this.fEditor);
        this.fFindReferencesInProjectAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.project");
        this.fEditor.setAction("SearchReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
        this.fFindReferencesInHierarchyAction = new FindReferencesInHierarchyAction(this.fEditor);
        this.fFindReferencesInHierarchyAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.hierarchy");
        this.fEditor.setAction("SearchReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
        this.fFindReferencesInWorkingSetAction = new FindReferencesInWorkingSetAction(this.fEditor);
        this.fFindReferencesInWorkingSetAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.references.in.working.set");
        this.fEditor.setAction("SearchReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection, ISelectionProvider specialSelectionProvider) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
        if (specialSelectionProvider != null) {
            action.setSpecialSelectionProvider(specialSelectionProvider);
        }
    }

    protected String getName() {
        return MENU_TEXT;
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
        WorkingSetFindAction action = this.fEditor != null ? new WorkingSetFindAction(this.fEditor, (FindAction)new FindReferencesInWorkingSetAction(this.fEditor, workingSets), SearchUtil.toString(workingSets)) : new WorkingSetFindAction(this.fSite, (FindAction)new FindReferencesInWorkingSetAction(this.fSite, workingSets), SearchUtil.toString(workingSets));
        action.update(this.getContext().getSelection());
        this.addAction((IAction)action, manager);
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager javaSearchMM = new MenuManager(this.getName(), "group.search");
        this.addAction((IAction)this.fFindReferencesAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReferencesInProjectAction, (IMenuManager)javaSearchMM);
        this.addAction((IAction)this.fFindReferencesInHierarchyAction, (IMenuManager)javaSearchMM);
        javaSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)javaSearchMM);
        }
        this.addAction((IAction)this.fFindReferencesInWorkingSetAction, (IMenuManager)javaSearchMM);
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindReferencesAction, provider);
            this.disposeAction(this.fFindReferencesInProjectAction, provider);
            this.disposeAction(this.fFindReferencesInHierarchyAction, provider);
            this.disposeAction(this.fFindReferencesInWorkingSetAction, provider);
        }
        this.fFindReferencesAction = null;
        this.fFindReferencesInProjectAction = null;
        this.fFindReferencesInHierarchyAction = null;
        this.fFindReferencesInWorkingSetAction = null;
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReferencesInWorkspace", (IAction)this.fFindReferencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReferencesInProject", (IAction)this.fFindReferencesInProjectAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReferencesInHierarchy", (IAction)this.fFindReferencesInHierarchyAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ReferencesInWorkingSet", (IAction)this.fFindReferencesInWorkingSetAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

