/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public class ASTNodeSearchUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    private ASTNodeSearchUtil() {
    }

    public static ASTNode[] getAstNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.getAstNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode getAstNode(SearchMatch searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = ASTNodeSearchUtil.getAstNode(cuNode, searchResult.getOffset(), searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }

    public static ASTNode getAstNode(CompilationUnit cuNode, int start, int length) {
        SelectionAnalyzer analyzer = new SelectionAnalyzer(Selection.createFromStartLength(start, length), true);
        cuNode.accept((ASTVisitor)analyzer);
        ASTNode node = analyzer.getFirstSelectedNode();
        if (node == null && analyzer.getLastCoveringNode() instanceof SuperConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        } else if (node == null && analyzer.getLastCoveringNode() instanceof ConstructorInvocation) {
            node = analyzer.getLastCoveringNode().getParent();
        }
        if (node == null) {
            return null;
        }
        ASTNode parentNode = node.getParent();
        if (parentNode instanceof MethodDeclaration) {
            MethodDeclaration md = (MethodDeclaration)parentNode;
            if (!(node instanceof SimpleName) && md.isConstructor() && md.getBody() != null && md.getBody().statements().size() > 0 && (md.getBody().statements().get(0) instanceof ConstructorInvocation || md.getBody().statements().get(0) instanceof SuperConstructorInvocation) && ((ASTNode)md.getBody().statements().get(0)).getLength() == length + 1) {
                return (ASTNode)md.getBody().statements().get(0);
            }
        }
        if (parentNode instanceof SuperConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        if (parentNode instanceof ConstructorInvocation && parentNode.getLength() == length + 1) {
            return parentNode;
        }
        return node;
    }

    public static MethodDeclaration getMethodDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iMethod, cuNode);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static AnnotationTypeMemberDeclaration getAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iMethod, cuNode);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AnnotationTypeMemberDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static BodyDeclaration getMethodOrAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit cuNode) throws JavaModelException {
        if (JdtFlags.isAnnotation((IMember)iMethod.getDeclaringType())) {
            return ASTNodeSearchUtil.getAnnotationTypeMemberDeclarationNode(iMethod, cuNode);
        }
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, cuNode);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode);
        if (node instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)node;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(node, clazz);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (FieldDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static EnumConstantDeclaration getEnumConstantDeclaration(IField iField, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iField, cuNode);
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.jdt.core.dom.EnumConstantDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EnumConstantDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static BodyDeclaration getFieldOrEnumConstantDeclaration(IField iField, CompilationUnit cuNode) throws JavaModelException {
        if (JdtFlags.isEnum((IMember)iField)) {
            return ASTNodeSearchUtil.getEnumConstantDeclaration(iField, cuNode);
        }
        return ASTNodeSearchUtil.getFieldDeclarationNode(iField, cuNode);
    }

    public static EnumDeclaration getEnumDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode);
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.jdt.core.dom.EnumDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EnumDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static AnnotationTypeDeclaration getAnnotationTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.jdt.core.dom.AnnotationTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AnnotationTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static BodyDeclaration getBodyDeclarationNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode(iMember, cuNode);
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BodyDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static AbstractTypeDeclaration getAbstractTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode);
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("org.eclipse.jdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode);
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static ClassInstanceCreation getClassInstanceCreationNode(IType iType, CompilationUnit cuNode) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, cuNode);
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.jdt.core.dom.ClassInstanceCreation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz);
    }

    public static List getBodyDeclarationList(IType iType, CompilationUnit cuNode) throws JavaModelException {
        if (iType.isAnonymous()) {
            return ASTNodeSearchUtil.getClassInstanceCreationNode(iType, cuNode).getAnonymousClassDeclaration().bodyDeclarations();
        }
        return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, cuNode).bodyDeclarations();
    }

    public static ASTNode[] getDeclarationNodes(IJavaElement element, CompilationUnit cuNode) throws JavaModelException {
        switch (element.getElementType()) {
            case 8: {
                return new ASTNode[]{ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)element, cuNode)};
            }
            case 12: {
                return ASTNodeSearchUtil.getImportNodes((IImportContainer)element, cuNode);
            }
            case 13: {
                return new ASTNode[]{ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)element, cuNode)};
            }
            case 10: {
                return new ASTNode[]{ASTNodeSearchUtil.getInitializerNode((IInitializer)element, cuNode)};
            }
            case 9: {
                return new ASTNode[]{ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)element, cuNode)};
            }
            case 11: {
                return new ASTNode[]{ASTNodeSearchUtil.getPackageDeclarationNode((IPackageDeclaration)element, cuNode)};
            }
            case 7: {
                return new ASTNode[]{ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)element, cuNode)};
            }
        }
        Assert.isTrue((boolean)false, (String)String.valueOf(element.getElementType()));
        return null;
    }

    private static ASTNode getNameNode(IMember iMember, CompilationUnit cuNode) throws JavaModelException {
        return NodeFinder.perform((ASTNode)cuNode, (ISourceRange)iMember.getNameRange());
    }

    public static PackageDeclaration getPackageDeclarationNode(IPackageDeclaration reference, CompilationUnit cuNode) throws JavaModelException {
        return (PackageDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ImportDeclaration getImportDeclarationNode(IImportDeclaration reference, CompilationUnit cuNode) throws JavaModelException {
        return (ImportDeclaration)ASTNodeSearchUtil.findNode(reference.getSourceRange(), cuNode);
    }

    public static ASTNode[] getImportNodes(IImportContainer reference, CompilationUnit cuNode) throws JavaModelException {
        IJavaElement[] imps = reference.getChildren();
        ASTNode[] result = new ASTNode[imps.length];
        int i = 0;
        while (i < imps.length) {
            result[i] = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)imps[i], cuNode);
            ++i;
        }
        return result;
    }

    public static Initializer getInitializerNode(IInitializer initializer, CompilationUnit cuNode) throws JavaModelException {
        ASTNode node = ASTNodeSearchUtil.findNode(initializer.getSourceRange(), cuNode);
        if (node instanceof Initializer) {
            return (Initializer)node;
        }
        if (node instanceof Block && node.getParent() instanceof Initializer) {
            return (Initializer)node.getParent();
        }
        return null;
    }

    private static ASTNode findNode(ISourceRange range, CompilationUnit cuNode) {
        NodeFinder nodeFinder = new NodeFinder((ASTNode)cuNode, range.getOffset(), range.getLength());
        ASTNode coveredNode = nodeFinder.getCoveredNode();
        if (coveredNode != null) {
            return coveredNode;
        }
        return nodeFinder.getCoveringNode();
    }

    public static ASTNode[] findNodes(SearchMatch[] searchResults, CompilationUnit cuNode) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(searchResults.length);
        int i = 0;
        while (i < searchResults.length) {
            ASTNode node = ASTNodeSearchUtil.findNode(searchResults[i], cuNode);
            if (node != null) {
                result.add(node);
            }
            ++i;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    public static ASTNode findNode(SearchMatch searchResult, CompilationUnit cuNode) {
        ASTNode selectedNode = NodeFinder.perform((ASTNode)cuNode, (int)searchResult.getOffset(), (int)searchResult.getLength());
        if (selectedNode == null) {
            return null;
        }
        if (selectedNode.getParent() == null) {
            return null;
        }
        return selectedNode;
    }
}

