/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.refactoring.IRefactoringSearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.rename.TypeOccurrenceCollector;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public final class CreateCopyOfCompilationUnitChange
extends CreateTextFileChange {
    private final INewNameQuery fNameQuery;
    private final ICompilationUnit fOldCu;
    static /* synthetic */ Class class$0;

    private static TextChangeManager createChangeManager(IProgressMonitor monitor, ICompilationUnit copy, String newName) throws CoreException {
        TextChangeManager manager = new TextChangeManager();
        SearchResultGroup refs = CreateCopyOfCompilationUnitChange.getReferences(copy, monitor);
        if (refs == null) {
            return manager;
        }
        if (refs.getCompilationUnit() == null) {
            return manager;
        }
        String name = RefactoringCoreMessages.CopyRefactoring_update_ref;
        SearchMatch[] results = refs.getSearchResults();
        int j = 0;
        while (j < results.length) {
            SearchMatch searchResult = results[j];
            if (searchResult.getAccuracy() != 1) {
                int offset = searchResult.getOffset();
                int length = searchResult.getLength();
                TextChangeCompatibility.addTextEdit(manager.get(copy), name, (TextEdit)new ReplaceEdit(offset, length, newName));
            }
            ++j;
        }
        return manager;
    }

    private static SearchPattern createSearchPattern(IType type) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)type, (int)3, (int)24);
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        if (constructors.length == 0) {
            return pattern;
        }
        SearchPattern constructorDeclarationPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])constructors, 0);
        return SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)constructorDeclarationPattern);
    }

    private static String getCopiedFileSource(IProgressMonitor monitor, ICompilationUnit unit, String newTypeName) throws CoreException {
        ICompilationUnit copy = unit.getPrimary().getWorkingCopy(null);
        try {
            String result;
            TextChangeManager manager = CreateCopyOfCompilationUnitChange.createChangeManager(monitor, copy, newTypeName);
            String string = result = manager.get(copy).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
            return string;
        }
        finally {
            copy.discardWorkingCopy();
        }
    }

    private static SearchResultGroup getReferences(final ICompilationUnit copy, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] copies = new ICompilationUnit[]{copy};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])copies);
        IType type = copy.findPrimaryType();
        if (type == null) {
            return null;
        }
        SearchPattern pattern = CreateCopyOfCompilationUnitChange.createSearchPattern(type);
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(pattern);
        engine.setScope(scope);
        engine.setWorkingCopies(copies);
        engine.setRequestor(new IRefactoringSearchRequestor(type){
            TypeOccurrenceCollector fTypeOccurrenceCollector;
            {
                this.fTypeOccurrenceCollector = new TypeOccurrenceCollector(iType);
            }

            public SearchMatch acceptSearchMatch(SearchMatch match) {
                try {
                    return this.fTypeOccurrenceCollector.acceptSearchMatch2(copy, match);
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                    return null;
                }
            }
        });
        engine.searchPattern(monitor);
        Object[] results = engine.getResults();
        int index = 0;
        while (index < results.length) {
            SearchResultGroup group = (SearchResultGroup)results[index];
            if (group.getCompilationUnit().equals(copy)) {
                return group;
            }
            ++index;
        }
        return null;
    }

    public CreateCopyOfCompilationUnitChange(IPath path, String source, ICompilationUnit oldCu, INewNameQuery nameQuery) {
        super(path, source, null, "java");
        this.fOldCu = oldCu;
        this.fNameQuery = nameQuery;
        this.setEncoding(oldCu);
    }

    public String getName() {
        String cuName = BasicElementLabels.getResourceName(this.fOldCu.getElementName());
        String cuContainerName = BasicElementLabels.getPathLabel(this.fOldCu.getParent().getPath(), false);
        return Messages.format(RefactoringCoreMessages.CreateCopyOfCompilationUnitChange_create_copy, new String[]{cuName, cuContainerName});
    }

    protected IFile getOldFile(IProgressMonitor monitor) throws OperationCanceledException {
        try {
            monitor.beginTask("", 12);
            String oldSource = super.getSource();
            IPath oldPath = super.getPath();
            String newTypeName = this.fNameQuery.getNewName();
            try {
                String newSource = CreateCopyOfCompilationUnitChange.getCopiedFileSource((IProgressMonitor)new SubProgressMonitor(monitor, 9), this.fOldCu, newTypeName);
                this.setSource(newSource);
                this.setPath(this.fOldCu.getResource().getParent().getFullPath().append(JavaModelUtil.getRenamedCUName(this.fOldCu, newTypeName)));
                IFile iFile = super.getOldFile((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                return iFile;
            }
            catch (CoreException coreException) {
                this.setSource(oldSource);
                this.setPath(oldPath);
                IFile iFile = super.getOldFile((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                monitor.done();
                return iFile;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void markAsExecuted(ICompilationUnit unit, ResourceMapping mapping) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)unit);
            log.markAsProcessed((Object)mapping);
        }
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        ResourceMapping mapping = JavaElementResourceMapping.create(this.fOldCu);
        Change result = super.perform(monitor);
        this.markAsExecuted(this.fOldCu, mapping);
        return result;
    }

    private void setEncoding(ICompilationUnit unit) {
        IResource resource = unit.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        try {
            String encoding = file.getCharset(false);
            if (encoding != null) {
                this.setEncoding(encoding, true);
            } else {
                encoding = file.getCharset(true);
                if (encoding != null) {
                    this.setEncoding(encoding, false);
                }
            }
        }
        catch (CoreException coreException) {}
    }
}

