/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.KeyValuePair;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSUtil;
import org.eclipse.jdt.internal.corext.refactoring.nls.SimpleLineReader;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class PropertyFileDocumentModel {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private List fKeyValuePairs;
    private String fLineDelimiter;

    public PropertyFileDocumentModel(IDocument document) {
        this.parsePropertyDocument(document);
        this.fLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
    }

    public String getLineDelimiter() {
        return this.fLineDelimiter;
    }

    public KeyValuePair getKeyValuePair(String key) {
        int i = 0;
        while (i < this.fKeyValuePairs.size()) {
            KeyValuePairModell keyValuePair = (KeyValuePairModell)this.fKeyValuePairs.get(i);
            if (keyValuePair.getKey().equals(key)) {
                return keyValuePair;
            }
            ++i;
        }
        return null;
    }

    private InsertEdit insert(KeyValuePair keyValuePair) {
        KeyValuePairModell keyValuePairModell = new KeyValuePairModell(keyValuePair);
        int index = this.findInsertPosition(keyValuePairModell);
        KeyValuePairModell insertHere = (KeyValuePairModell)this.fKeyValuePairs.get(index);
        int offset = insertHere.fOffset;
        String extra = "";
        if (insertHere instanceof LastKeyValuePair && ((LastKeyValuePair)insertHere).needsNewLine()) {
            extra = this.fLineDelimiter;
            ((LastKeyValuePair)insertHere).resetNeedsNewLine();
            offset -= insertHere.fLeadingWhiteSpaces;
        } else if (index > 0) {
            int distAfter;
            String beforeKey = ((KeyValuePair)this.fKeyValuePairs.get((int)(index - 1))).fKey;
            String afterKey = insertHere.fKey;
            String key = keyValuePair.fKey;
            int distBefore = NLSUtil.invertDistance(key, beforeKey);
            if (distBefore > (distAfter = NLSUtil.invertDistance(key, afterKey))) {
                offset -= insertHere.fLeadingWhiteSpaces;
            } else if (distBefore == distAfter && Collator.getInstance().compare(beforeKey, afterKey) < 0) {
                offset -= insertHere.fLeadingWhiteSpaces;
            } else {
                keyValuePairModell.fLeadingWhiteSpaces = insertHere.fLeadingWhiteSpaces;
                insertHere.fLeadingWhiteSpaces = 0;
            }
        }
        keyValuePairModell.fOffset = offset;
        this.fKeyValuePairs.add(index, keyValuePairModell);
        return new InsertEdit(offset, String.valueOf(extra) + keyValuePairModell.getKeyValueText());
    }

    public void insert(KeyValuePair[] keyValuePairs, TextChange change) {
        ArrayList<KeyValuePair> sorted = new ArrayList<KeyValuePair>(Arrays.asList(keyValuePairs));
        Collections.sort(sorted, new Comparator(){

            public int compare(Object o1, Object o2) {
                KeyValuePair p1 = (KeyValuePair)o1;
                KeyValuePair p2 = (KeyValuePair)o2;
                return Collator.getInstance().compare(p1.fKey, p2.fKey);
            }
        });
        int i = 0;
        while (i < sorted.size()) {
            KeyValuePair curr = sorted.get(i);
            InsertEdit insertEdit = this.insert(curr);
            String message = Messages.format(NLSMessages.NLSPropertyFileModifier_add_entry, BasicElementLabels.getJavaElementName(curr.getKey()));
            TextChangeCompatibility.addTextEdit(change, message, (TextEdit)insertEdit);
            ++i;
        }
    }

    public DeleteEdit remove(String key) {
        Iterator iter = this.fKeyValuePairs.iterator();
        while (iter.hasNext()) {
            KeyValuePairModell keyValuePair = (KeyValuePairModell)iter.next();
            if (!keyValuePair.fKey.equals(key)) continue;
            return new DeleteEdit(keyValuePair.fOffset, keyValuePair.getLength());
        }
        return null;
    }

    public ReplaceEdit replace(KeyValuePair toReplace, KeyValuePair replaceWith) {
        Iterator iter = this.fKeyValuePairs.iterator();
        while (iter.hasNext()) {
            KeyValuePairModell keyValuePair = (KeyValuePairModell)iter.next();
            if (!keyValuePair.fKey.equals(toReplace.getKey())) continue;
            String newText = new KeyValuePairModell(replaceWith).getKeyValueText();
            return new ReplaceEdit(keyValuePair.fOffset, keyValuePair.getLength(), newText);
        }
        return null;
    }

    private int findInsertPosition(KeyValuePairModell keyValuePair) {
        ArrayList<String> keys = new ArrayList<String>();
        int i = 0;
        while (i < this.fKeyValuePairs.size()) {
            KeyValuePairModell element = (KeyValuePairModell)this.fKeyValuePairs.get(i);
            if (!(element instanceof LastKeyValuePair)) {
                keys.add(element.getKey());
            }
            ++i;
        }
        int insertIndex = NLSUtil.getInsertionPosition(keyValuePair.getKey(), keys);
        if (insertIndex < this.fKeyValuePairs.size() - 1) {
            ++insertIndex;
        }
        return insertIndex;
    }

    private void parsePropertyDocument(IDocument document) {
        this.fKeyValuePairs = new ArrayList();
        SimpleLineReader reader = new SimpleLineReader(document);
        int offset = 0;
        String line = reader.readLine();
        int leadingWhiteSpaces = 0;
        while (line != null) {
            if (!SimpleLineReader.isCommentOrWhiteSpace(line)) {
                int idx = this.getIndexOfSeparationCharacter(line);
                if (idx != -1) {
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    this.fKeyValuePairs.add(new KeyValuePairModell(key, value, offset, leadingWhiteSpaces));
                    leadingWhiteSpaces = 0;
                }
            } else {
                leadingWhiteSpaces += line.length();
            }
            offset += line.length();
            line = reader.readLine();
        }
        int lastLine = document.getNumberOfLines() - 1;
        boolean needsNewLine = false;
        try {
            needsNewLine = document.getLineLength(lastLine) != 0;
        }
        catch (BadLocationException badLocationException) {}
        LastKeyValuePair lastKeyValuePair = new LastKeyValuePair(offset, needsNewLine);
        this.fKeyValuePairs.add(lastKeyValuePair);
    }

    private int getIndexOfSeparationCharacter(String line) {
        int minIndex = -1;
        int indexOfEven = line.indexOf(61);
        int indexOfColumn = line.indexOf(58);
        int indexOfBlank = line.indexOf(32);
        minIndex = indexOfEven != -1 && indexOfColumn != -1 ? Math.min(indexOfEven, indexOfColumn) : Math.max(indexOfEven, indexOfColumn);
        minIndex = minIndex != -1 && indexOfBlank != -1 ? Math.min(minIndex, indexOfBlank) : Math.max(minIndex, indexOfBlank);
        return minIndex;
    }

    public static String unwindEscapeChars(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int length = s.length();
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            sb.append(PropertyFileDocumentModel.getUnwoundString(c));
            ++i;
        }
        return sb.toString();
    }

    public static String unwindValue(String value) {
        return PropertyFileDocumentModel.escapeLeadingWhiteSpaces(PropertyFileDocumentModel.escapeCommentChars(PropertyFileDocumentModel.unwindEscapeChars(value)));
    }

    private static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ' || c > '~') {
            return "" + '\\' + 'u' + PropertyFileDocumentModel.toHex(c >> 12 & 0xF) + PropertyFileDocumentModel.toHex(c >> 8 & 0xF) + PropertyFileDocumentModel.toHex(c >> 4 & 0xF) + PropertyFileDocumentModel.toHex(c & 0xF);
        }
        return String.valueOf(c);
    }

    private static char toHex(int halfByte) {
        return HEX_DIGITS[halfByte & 0xF];
    }

    private static String escapeCommentChars(String string) {
        StringBuffer sb = new StringBuffer(string.length() + 5);
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '!': {
                    sb.append("\\!");
                    break;
                }
                case '#': {
                    sb.append("\\#");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static String escapeLeadingWhiteSpaces(String str) {
        int firstNonWhiteSpace = PropertyFileDocumentModel.findFirstNonWhiteSpace(str);
        StringBuffer buf = new StringBuffer(firstNonWhiteSpace);
        int i = 0;
        while (i < firstNonWhiteSpace) {
            buf.append('\\');
            buf.append(str.charAt(i));
            ++i;
        }
        buf.append(str.substring(firstNonWhiteSpace));
        return buf.toString();
    }

    private static int findFirstNonWhiteSpace(String s) {
        int i = 0;
        while (i < s.length()) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return i;
            }
            ++i;
        }
        return s.length();
    }

    private static class KeyValuePairModell
    extends KeyValuePair {
        int fOffset;
        int fLeadingWhiteSpaces;

        public KeyValuePairModell(String key, String value, int offset, int leadingWhiteSpaces) {
            super(key, value);
            this.fOffset = offset;
            this.fLeadingWhiteSpaces = leadingWhiteSpaces;
        }

        public KeyValuePairModell(KeyValuePair keyValuePair) {
            super(keyValuePair.fKey, keyValuePair.fValue);
        }

        public int getLength() {
            return this.fKey.length() + 1 + this.fValue.length();
        }

        private String getKeyValueText() {
            return String.valueOf(this.fKey) + '=' + this.fValue;
        }
    }

    private static class LastKeyValuePair
    extends KeyValuePairModell {
        private boolean fNeedsNewLine;

        public LastKeyValuePair(int offset, boolean needsNewLine) {
            super("zzzzzzz", "key", offset, 0);
            this.fNeedsNewLine = needsNewLine;
        }

        public boolean needsNewLine() {
            return this.fNeedsNewLine;
        }

        public void resetNeedsNewLine() {
            this.fNeedsNewLine = false;
        }
    }
}

