/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;

public class Invocations {
    public static List getArguments(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).arguments();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).arguments();
            }
            case 17: {
                return ((ConstructorInvocation)invocation).arguments();
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static Expression getExpression(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).getExpression();
            }
            case 17: 
            case 48: {
                return null;
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static boolean isInvocation(ASTNode node) {
        int type = node.getNodeType();
        return type == 32 || type == 48 || type == 17;
    }

    public static IMethodBinding resolveBinding(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).resolveMethodBinding();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).resolveMethodBinding();
            }
            case 17: {
                return ((ConstructorInvocation)invocation).resolveConstructorBinding();
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static boolean isResolvedTypeInferredFromExpectedType(Expression invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).isResolvedTypeInferredFromExpectedType();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).isResolvedTypeInferredFromExpectedType();
            }
            case 17: {
                return false;
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }

    public static ChildListPropertyDescriptor getTypeArgumentsProperty(Expression invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return MethodInvocation.TYPE_ARGUMENTS_PROPERTY;
            }
            case 48: {
                return SuperMethodInvocation.TYPE_ARGUMENTS_PROPERTY;
            }
            case 17: {
                return ConstructorInvocation.TYPE_ARGUMENTS_PROPERTY;
            }
        }
        throw new IllegalArgumentException(invocation.toString());
    }
}

